/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.edit.parts;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.epf.diagram.ad.custom.policies.ActivityCreationEditPolicy;
import org.eclipse.epf.diagram.ad.custom.policies.ActivityXYLayoutEditPolicy;
import org.eclipse.epf.diagram.ad.edit.policies.ActivityCanonicalEditPolicy;
import org.eclipse.epf.diagram.ad.edit.policies.ActivityItemSemanticEditPolicy;
import org.eclipse.epf.diagram.ad.part.ActivityDiagramEditorPlugin;
import org.eclipse.epf.diagram.core.part.util.DiagramEditorUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class ActivityEditPart
extends DiagramEditPart {
    public static final String MODEL_ID = "AD";
    public static final int VISUAL_ID = 79;

    public ActivityEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ActivityItemSemanticEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new ActivityCanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ActivityXYLayoutEditPolicy());
        this.installEditPolicy("CreationPolicy", (EditPolicy)new ActivityCreationEditPolicy());
    }

    protected void handleNotificationEvent(Notification notification) {
        if (NotationPackage.Literals.VIEW__VISIBLE.equals(notification.getFeature())) {
            Object object = notification.getNotifier();
            if (object == this.getModel()) {
                this.refreshVisibility();
            } else if (notification.getNotifier() instanceof Node) {
                this.refreshChildren();
                DiagramEditorUtil.refreshConnectionEditParts((DiagramEditPart)this);
            }
        } else {
            super.handleNotificationEvent(notification);
        }
    }

    private void refreshConnections() {
        block9: {
            org.eclipse.gef.ConnectionEditPart connectionEditPart;
            Diagram diagram = (Diagram)this.getModel();
            EList eList = diagram.getEdges();
            for (Edge edge : eList) {
                Object object;
                if (!edge.isVisible() || (connectionEditPart = this.createOrFindConnection(edge)) == null) continue;
                if (connectionEditPart.getSource() == null) {
                    for (EditPart editPart : this.getChildren()) {
                        object = editPart.getModel();
                        if (edge.getSource() != object || !(editPart instanceof GraphicalEditPart)) continue;
                        if (((GraphicalEditPart)editPart).getFigure().isVisible()) {
                            connectionEditPart.setSource(editPart);
                            continue;
                        }
                        connectionEditPart.setSource(null);
                    }
                }
                if (connectionEditPart.getTarget() != null) continue;
                for (EditPart editPart : this.getChildren()) {
                    object = editPart.getModel();
                    if (edge.getTarget() != object || !(editPart instanceof GraphicalEditPart)) continue;
                    if (((GraphicalEditPart)editPart).getFigure().isVisible()) {
                        connectionEditPart.setTarget(editPart);
                        continue;
                    }
                    connectionEditPart.setTarget(null);
                }
            }
            try {
                for (Edge edge : eList) {
                    connectionEditPart = (ConnectionEditPart)this.createOrFindConnection(edge);
                    if (connectionEditPart.getSource() != null && connectionEditPart.getTarget() != null || connectionEditPart.getFigure() == null) continue;
                    connectionEditPart.getFigure().setVisible(false);
                    connectionEditPart.getFigure().revalidate();
                    connectionEditPart.deactivate();
                }
            }
            catch (Exception exception) {
                if (!ActivityDiagramEditorPlugin.getInstance().isDebugging()) break block9;
                ActivityDiagramEditorPlugin.getInstance().getLogger().logError("Error occured while refresh the connection: " + exception);
            }
        }
    }

    public void moveFigure(int n, int n2) {
        for (Object e : this.getChildren()) {
            if (!(e instanceof GraphicalEditPart)) continue;
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)e;
            Rectangle rectangle = graphicalEditPart.getFigure().getBounds();
            Rectangle rectangle2 = new Rectangle(new Point(rectangle.x + n, rectangle.y + n2), rectangle.getSize());
            this.setLayoutConstraint((EditPart)graphicalEditPart, graphicalEditPart.getFigure(), rectangle2);
        }
    }
}

