/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.part;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.epf.diagram.ad.part.UMLDiagramEditorUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class UMLCreationWizardPage
extends WizardNewFileCreationPage {
    private final String fileExtension;

    public UMLCreationWizardPage(String string, IStructuredSelection iStructuredSelection, String string2) {
        super(string, iStructuredSelection);
        this.fileExtension = string2;
    }

    protected String getExtension() {
        return this.fileExtension;
    }

    public URI getURI() {
        return URI.createPlatformResourceURI((String)this.getFilePath().toString(), (boolean)false);
    }

    protected IPath getFilePath() {
        String string;
        IPath iPath = this.getContainerFullPath();
        if (iPath == null) {
            iPath = new Path("");
        }
        if ((string = this.getFileName()) != null) {
            iPath = iPath.append(string);
        }
        return iPath;
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        this.setFileName(UMLDiagramEditorUtil.getUniqueFileName(this.getContainerFullPath(), this.getFileName(), this.getExtension()));
        this.setPageComplete(this.validatePage());
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        String string = this.getExtension();
        if (string != null && !this.getFilePath().toString().endsWith("." + string)) {
            this.setErrorMessage(NLS.bind((String)"File name should have ''{0}'' extension.", (Object)string));
            return false;
        }
        return true;
    }
}

