/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.analysis;

import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.eclipse.epf.common.utils.StrUtil;

public final class TextFilter
extends TokenFilter {
    private static Set stopWords = null;

    public TextFilter(TokenStream tokenStream) {
        super(tokenStream);
        if (stopWords == null) {
            this.loadStopWords();
        }
    }

    public final Token next() throws IOException {
        Token token = this.input.next();
        while (token != null) {
            String string = token.termText();
            if (!stopWords.contains(string)) {
                return token;
            }
            token = this.input.next();
        }
        return null;
    }

    private void loadStopWords() {
        String[] stringArray = null;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(String.valueOf(TextFilter.class.getPackage().getName()) + ".StopWords");
            String string = resourceBundle.getString("Search.stopWords");
            stringArray = StrUtil.split((String)string, (String)" ,");
        }
        catch (Exception exception) {
            stringArray = StopAnalyzer.ENGLISH_STOP_WORDS;
        }
        stopWords = StopFilter.makeStopSet((String[])stringArray);
    }
}

