/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.dataexchange.internal.importing;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.dataexchange.importing.PluginService;
import org.eclipse.epf.dataexchange.internal.importing.PluginServiceImpl;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.util.ModelStorage;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.UmaFactory;

public class LibraryServiceImpl
implements org.eclipse.epf.dataexchange.importing.LibraryService {
    public MethodPlugin createPlugin(String string, String string2) throws Exception {
        return this.createPlugin(string, string2, null);
    }

    public MethodPlugin createPlugin(String string, String string2, Map map) throws Exception {
        Map map2;
        MethodPlugin methodPlugin = UmaFactory.eINSTANCE.createMethodPlugin();
        methodPlugin.setName(string);
        methodPlugin.setGuid(string2);
        methodPlugin = ModelStorage.initialize((MethodPlugin)methodPlugin);
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        methodLibrary.getMethodPlugins().add(methodPlugin);
        if (map != null && (map2 = (Map)map.get("renameElementMap")) != null) {
            LibraryServiceImpl.ensureUniqueName((EObject)methodLibrary, (MethodElement)methodPlugin, map2);
        }
        MethodLibraryPersister.INSTANCE.save(methodLibrary.eResource());
        MethodLibraryPersister.INSTANCE.save(methodPlugin.eResource());
        methodLibrary.eResource().setModified(true);
        methodPlugin.eResource().setModified(true);
        return methodPlugin;
    }

    public MethodConfiguration createConfiguration(String string, String string2) {
        MethodConfiguration methodConfiguration = UmaFactory.eINSTANCE.createMethodConfiguration();
        methodConfiguration.setName(string);
        methodConfiguration.setGuid(string2);
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        boolean bl = methodLibrary.eDeliver();
        try {
            methodLibrary.eSetDeliver(false);
            methodLibrary.getPredefinedConfigurations().add(methodConfiguration);
        }
        finally {
            methodLibrary.eSetDeliver(bl);
        }
        return methodConfiguration;
    }

    public PluginService createPluginService(MethodPlugin methodPlugin) {
        return new PluginServiceImpl(methodPlugin);
    }

    private static void ensureUniqueName(EObject eObject, MethodElement methodElement, Map map) {
        Object[] objectArray;
        Object object;
        if (eObject == null) {
            return;
        }
        Class<?> clazz = methodElement.getClass();
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>();
        int n = 0;
        while (n < eObject.eContents().size()) {
            object = eObject.eContents().get(n);
            if (object.getClass() == clazz && object != methodElement) {
                objectArray = (Object[])object;
                hashMap.put(objectArray.getName(), objectArray);
            }
            ++n;
        }
        String string = methodElement.getName();
        object = string;
        while (hashMap.containsKey(object)) {
            object = String.valueOf(object) + "_renamed";
        }
        if (object != string) {
            methodElement.setName((String)object);
            objectArray = new Object[]{methodElement, string, hashMap.get(string), object};
            map.put(methodElement.getGuid(), objectArray);
        }
    }
}

