/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.ui.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.search.ui.SearchUIResources;
import org.eclipse.epf.search.ui.internal.MethodSearchResult;
import org.eclipse.epf.search.ui.internal.SearchResultUIFolder;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class SearchResultTreeContentProvider
implements ITreeContentProvider {
    private static final String PKG_NAME_CONTENT = "Content";
    private static final String PKG_NAME_CORE_CONTENT = "CoreContent";
    private static final String PKG_NAME_CATEGORIES = "Categories";
    private static final String PKG_NAME_DISCIPLINES = "Disciplines";
    private static final String PKG_NAME_DOMAINS = "Domains";
    private static final String PKG_NAME_WORK_PRODUCT_TYPES = "WP Types";
    private static final String PKG_NAME_ROLESETS = "RoleSets";
    private static final String PKG_NAME_TOOLS = "Tools";
    private static final String PKG_NAME_CUSTOM_CATEGORIES = "CustomCategories";
    private static final String PKG_NAME_CAPABILITY_PATTERNS = "CapabilityPatterns";
    private static final String PKG_NAME_DELIVERY_PROCESSES = "DeliveryProcesses";
    private static final String METHOD_CONTENT = SearchUIResources.searchResult_methodContent;
    private static final String CONTENT_PACKAGES = SearchUIResources.searchResult_contentPackages;
    private static final String STANDARD_CATEGORIES = SearchUIResources.searchResult_standardCategories;
    private static final String DISCIPLINES = SearchUIResources.searchResult_disciplines;
    private static final String DOMAINS = SearchUIResources.searchResult_domains;
    private static final String WORK_PRODUCT_TYPES = SearchUIResources.searchResult_workProductTypes;
    private static final String ROLESETS = SearchUIResources.searchResult_roleSets;
    private static final String TOOLS = SearchUIResources.searchResult_tools;
    private static final String CUSTOM_CATEGORIES = SearchUIResources.searchResult_customCategories;
    private static final String PROCESSES = SearchUIResources.searchResult_processes;
    private static final String CAPABILITY_PATTERNS = SearchUIResources.searchResult_capabilityPatterns;
    private static final String DELIVERY_PROCESSES = SearchUIResources.searchResult_deliveryProcesses;
    private static final Object[] EMPTY_LIST = new Object[0];
    private TreeViewer treeViewer;
    private MethodSearchResult searchResult;
    private Map<Object, Object> elementMap;

    public Object[] getElements(Object object) {
        if (object instanceof MethodSearchResult) {
            Object[] objectArray = ((MethodSearchResult)((Object)object)).getElements();
            if (objectArray.length == 0) {
                return EMPTY_LIST;
            }
            this.elementMap = new HashMap<Object, Object>();
            int n = 0;
            while (n < objectArray.length) {
                this.insert(objectArray[n], false);
                ++n;
            }
            this.insertUIFolders(object);
        }
        return this.getChildren(object);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (object2 != null && object2 instanceof MethodSearchResult) {
            this.treeViewer = (TreeViewer)viewer;
            this.searchResult = (MethodSearchResult)((Object)object2);
        }
    }

    public void elementsChanged(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (this.searchResult.getMatchCount(objectArray[n]) > 0) {
                if (this.treeViewer.testFindItem(objectArray[n]) != null) {
                    this.insert(objectArray[n], true);
                } else {
                    this.remove(objectArray[n], true);
                }
            } else {
                this.treeViewer.remove(objectArray[n]);
            }
            ++n;
        }
        this.treeViewer.refresh();
    }

    public Object[] getChildren(Object object) {
        if (this.elementMap == null) {
            return EMPTY_LIST;
        }
        Set set = (Set)this.elementMap.get(object);
        if (set == null) {
            return EMPTY_LIST;
        }
        return set.toArray();
    }

    public Object getParent(Object object) {
        ProcessPackage processPackage;
        if (object instanceof MethodPlugin) {
            return null;
        }
        if (object instanceof SearchResultUIFolder) {
            return ((SearchResultUIFolder)object).getParent();
        }
        if (object instanceof ProcessPackage) {
            ProcessPackage processPackage2 = (ProcessPackage)object;
            EObject eObject = processPackage2.eContainer();
            if (eObject instanceof ProcessComponent) {
                ProcessComponent processComponent = (ProcessComponent)eObject;
                return processComponent.getProcess();
            }
            return eObject;
        }
        if (object instanceof MethodPackage) {
            MethodPackage methodPackage = (MethodPackage)object;
            EObject eObject = methodPackage.eContainer();
            if (eObject instanceof MethodPlugin) {
                return eObject;
            }
            MethodPackage methodPackage2 = methodPackage.getParentPackage();
            return methodPackage2;
        }
        if (object instanceof Artifact) {
            Artifact artifact = (Artifact)object;
            Artifact artifact2 = artifact.getContainerArtifact();
            if (artifact2 != null) {
                return artifact2;
            }
            return UmaUtil.getContentPackage((EObject)artifact);
        }
        if (object instanceof Practice) {
            Practice practice = (Practice)object;
            return practice.getContainer();
        }
        if (object instanceof Discipline) {
            Discipline discipline = (Discipline)object;
            return discipline.getContainer();
        }
        if (object instanceof Domain) {
            Domain domain = (Domain)object;
            return domain.getContainer();
        }
        if (object instanceof ContentElement) {
            return UmaUtil.getContentPackage((EObject)((ContentElement)object));
        }
        if (object instanceof Process) {
            Process process = (Process)object;
            ProcessPackage processPackage3 = (ProcessPackage)process.eContainer();
            if (processPackage3 != null) {
                return processPackage3.eContainer();
            }
        } else if (object instanceof Activity) {
            ProcessPackage processPackage4;
            ProcessPackage processPackage5 = UmaUtil.getProcessPackage((EObject)((ProcessElement)object));
            if (processPackage5 != null && (processPackage4 = (ProcessPackage)processPackage5.getParentPackage()) != null) {
                if (processPackage4 instanceof ProcessComponent) {
                    ProcessComponent processComponent = (ProcessComponent)processPackage4;
                    return processComponent.getProcess();
                }
                List list = processPackage4.getProcessElements();
                for (ProcessElement processElement : list) {
                    if (!(processElement instanceof Activity) || !processElement.getName().equals(processPackage4.getName())) continue;
                    return processElement;
                }
            }
        } else if (object instanceof ProcessElement && (processPackage = UmaUtil.getProcessPackage((EObject)((ProcessElement)object))) != null) {
            if (processPackage instanceof ProcessComponent) {
                ProcessComponent processComponent = (ProcessComponent)processPackage;
                return processComponent.getProcess();
            }
            List list = processPackage.getProcessElements();
            for (ProcessElement processElement : list) {
                if (!(processElement instanceof Activity) || !processElement.getName().equals(processPackage.getName())) continue;
                return processElement;
            }
            return processPackage;
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public void clear() {
        this.treeViewer.refresh();
    }

    public void dispose() {
    }

    protected void insert(Object object, boolean bl) {
        Object object2 = this.getParent(object);
        while (object2 != null) {
            if (this.insertChild(object2, object)) {
                if (bl) {
                    this.treeViewer.add(object2, object);
                }
            } else {
                if (bl) {
                    this.treeViewer.refresh(object2);
                }
                return;
            }
            object = object2;
            object2 = this.getParent(object);
        }
        if (this.insertChild((Object)this.searchResult, object) && bl) {
            this.treeViewer.add((Object)this.searchResult, object);
        }
    }

    protected boolean insertChild(Object object, Object object2) {
        HashSet<Object> hashSet = (HashSet<Object>)this.elementMap.get(object);
        if (hashSet == null) {
            hashSet = new HashSet<Object>();
            this.elementMap.put(object, hashSet);
        }
        return hashSet.add(object2);
    }

    protected void replace(Object object, Object object2, Object object3) {
        this.insert(object3, false);
        this.elementMap.put(object3, (Set)this.elementMap.get(object2));
        this.elementMap.remove(object2);
        Set set = (Set)this.elementMap.get(object);
        set.remove(object2);
    }

    protected void remove(Object object, boolean bl) {
        if (this.hasChildren(object)) {
            if (bl) {
                this.treeViewer.refresh(object);
            }
        } else if (this.searchResult.getMatchCount(object) == 0) {
            this.elementMap.remove(object);
            Object object2 = this.getParent(object);
            if (object2 != null) {
                this.removeFromSiblings(object, object2);
                this.remove(object2, bl);
            } else {
                this.removeFromSiblings(object, (Object)this.searchResult);
                if (bl) {
                    this.treeViewer.refresh();
                }
            }
        } else if (bl) {
            this.treeViewer.refresh(object);
        }
    }

    protected void removeFromSiblings(Object object, Object object2) {
        Set set = (Set)this.elementMap.get(object2);
        if (set != null) {
            set.remove(object);
        }
    }

    protected void insertUIFolders(Object object) {
        Object[] objectArray = this.getChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            Object object2 = objectArray[n];
            if (object2 instanceof MethodPlugin) {
                SearchResultUIFolder searchResultUIFolder = new SearchResultUIFolder(METHOD_CONTENT, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Content"), object2);
                SearchResultUIFolder searchResultUIFolder2 = new SearchResultUIFolder(PROCESSES, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Processes"), object2);
                Object[] objectArray2 = this.getChildren(object2);
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    Object object3 = objectArray2[n2];
                    if (object3 instanceof ContentPackage && ((ContentPackage)object3).getName().equals(PKG_NAME_CONTENT)) {
                        Object[] objectArray3 = this.getChildren(object3);
                        int n3 = 0;
                        while (n3 < objectArray3.length) {
                            Object object4 = objectArray3[n3];
                            if (object4 instanceof ContentPackage) {
                                if (((ContentPackage)object4).getName().equals(PKG_NAME_CORE_CONTENT)) {
                                    this.replace(object2, object4, new SearchResultUIFolder(CONTENT_PACKAGES, LibraryEditPlugin.INSTANCE.getImage("full/obj16/MethodPackages"), searchResultUIFolder));
                                } else if (((ContentPackage)object4).getName().equals(PKG_NAME_CATEGORIES)) {
                                    SearchResultUIFolder searchResultUIFolder3 = new SearchResultUIFolder(STANDARD_CATEGORIES, LibraryEditPlugin.INSTANCE.getImage("full/obj16/StandardCategories"), searchResultUIFolder);
                                    SearchResultUIFolder searchResultUIFolder4 = new SearchResultUIFolder(CUSTOM_CATEGORIES, LibraryEditPlugin.INSTANCE.getImage("full/obj16/CustomCategories"), searchResultUIFolder);
                                    Object[] objectArray4 = this.getChildren(object4);
                                    int n4 = 0;
                                    while (n4 < objectArray4.length) {
                                        Object object5 = objectArray4[n4];
                                        if (object5 instanceof ContentPackage) {
                                            String string = ((ContentPackage)object5).getName();
                                            if (string.equals(PKG_NAME_CUSTOM_CATEGORIES)) {
                                                this.insert(searchResultUIFolder4, false);
                                                this.elementMap.put(searchResultUIFolder4, (Set)this.elementMap.get(object5));
                                            } else if (string.equals(PKG_NAME_DISCIPLINES)) {
                                                this.insert(searchResultUIFolder3, false);
                                                this.replace(object2, object5, new SearchResultUIFolder(DISCIPLINES, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Disciplines"), searchResultUIFolder3));
                                            } else if (string.equals(PKG_NAME_DOMAINS)) {
                                                this.insert(searchResultUIFolder3, false);
                                                this.replace(object2, object5, new SearchResultUIFolder(DOMAINS, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Domains"), searchResultUIFolder3));
                                            } else if (string.equals(PKG_NAME_WORK_PRODUCT_TYPES)) {
                                                this.insert(searchResultUIFolder3, false);
                                                this.replace(object2, object5, new SearchResultUIFolder(WORK_PRODUCT_TYPES, LibraryEditPlugin.INSTANCE.getImage("full/obj16/WorkProductTypes"), searchResultUIFolder3));
                                            } else if (string.equals(PKG_NAME_ROLESETS)) {
                                                this.insert(searchResultUIFolder3, false);
                                                this.replace(object2, object5, new SearchResultUIFolder(ROLESETS, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Roles"), searchResultUIFolder3));
                                            } else if (string.equals(PKG_NAME_TOOLS)) {
                                                this.insert(searchResultUIFolder3, false);
                                                this.replace(object2, object5, new SearchResultUIFolder(TOOLS, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Tools"), searchResultUIFolder3));
                                            }
                                        }
                                        ++n4;
                                    }
                                    this.elementMap.remove(object4);
                                }
                            } else if (object4 instanceof ProcessPackage && ((ProcessPackage)object4).getName().equals(PKG_NAME_CAPABILITY_PATTERNS)) {
                                this.replace(object2, object4, new SearchResultUIFolder(CAPABILITY_PATTERNS, LibraryEditPlugin.INSTANCE.getImage("full/obj16/CapabilityPatterns"), searchResultUIFolder2));
                            }
                            ++n3;
                        }
                        Set set = (Set)this.elementMap.get(object2);
                        set.remove(object3);
                    } else if (object3 instanceof ProcessPackage && ((ProcessPackage)object3).getName().equals(PKG_NAME_DELIVERY_PROCESSES)) {
                        this.replace(object2, object3, new SearchResultUIFolder(DELIVERY_PROCESSES, LibraryEditPlugin.INSTANCE.getImage("full/obj16/DeliveryProcesses"), searchResultUIFolder2));
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }
}

