/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.ClasspathModifierQueries;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class AddFolderToBuildpathAction
extends BuildpathModifierAction {
    private final IRunnableContext fContext;

    public AddFolderToBuildpathAction(IWorkbenchSite site) {
        this(site, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public AddFolderToBuildpathAction(IRunnableContext context, ISetSelectionTarget selectionTarget) {
        this(null, selectionTarget, context);
    }

    private AddFolderToBuildpathAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget, IRunnableContext context) {
        super(site, selectionTarget, 0);
        this.fContext = context;
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelSFToCP_label);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_ADD_AS_SOURCE_FOLDER);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelSFToCP_tooltip);
    }

    public String getDetailedDescription() {
        if (!this.isEnabled()) {
            return null;
        }
        if (this.getSelectedElements().size() != 1) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_toBuildpath;
        }
        Object obj = this.getSelectedElements().get(0);
        if (obj instanceof IJavaProject) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ProjectToBuildpath, ((IJavaProject)obj).getElementName());
        }
        if (obj instanceof IPackageFragment) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_PackageToBuildpath, ((IPackageFragment)obj).getElementName());
        }
        if (obj instanceof IResource) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_FolderToBuildpath, ((IResource)obj).getName());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            boolean removeOldClassFiles;
            boolean removeProjectFromClasspath;
            IPath newDefaultOutputLocation;
            IJavaProject project;
            Object object = this.getSelectedElements().get(0);
            if (object instanceof IJavaProject) {
                project = (IJavaProject)object;
            } else if (object instanceof IPackageFragment) {
                project = ((IPackageFragment)object).getJavaProject();
            } else {
                IFolder folder = (IFolder)object;
                project = JavaCore.create((IProject)folder.getProject());
                if (project == null) {
                    return;
                }
            }
            Shell shell = this.getShell();
            IPath outputLocation = project.getOutputLocation();
            IPath defaultOutputLocation = outputLocation.makeRelative();
            IPath projPath = project.getProject().getFullPath();
            if (!(this.getSelectedElements().size() == 1 && this.getSelectedElements().get(0) instanceof IJavaProject || !outputLocation.equals((Object)projPath) && defaultOutputLocation.segmentCount() != 1)) {
                ClasspathModifierQueries.OutputFolderQuery outputFolderQuery = ClasspathModifierQueries.getDefaultFolderQuery(shell, defaultOutputLocation);
                if (!outputFolderQuery.doQuery(true, ClasspathModifier.getValidator(this.getSelectedElements(), project), project)) return;
                newDefaultOutputLocation = outputFolderQuery.getOutputLocation();
                removeProjectFromClasspath = outputFolderQuery.removeProjectFromClasspath();
                if (BuildPathsBlock.hasClassfiles((IResource)project.getProject()) && outputLocation.equals((Object)projPath)) {
                    String title = NewWizardMessages.BuildPathsBlock_RemoveBinariesDialog_title;
                    String message = Messages.format(NewWizardMessages.BuildPathsBlock_RemoveBinariesDialog_description, projPath.toString());
                    MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    int answer = dialog.open();
                    if (answer == 0) {
                        removeOldClassFiles = true;
                    } else {
                        if (answer != 1) return;
                        removeOldClassFiles = false;
                    }
                } else {
                    removeOldClassFiles = false;
                }
            } else {
                removeProjectFromClasspath = false;
                removeOldClassFiles = false;
                newDefaultOutputLocation = defaultOutputLocation;
            }
            try {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            List result = AddFolderToBuildpathAction.this.addToClasspath(AddFolderToBuildpathAction.this.getSelectedElements(), project, newDefaultOutputLocation.makeAbsolute(), removeProjectFromClasspath, removeOldClassFiles, monitor);
                            AddFolderToBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                this.fContext.run(false, false, runnable);
                return;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof CoreException) {
                    this.showExceptionDialog((CoreException)e.getCause(), NewWizardMessages.AddSourceFolderToBuildpathAction_ErrorTitle);
                    return;
                }
                JavaPlugin.log(e);
                return;
            }
            catch (InterruptedException interruptedException) {}
            return;
        }
        catch (CoreException e) {
            this.showExceptionDialog(e, NewWizardMessages.AddSourceFolderToBuildpathAction_ErrorTitle);
        }
    }

    private List addToClasspath(List elements, IJavaProject project, IPath outputLocation, boolean removeProjectFromClasspath, boolean removeOldClassFiles, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (!project.getProject().hasNature("org.eclipse.jdt.core.javanature")) {
            StatusInfo rootStatus = new StatusInfo();
            rootStatus.setError(NewWizardMessages.ClasspathModifier_Error_NoNatures);
            throw new CoreException((IStatus)rootStatus);
        }
        try {
            IResource res;
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, elements.size() + 4);
            IWorkspaceRoot workspaceRoot = JavaPlugin.getWorkspace().getRoot();
            if (removeOldClassFiles && (res = workspaceRoot.findMember(project.getOutputLocation())) instanceof IContainer && BuildPathsBlock.hasClassfiles(res)) {
                BuildPathsBlock.removeOldClassfiles(res);
            }
            BuildpathDelta delta = new BuildpathDelta(this.getToolTipText());
            if (!project.getOutputLocation().equals((Object)outputLocation)) {
                project.setOutputLocation(outputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                delta.setDefaultOutputLocation(outputLocation);
            } else {
                monitor.worked(1);
            }
            List existingEntries = ClasspathModifier.getExistingEntries(project);
            if (removeProjectFromClasspath) {
                ClasspathModifier.removeFromClasspath(project, existingEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
            ArrayList<CPListElement> newEntries = new ArrayList<CPListElement>();
            int i = 0;
            while (i < elements.size()) {
                Object element = elements.get(i);
                CPListElement entry = element instanceof IResource ? ClasspathModifier.addToClasspath((IResource)element, existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1)) : ClasspathModifier.addToClasspath((IJavaElement)element, existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                newEntries.add(entry);
                ++i;
            }
            HashSet modifiedSourceEntries = new HashSet();
            BuildPathBasePage.fixNestingConflicts(newEntries.toArray(new CPListElement[newEntries.size()]), existingEntries.toArray(new CPListElement[existingEntries.size()]), modifiedSourceEntries);
            ClasspathModifier.setNewEntry(existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ClasspathModifier.commitClassPath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            delta.setNewEntries(existingEntries.toArray(new CPListElement[existingEntries.size()]));
            this.informListeners(delta);
            ArrayList<IJavaProject> result = new ArrayList<IJavaProject>();
            int i2 = 0;
            while (i2 < newEntries.size()) {
                IClasspathEntry entry = ((CPListElement)newEntries.get(i2)).getClasspathEntry();
                Object root = entry.getPath().equals((Object)project.getPath()) ? project : project.findPackageFragmentRoot(entry.getPath());
                if (root != null) {
                    result.add((IJavaProject)root);
                }
                ++i2;
            }
            ArrayList<IJavaProject> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean canHandle(IStructuredSelection elements) {
        if (elements.size() == 0) {
            return false;
        }
        try {
            Iterator iter = elements.iterator();
            while (true) {
                if (!iter.hasNext()) {
                    return true;
                }
                Object element = iter.next();
                if (element instanceof IJavaProject) {
                    if (!ClasspathModifier.isSourceFolder((IJavaProject)element)) continue;
                    return false;
                }
                if (element instanceof IPackageFragment) {
                    IPackageFragment fragment = (IPackageFragment)element;
                    if (ClasspathModifier.isDefaultFragment(fragment)) {
                        return false;
                    }
                    if (!((IPackageFragmentRoot)fragment.getAncestor(3)).isArchive()) continue;
                    return false;
                }
                if (!(element instanceof IFolder)) {
                    return false;
                }
                IProject project = ((IFolder)element).getProject();
                IJavaProject javaProject = JavaCore.create((IProject)project);
                if (javaProject == null || !javaProject.exists()) break;
            }
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

