/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.library.CreateLibraryManagerException;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.internal.LibraryManagerElement;
import org.eclipse.epf.services.Services;
import org.osgi.framework.Bundle;

public class LibraryManagerFactory {
    public static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.epf.library";
    public static final String EXTENSION_POINT_NAME = "libraryManagers";
    public static final String CLASS_ATTRIB_NAME = "class";
    public static final String TYPE_ATTRIB_NAME = "type";
    public static final String TYPE_NAME_ATTRIB_NAME = "typeName";
    private static final String VERSION_ATTRIB_NAME = "version";
    private static LibraryManagerFactory instance = null;
    private Map<String, LibraryManagerElement> libraryManagerElements = new HashMap<String, LibraryManagerElement>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LibraryManagerFactory getInstance() {
        if (instance != null) return instance;
        Class<LibraryManagerFactory> clazz = LibraryManagerFactory.class;
        synchronized (LibraryManagerFactory.class) {
            if (instance != null) return instance;
            instance = new LibraryManagerFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LibraryManagerFactory() {
        this.init();
    }

    protected void init() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                IExtension iExtension = iExtensionArray[n];
                String string = iExtension.getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)string);
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                    try {
                        String string2 = iConfigurationElement.getAttribute(CLASS_ATTRIB_NAME);
                        String string3 = iConfigurationElement.getAttribute(TYPE_ATTRIB_NAME);
                        String string4 = iConfigurationElement.getAttribute(TYPE_NAME_ATTRIB_NAME);
                        if (string2 != null && string2.trim().length() > 0 && string3 != null && string3.trim().length() > 0 && string4 != null && string4.trim().length() > 0) {
                            int n3 = Services.parseVersion((String)iConfigurationElement.getAttribute(VERSION_ATTRIB_NAME));
                            LibraryManagerElement libraryManagerElement = this.libraryManagerElements.get(string3);
                            if (libraryManagerElement == null || libraryManagerElement.getVersion() < n3) {
                                libraryManagerElement = new LibraryManagerElement(bundle, string2, string3, string4, n3);
                                this.libraryManagerElements.put(string3, libraryManagerElement);
                            }
                        }
                    }
                    catch (Exception exception) {
                        LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    public ILibraryManager createLibraryManager(String string) throws CreateLibraryManagerException {
        LibraryManagerElement libraryManagerElement = this.libraryManagerElements.get(string);
        if (libraryManagerElement == null) {
            throw new CreateLibraryManagerException();
        }
        try {
            Class clazz = libraryManagerElement.getBundle().loadClass(libraryManagerElement.getClassName());
            return (ILibraryManager)clazz.newInstance();
        }
        catch (Exception exception) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
            throw new CreateLibraryManagerException(exception);
        }
    }

    public Map getLibraryTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : this.libraryManagerElements.keySet()) {
            String string2 = this.libraryManagerElements.get(string).getTypeName();
            hashMap.put(string, string2);
        }
        return hashMap;
    }
}

