/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.diagram;

import java.awt.Rectangle;
import java.util.Iterator;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.layout.diagram.HTMLArea;
import org.eclipse.epf.library.layout.diagram.HTMLMap;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.uma.MethodElement;

public class MethodElementDiagram {
    private MethodElement element;
    private String imageFileName;
    private HTMLMap htmlMap;

    public MethodElementDiagram(MethodElement methodElement) {
        this.element = methodElement;
    }

    public MethodElement getMethodElement() {
        return this.element;
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public void setImageFileName(String string) {
        this.imageFileName = string;
    }

    public HTMLMap getHTMLMap() {
        return this.htmlMap;
    }

    public void setHTMLMap(HTMLMap hTMLMap) {
        this.htmlMap = hTMLMap;
    }

    public String getHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<p>");
        if (this.imageFileName != null && this.htmlMap != null) {
            String string = this.htmlMap.getName();
            stringBuffer.append("<map name=\"").append(this.htmlMap.getName()).append("\">");
            Iterator iterator = this.htmlMap.getAreas();
            while (iterator.hasNext()) {
                HTMLArea hTMLArea = (HTMLArea)iterator.next();
                Rectangle rectangle = hTMLArea.getCoordinates();
                stringBuffer.append("<area href=\"").append(hTMLArea.getHref()).append("\"").append(" shape=\"").append(hTMLArea.getShape()).append("\"").append(" coords=\"").append((int)rectangle.getX()).append(", ").append((int)rectangle.getY()).append(", ").append((int)(rectangle.getX() + rectangle.getWidth())).append(", ").append((int)(rectangle.getY() + rectangle.getHeight())).append("\"").append(" alt=\"").append(hTMLArea.getAltTag()).append("\"").append(" title=\"").append(hTMLArea.getAltTag()).append("\"").append("/>");
            }
            stringBuffer.append("</map>");
            stringBuffer.append("<img border=\"0\" src=\"").append(this.imageFileName).append("\"").append(" alt=\"").append(string).append("\"").append(" title=\"").append(string).append("\"").append(" usemap=\"#").append(string).append("\"/>");
        }
        stringBuffer.append("</p>");
        return stringBuffer.toString();
    }

    public XmlElement getXmlElement() {
        XmlElement xmlElement = null;
        if (this.imageFileName != null && this.htmlMap != null) {
            String string = this.htmlMap.getName();
            String string2 = StrUtil.toEscapedUnicode((String)string, (boolean)true).replace("\\u", "");
            xmlElement = new XmlElement("map").setAttribute("name", string2).setAttribute("src", this.imageFileName).setAttribute("alt", string);
            Iterator iterator = this.htmlMap.getAreas();
            while (iterator.hasNext()) {
                HTMLArea hTMLArea = (HTMLArea)iterator.next();
                Rectangle rectangle = hTMLArea.getCoordinates();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append((int)rectangle.getX()).append(", ").append((int)rectangle.getY()).append(", ").append((int)(rectangle.getX() + rectangle.getWidth())).append(", ").append((int)(rectangle.getY() + rectangle.getHeight()));
                xmlElement.newChild("area").setAttribute("guid", hTMLArea.getGuid() == null ? "" : hTMLArea.getGuid()).setAttribute("href", StrUtil.escape((String)hTMLArea.getHref())).setAttribute("shape", hTMLArea.getShape()).setAttribute("coords", stringBuffer.toString()).setAttribute("alt", hTMLArea.getAltTag());
            }
        }
        return xmlElement;
    }
}

