/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.add.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.epf.diagram.add.edit.parts.ActivityDetailDiagramEditPart;
import org.eclipse.epf.diagram.add.edit.parts.RoleNodeEditPart;
import org.eclipse.epf.diagram.add.edit.parts.RoleTaskCompositeEditPart;
import org.eclipse.epf.diagram.add.edit.parts.TaskNodeEditPart;
import org.eclipse.epf.diagram.add.edit.parts.WorkProductCompositeEditPart;
import org.eclipse.epf.diagram.core.commands.ChangeBoundsCommand;
import org.eclipse.epf.diagram.core.util.DiagramConstants;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Font;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramResetService {
    private DefaultEditDomain editDomain;
    private GraphicalViewer graphicalViewer;
    private ActionRegistry actionRegistry;
    private InternalTransactionalEditingDomain transactionDomain;
    int delta = 0;
    private static final int IMG_HEIGHT = 32;
    protected static final int HORIZ_PIX_PADDING = 30;
    protected static final int VERT_PIX_PADDING = 20;

    public DiagramResetService(InternalTransactionalEditingDomain internalTransactionalEditingDomain, GraphicalViewer graphicalViewer, DefaultEditDomain defaultEditDomain, ActionRegistry actionRegistry) {
        this.transactionDomain = internalTransactionalEditingDomain;
        this.graphicalViewer = graphicalViewer;
        this.editDomain = defaultEditDomain;
        this.actionRegistry = actionRegistry;
    }

    private GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    protected DefaultEditDomain getEditDomain() {
        return this.editDomain;
    }

    protected ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public void cleanUpDiagram() {
        ActivityDetailDiagramEditPart activityDetailDiagramEditPart;
        List<EditPart> list;
        if (this.getGraphicalViewer().getContents() instanceof ActivityDetailDiagramEditPart && !(list = (activityDetailDiagramEditPart = (ActivityDetailDiagramEditPart)this.getGraphicalViewer().getContents()).getRecentlyAddedParts()).isEmpty()) {
            AbstractGraphicalEditPart abstractGraphicalEditPart;
            Comparator<Object> comparator = new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    int n = 0;
                    if (object instanceof RoleTaskCompositeEditPart) {
                        if (!(object2 instanceof RoleTaskCompositeEditPart)) {
                            n = -1;
                        }
                    } else if (object2 instanceof RoleTaskCompositeEditPart) {
                        n = 1;
                    }
                    return n;
                }
            };
            Object[] objectArray = list.toArray();
            Arrays.sort(objectArray, comparator);
            int n = 0;
            while (n < objectArray.length) {
                abstractGraphicalEditPart = (AbstractGraphicalEditPart)objectArray[n];
                this.adjustSize(abstractGraphicalEditPart);
                ++n;
            }
            activityDetailDiagramEditPart.getViewport().validate();
            n = 0;
            while (n < objectArray.length) {
                abstractGraphicalEditPart = (AbstractGraphicalEditPart)objectArray[n];
                this.cleanUp(abstractGraphicalEditPart);
                ++n;
            }
            n = 0;
            while (n < objectArray.length) {
                abstractGraphicalEditPart = (AbstractGraphicalEditPart)objectArray[n];
                this.reduceLinkLength(abstractGraphicalEditPart);
                ++n;
            }
            this.packDiagram();
            activityDetailDiagramEditPart.refresh();
            activityDetailDiagramEditPart.clearRecentlyAddedParts();
            this.getGraphicalViewer().setSelection((ISelection)new StructuredSelection());
        }
    }

    private void cleanUp(AbstractGraphicalEditPart abstractGraphicalEditPart) {
        if (!(abstractGraphicalEditPart instanceof WorkProductCompositeEditPart)) {
            List list;
            int n;
            AbstractGraphicalEditPart abstractGraphicalEditPart2;
            Object object;
            List list2 = abstractGraphicalEditPart.getSourceConnections();
            if (list2.size() > 0) {
                int n2 = 0;
                while (n2 < list2.size()) {
                    ChangeBoundsCommand changeBoundsCommand;
                    object = (ConnectionNodeEditPart)list2.get(n2);
                    abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)object.getTarget();
                    int n3 = abstractGraphicalEditPart2.getFigure().getBounds().width;
                    n = abstractGraphicalEditPart.getFigure().getPreferredSize().width;
                    if (n3 < n) {
                        changeBoundsCommand = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)abstractGraphicalEditPart.getModel()), abstractGraphicalEditPart2.getFigure().getBounds().getLocation(), n3, abstractGraphicalEditPart2.getFigure().getPreferredSize().height);
                        this.getCommandStack().execute((Command)changeBoundsCommand);
                        int n4 = abstractGraphicalEditPart2.getFigure().getPreferredSize().height;
                        abstractGraphicalEditPart2.getFigure().setPreferredSize(new Dimension(n3, n4));
                        abstractGraphicalEditPart2.getFigure().setSize(new Dimension(n3, n4));
                    }
                    changeBoundsCommand = new ArrayList();
                    changeBoundsCommand.add(abstractGraphicalEditPart);
                    changeBoundsCommand.add(abstractGraphicalEditPart2);
                    this.verticalAlignToFirstSelected((List)changeBoundsCommand);
                    ++n2;
                }
            }
            if ((list = abstractGraphicalEditPart.getTargetConnections()).size() > 0) {
                int n5 = 0;
                while (n5 < list.size()) {
                    abstractGraphicalEditPart2 = (ConnectionNodeEditPart)list.get(n5);
                    AbstractGraphicalEditPart abstractGraphicalEditPart3 = (AbstractGraphicalEditPart)abstractGraphicalEditPart2.getSource();
                    n = abstractGraphicalEditPart3.getFigure().getBounds().width;
                    int n6 = abstractGraphicalEditPart.getFigure().getPreferredSize().width;
                    if (n < n6) {
                        ChangeBoundsCommand changeBoundsCommand = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)abstractGraphicalEditPart.getModel()), abstractGraphicalEditPart3.getFigure().getBounds().getLocation(), n, -1);
                        this.getCommandStack().execute((Command)changeBoundsCommand);
                        int n7 = abstractGraphicalEditPart3.getFigure().getPreferredSize().height;
                        abstractGraphicalEditPart3.getFigure().setPreferredSize(new Dimension(n, n7));
                        abstractGraphicalEditPart3.getFigure().setSize(new Dimension(n, n7));
                    }
                    ArrayList<AbstractGraphicalEditPart> arrayList = new ArrayList<AbstractGraphicalEditPart>();
                    arrayList.add(abstractGraphicalEditPart);
                    arrayList.add(abstractGraphicalEditPart3);
                    this.verticalAlignToFirstSelected(arrayList);
                    ++n5;
                }
            }
            if (abstractGraphicalEditPart instanceof WorkProductCompositeEditPart || abstractGraphicalEditPart instanceof RoleTaskCompositeEditPart) {
                object = abstractGraphicalEditPart.getChildren();
                int n8 = 0;
                while (n8 < object.size()) {
                    AbstractGraphicalEditPart abstractGraphicalEditPart4 = (AbstractGraphicalEditPart)object.get(n8);
                    this.cleanUp(abstractGraphicalEditPart4);
                    ++n8;
                }
            }
        }
    }

    private boolean reduceLinkLength(AbstractGraphicalEditPart abstractGraphicalEditPart) {
        boolean bl = false;
        if (abstractGraphicalEditPart instanceof WorkProductCompositeEditPart) {
            AbstractGraphicalEditPart abstractGraphicalEditPart2 = null;
            int n = 2;
            if (abstractGraphicalEditPart.getTargetConnections().size() > 0) {
                abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)((ConnectionNodeEditPart)abstractGraphicalEditPart.getTargetConnections().get(0)).getSource();
                n = 1;
            } else if (abstractGraphicalEditPart.getSourceConnections().size() > 0) {
                abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)((ConnectionNodeEditPart)abstractGraphicalEditPart.getSourceConnections().get(0)).getTarget();
                n = 4;
            }
            if (abstractGraphicalEditPart2 != null) {
                if (!(abstractGraphicalEditPart2.getParent() instanceof DiagramEditPart)) {
                    abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)abstractGraphicalEditPart2.getParent();
                }
                Rectangle rectangle = abstractGraphicalEditPart.getFigure().getBounds();
                Rectangle rectangle2 = abstractGraphicalEditPart2.getFigure().getBounds();
                int n2 = -1;
                if ((n & 1) == 1 || (n & 2) == 2) {
                    n2 = 1;
                }
                Rectangle rectangle3 = rectangle.getCopy();
                rectangle3.y = n2 == 1 ? rectangle2.y + rectangle2.height + 20 : rectangle2.y - 20 - rectangle.height;
                Point point = new Point(rectangle3.x, rectangle3.y);
                abstractGraphicalEditPart.getFigure().setLocation(point);
                ChangeBoundsCommand changeBoundsCommand = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)abstractGraphicalEditPart.getModel()), point, rectangle.width, -1);
                this.getCommandStack().execute((Command)changeBoundsCommand);
            }
        }
        return bl;
    }

    private void adjustSize(AbstractGraphicalEditPart abstractGraphicalEditPart) {
        if (abstractGraphicalEditPart instanceof WorkProductCompositeEditPart) {
            this.adjustSize((WorkProductCompositeEditPart)abstractGraphicalEditPart, 1);
        } else if (abstractGraphicalEditPart instanceof RoleTaskCompositeEditPart) {
            this.adjustSize((RoleTaskCompositeEditPart)abstractGraphicalEditPart, 50);
        }
    }

    private void adjustSize(ShapeNodeEditPart shapeNodeEditPart, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        this.delta = 0;
        List list = shapeNodeEditPart.getChildren();
        IFigure iFigure = shapeNodeEditPart.getFigure();
        try {
            InternalTransaction internalTransaction = this.transactionDomain.startTransaction(false, Collections.EMPTY_MAP);
            int n8 = 0;
            while (n8 < list.size()) {
                if (n7 == 0) {
                    ++n4;
                }
                if (n7 < n) {
                    AbstractGraphicalEditPart abstractGraphicalEditPart = (AbstractGraphicalEditPart)list.get(n8);
                    if (abstractGraphicalEditPart instanceof RoleNodeEditPart || abstractGraphicalEditPart instanceof TaskNodeEditPart) {
                        this.resetSize((ShapeNodeEditPart)abstractGraphicalEditPart, iFigure);
                    }
                    Dimension dimension = abstractGraphicalEditPart.getFigure().getPreferredSize();
                    n5 += dimension.width;
                    if (dimension.height > n3) {
                        n3 = dimension.height;
                    }
                    ++n8;
                    ++n7;
                    continue;
                }
                if (n5 > n2) {
                    n2 = n5;
                }
                n6 += n3;
                n3 = 0;
                n5 = 0;
                n7 = 0;
            }
            internalTransaction.commit();
        }
        catch (Exception exception) {}
        if (n5 > n2) {
            n2 = n5;
        }
        int n9 = (n6 += n3) + 20 * n4;
        ChangeBoundsCommand changeBoundsCommand = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)shapeNodeEditPart.getModel()), shapeNodeEditPart.getFigure().getBounds().getLocation(), n2 += 30 * Math.min(n, list.size()), n9);
        this.getCommandStack().execute((Command)changeBoundsCommand);
        shapeNodeEditPart.getFigure().setPreferredSize(new Dimension(n2, n9));
        shapeNodeEditPart.getFigure().setSize(new Dimension(n2, n9));
        shapeNodeEditPart.getFigure().getLayoutManager().layout(shapeNodeEditPart.getFigure());
        if (shapeNodeEditPart instanceof WorkProductCompositeEditPart && list.size() > 0) {
            Node node;
            GraphicalEditPart graphicalEditPart;
            int n10 = 0;
            int n11 = 0;
            while (n11 < list.size()) {
                graphicalEditPart = (GraphicalEditPart)list.get(n11);
                node = (Node)graphicalEditPart.getModel();
                node.getElement();
                n10 += graphicalEditPart.getFigure().getPreferredSize().height;
                ++n11;
            }
            n11 = n10 + 20 + 5 * (list.size() - 1);
            graphicalEditPart = (GraphicalEditPart)list.get(list.size() - 1);
            node = graphicalEditPart.getFigure().getBounds().getBottom();
            Point point = shapeNodeEditPart.getFigure().getBounds().getBottom();
            int cfr_ignored_0 = point.y;
            int cfr_ignored_1 = node.y;
            shapeNodeEditPart.getFigure().setPreferredSize(new Dimension(n2, n11));
            changeBoundsCommand = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)shapeNodeEditPart.getModel()), shapeNodeEditPart.getFigure().getBounds().getLocation(), -1, n11);
            this.getCommandStack().execute((Command)changeBoundsCommand);
            shapeNodeEditPart.getFigure().setSize(new Dimension(n2, n11));
        }
    }

    private void resetSize(ShapeNodeEditPart shapeNodeEditPart, IFigure iFigure) {
        IFigure iFigure2;
        Node node = (Node)shapeNodeEditPart.getModel();
        IGraphicalEditPart iGraphicalEditPart = (IGraphicalEditPart)shapeNodeEditPart.getChildren().get(0);
        NodeFigure nodeFigure = (NodeFigure)shapeNodeEditPart.getFigure();
        List list = nodeFigure.getChildren();
        IFigure iFigure3 = (IFigure)list.get(0);
        if (iFigure3 instanceof RectangleFigure && (iFigure2 = (IFigure)((RectangleFigure)iFigure3).getChildren().get(0)) instanceof WrapLabel) {
            Dimension dimension = iFigure2.getSize();
            Dimension dimension2 = iFigure2.getPreferredSize();
            Point point = nodeFigure.getLocation().getCopy();
            point.x += this.delta;
            nodeFigure.setLocation(point);
            if (dimension2.width > nodeFigure.getSize().width) {
                this.delta += dimension2.width - nodeFigure.getSize().width;
            }
            if (dimension2.width > dimension.width) {
                int n = dimension2.width;
                View view = (View)iGraphicalEditPart.getModel();
                ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width(), (Object)new Integer(n));
                ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width(), (Object)new Integer(n));
                nodeFigure.setPreferredSize(new Dimension(n, nodeFigure.getPreferredSize().height));
                iFigure3.setPreferredSize(new Dimension(n, iFigure3.getPreferredSize().height));
                iFigure2.setPreferredSize(new Dimension(n, iFigure2.getPreferredSize().height));
                nodeFigure.setSize(new Dimension(n, nodeFigure.getPreferredSize().height));
                iFigure3.setSize(new Dimension(n, iFigure3.getPreferredSize().height));
                iFigure2.setSize(new Dimension(n, iFigure2.getPreferredSize().height));
            }
        }
    }

    protected void enumerateConnectedParts(AbstractGraphicalEditPart abstractGraphicalEditPart, List<EditPart> list) {
        if (!list.contains(abstractGraphicalEditPart)) {
            if (!(abstractGraphicalEditPart.getParent() instanceof DiagramEditPart)) {
                if (!list.contains(abstractGraphicalEditPart.getParent())) {
                    list.add(abstractGraphicalEditPart.getParent());
                }
            } else {
                list.add((EditPart)abstractGraphicalEditPart);
            }
            AbstractGraphicalEditPart abstractGraphicalEditPart2 = null;
            List list2 = abstractGraphicalEditPart.getChildren();
            int n = 0;
            while (n < list2.size()) {
                AbstractGraphicalEditPart abstractGraphicalEditPart3 = (AbstractGraphicalEditPart)list2.get(n);
                this.enumerateConnectedParts(abstractGraphicalEditPart3, list);
                ++n;
            }
            n = 0;
            while (n < abstractGraphicalEditPart.getTargetConnections().size()) {
                abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)((ConnectionNodeEditPart)abstractGraphicalEditPart.getTargetConnections().get(n)).getSource();
                this.enumerateConnectedParts(abstractGraphicalEditPart2, list);
                ++n;
            }
            n = 0;
            while (n < abstractGraphicalEditPart.getSourceConnections().size()) {
                abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)((ConnectionNodeEditPart)abstractGraphicalEditPart.getSourceConnections().get(n)).getTarget();
                this.enumerateConnectedParts(abstractGraphicalEditPart2, list);
                ++n;
            }
        }
    }

    private void packDiagram() {
        List list;
        int n;
        ActivityDetailDiagramEditPart activityDetailDiagramEditPart = (ActivityDetailDiagramEditPart)this.getGraphicalViewer().getContents();
        int n2 = 0;
        ArrayList<AbstractGraphicalEditPart> arrayList = new ArrayList<AbstractGraphicalEditPart>();
        ArrayList<ArrayList<EditPart>> arrayList2 = new ArrayList<ArrayList<EditPart>>();
        List<EditPart> list2 = activityDetailDiagramEditPart.getRecentlyAddedParts();
        int n3 = 0;
        while (n3 < list2.size()) {
            AbstractGraphicalEditPart abstractGraphicalEditPart = (AbstractGraphicalEditPart)list2.get(n3);
            n = 0;
            int n4 = 0;
            while (n4 < arrayList2.size() && n == 0) {
                list = (List)arrayList2.get(n4);
                if (list.contains(abstractGraphicalEditPart)) {
                    n = 1;
                    break;
                }
                ++n4;
            }
            if (n == 0) {
                ArrayList<EditPart> arrayList3 = new ArrayList<EditPart>();
                this.enumerateConnectedParts(abstractGraphicalEditPart, arrayList3);
                if (arrayList3.size() == 1) {
                    arrayList.add(abstractGraphicalEditPart);
                } else {
                    arrayList2.add(arrayList3);
                }
            }
            ++n3;
        }
        while (arrayList2.size() > 0) {
            List list3 = (List)arrayList2.get(0);
            int n5 = this.getVerticalMinPart((List)list3).getFigure().getBounds().y;
            n = 0;
            while (n < arrayList2.size()) {
                List list4 = (List)arrayList2.get(n);
                int n6 = this.getVerticalMinPart((List)list4).getFigure().getBounds().y;
                if (n6 < n5) {
                    list3 = list4;
                    n5 = n6;
                }
                ++n;
            }
            n = n2 + 1;
            int n7 = n - n5;
            int n8 = this.getHorizontalMinPart((List)list3).getFigure().getBounds().x;
            int n9 = 30 - n8;
            int n10 = 0;
            while (n10 < list3.size()) {
                AbstractGraphicalEditPart abstractGraphicalEditPart = (AbstractGraphicalEditPart)list3.get(n10);
                Rectangle rectangle = abstractGraphicalEditPart.getFigure().getBounds();
                ChangeBoundsCommand changeBoundsCommand = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)abstractGraphicalEditPart.getModel()), new Point(rectangle.x + n9, rectangle.y + n7), rectangle.width, -1);
                this.getCommandStack().execute((Command)changeBoundsCommand);
                abstractGraphicalEditPart.getFigure().setLocation(new Point(rectangle.x + n9, rectangle.y + n7));
                abstractGraphicalEditPart.refresh();
                ++n10;
            }
            n10 = this.getVerticalMaxPart(list3).getFigure().getBounds().bottom();
            n2 = n10 + 40;
            arrayList2.remove(list3);
        }
        int n11 = 30;
        int n12 = 0;
        while (n12 < arrayList.size()) {
            n = n2 + 1;
            AbstractGraphicalEditPart abstractGraphicalEditPart = (AbstractGraphicalEditPart)arrayList.get(n12);
            list = abstractGraphicalEditPart.getFigure().getBounds();
            ChangeBoundsCommand changeBoundsCommand = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)abstractGraphicalEditPart.getModel()), new Point(n11, n), ((Rectangle)list).width, -1);
            this.getCommandStack().execute((Command)changeBoundsCommand);
            abstractGraphicalEditPart.getFigure().setLocation(new Point(n11, n));
            abstractGraphicalEditPart.refresh();
            n11 += ((Rectangle)list).width + 30;
            ++n12;
        }
    }

    private AbstractGraphicalEditPart getVerticalMinPart(List list) {
        AbstractGraphicalEditPart abstractGraphicalEditPart = list.size() > 0 ? (AbstractGraphicalEditPart)list.get(0) : null;
        int n = 0;
        while (n < list.size()) {
            AbstractGraphicalEditPart abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)list.get(n);
            if (abstractGraphicalEditPart2.getFigure().getBounds().y < abstractGraphicalEditPart.getFigure().getBounds().y) {
                abstractGraphicalEditPart = abstractGraphicalEditPart2;
            }
            ++n;
        }
        return abstractGraphicalEditPart;
    }

    private AbstractGraphicalEditPart getHorizontalMinPart(List list) {
        AbstractGraphicalEditPart abstractGraphicalEditPart = list.size() > 0 ? (AbstractGraphicalEditPart)list.get(0) : null;
        int n = 0;
        while (n < list.size()) {
            AbstractGraphicalEditPart abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)list.get(n);
            if (abstractGraphicalEditPart2.getFigure().getBounds().x < abstractGraphicalEditPart.getFigure().getBounds().x) {
                abstractGraphicalEditPart = abstractGraphicalEditPart2;
            }
            ++n;
        }
        return abstractGraphicalEditPart;
    }

    private AbstractGraphicalEditPart getVerticalMaxPart(List list) {
        AbstractGraphicalEditPart abstractGraphicalEditPart = list.size() > 0 ? (AbstractGraphicalEditPart)list.get(0) : null;
        int n = 0;
        while (n < list.size()) {
            AbstractGraphicalEditPart abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)list.get(n);
            if (abstractGraphicalEditPart2.getFigure().getBounds().bottom() > abstractGraphicalEditPart.getFigure().getBounds().bottom()) {
                abstractGraphicalEditPart = abstractGraphicalEditPart2;
            }
            ++n;
        }
        return abstractGraphicalEditPart;
    }

    public void verticalAlignToFirstSelected(List list) {
        AbstractGraphicalEditPart abstractGraphicalEditPart;
        AbstractGraphicalEditPart abstractGraphicalEditPart2 = null;
        int n = 0;
        while (n < list.size()) {
            if (list.get(n) instanceof ShapeNodeEditPart) {
                abstractGraphicalEditPart = (AbstractGraphicalEditPart)list.get(n);
                if (abstractGraphicalEditPart2 == null) {
                    abstractGraphicalEditPart2 = abstractGraphicalEditPart;
                    break;
                }
            }
            ++n;
        }
        n = 0;
        while (n < list.size()) {
            if (list.get(n) instanceof ShapeNodeEditPart && (abstractGraphicalEditPart = (AbstractGraphicalEditPart)list.get(n)) != abstractGraphicalEditPart2) {
                ConnectionNodeEditPart connectionNodeEditPart2;
                Rectangle rectangle;
                Rectangle rectangle2 = abstractGraphicalEditPart.getFigure().getBounds();
                Rectangle rectangle3 = abstractGraphicalEditPart2.getFigure().getBounds();
                abstractGraphicalEditPart2.getFigure().getPreferredSize();
                int n2 = rectangle2.getCenter().x - rectangle3.getCenter().x;
                if (!(abstractGraphicalEditPart.getParent() instanceof DiagramEditPart)) {
                    abstractGraphicalEditPart = (AbstractGraphicalEditPart)abstractGraphicalEditPart.getParent();
                    rectangle = abstractGraphicalEditPart.getFigure().getBounds();
                    n2 += rectangle2.x - rectangle.x;
                    rectangle2 = rectangle;
                }
                rectangle = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)abstractGraphicalEditPart.getModel()), new Point(abstractGraphicalEditPart2.getFigure().getBounds().x - n2, rectangle2.y), rectangle2.width, -1);
                this.getCommandStack().execute((Command)rectangle);
                abstractGraphicalEditPart.getFigure().setLocation(new Point(abstractGraphicalEditPart2.getFigure().getBounds().x - n2, rectangle2.y));
                Point point = abstractGraphicalEditPart2.getFigure().getBounds().getCenter();
                boolean bl = false;
                List list2 = ((ShapeNodeEditPart)abstractGraphicalEditPart2).getSourceConnections();
                for (ConnectionNodeEditPart connectionNodeEditPart2 : list2) {
                    if (!connectionNodeEditPart2.getTarget().equals(abstractGraphicalEditPart)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    list2 = ((ShapeNodeEditPart)abstractGraphicalEditPart2).getTargetConnections();
                    for (ConnectionNodeEditPart connectionNodeEditPart2 : list2) {
                        if (!connectionNodeEditPart2.getSource().equals(abstractGraphicalEditPart)) continue;
                        bl = true;
                        break;
                    }
                }
                Point point2 = new Point();
                point2.x = (Integer)ViewUtil.getStructuralFeatureValue((View)((View)abstractGraphicalEditPart.getModel()), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
                point2.y = (Integer)ViewUtil.getStructuralFeatureValue((View)((View)abstractGraphicalEditPart.getModel()), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
                connectionNodeEditPart2 = point2.getCopy();
                Point point3 = abstractGraphicalEditPart.getFigure().getBounds().getCenter();
                int n3 = point.x - point3.x;
                connectionNodeEditPart2.x += n3;
                rectangle = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)abstractGraphicalEditPart.getModel()), (Point)connectionNodeEditPart2, abstractGraphicalEditPart.getFigure().getBounds().width, -1);
                this.getCommandStack().execute((Command)rectangle);
                abstractGraphicalEditPart.getFigure().setLocation(new Point(connectionNodeEditPart2.x, connectionNodeEditPart2.y));
            }
            ++n;
        }
    }

    public static Dimension getTextDimension(String string) {
        Font font;
        Dimension dimension;
        if (string != null && (dimension = FigureUtilities.getTextExtents((String)string, (Font)(font = DiagramConstants.DEFAULT_FONT))) != null) {
            return dimension;
        }
        return null;
    }

    private void anyObliqueLinks(ActivityDetailDiagramEditPart activityDetailDiagramEditPart, List list) {
        List list2 = activityDetailDiagramEditPart.getChildren();
        for (IGraphicalEditPart iGraphicalEditPart : list2) {
            if (!(iGraphicalEditPart instanceof RoleTaskCompositeEditPart)) continue;
            List list3 = ((RoleTaskCompositeEditPart)iGraphicalEditPart).getChildren();
            for (ShapeNodeEditPart shapeNodeEditPart : list3) {
                Point point;
                AbstractGraphicalEditPart abstractGraphicalEditPart;
                if (!(shapeNodeEditPart instanceof TaskNodeEditPart)) continue;
                Point point2 = shapeNodeEditPart.getFigure().getBounds().getCenter();
                List list4 = shapeNodeEditPart.getTargetConnections();
                if (!list4.isEmpty()) {
                    abstractGraphicalEditPart = (AbstractGraphicalEditPart)((ConnectionNodeEditPart)list4.get(0)).getSource();
                    point = abstractGraphicalEditPart.getFigure().getBounds().getCenter();
                    if (point2.x != point.x && !list.contains(iGraphicalEditPart)) {
                        list.add(iGraphicalEditPart);
                    }
                }
                if ((list4 = shapeNodeEditPart.getSourceConnections()).isEmpty()) continue;
                abstractGraphicalEditPart = (AbstractGraphicalEditPart)((ConnectionNodeEditPart)list4.get(0)).getSource();
                point = abstractGraphicalEditPart.getFigure().getBounds().getCenter();
                if (point2.x == point.x || list.contains(iGraphicalEditPart)) continue;
                list.add(iGraphicalEditPart);
            }
        }
    }
}

