/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.edit.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.epf.diagram.ad.custom.policies.OpenADEditPolicy;
import org.eclipse.epf.diagram.ad.edit.parts.UMLEditPartFactory;
import org.eclipse.epf.diagram.ad.edit.policies.UMLTextSelectionEditPolicy;
import org.eclipse.epf.diagram.ad.part.ActivityDiagramEditorPlugin;
import org.eclipse.epf.diagram.ad.providers.UMLElementTypes;
import org.eclipse.epf.diagram.core.util.DiagramConstants;
import org.eclipse.epf.diagram.core.util.DiagramCoreUtil;
import org.eclipse.epf.diagram.core.util.ValidatingTextDirectEditManager;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.handles.NonResizableHandleKit;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserService;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ParserHintAdapter;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

public class StructuredActivityNodeName3EditPart
extends CompartmentEditPart
implements ITextAwareEditPart {
    public static final int VISUAL_ID = 4010;
    private DirectEditManager manager;
    private IParser parser;
    private List parserElements;
    private String defaultText;

    public StructuredActivityNodeName3EditPart(View view) {
        super((EObject)view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new NonResizableEditPolicy(){

            protected List createSelectionHandles() {
                ArrayList arrayList = new ArrayList();
                NonResizableHandleKit.addMoveHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), arrayList);
                return arrayList;
            }

            public Command getCommand(Request request) {
                return null;
            }

            public boolean understandsRequest(Request request) {
                return false;
            }
        });
        this.installEditPolicy("OpenPolicy", (EditPolicy)new OpenADEditPolicy());
    }

    protected String getLabelTextHelper(IFigure iFigure) {
        if (iFigure instanceof WrapLabel) {
            return ((WrapLabel)iFigure).getText();
        }
        return ((Label)iFigure).getText();
    }

    protected void setLabelTextHelper(IFigure iFigure, String string) {
        if (iFigure instanceof WrapLabel) {
            ((WrapLabel)iFigure).setText(string);
        } else {
            ((Label)iFigure).setText(string);
        }
    }

    protected Image getLabelIconHelper(IFigure iFigure) {
        if (iFigure instanceof WrapLabel) {
            return ((WrapLabel)iFigure).getIcon();
        }
        return ((Label)iFigure).getIcon();
    }

    protected void setLabelIconHelper(IFigure iFigure, Image image) {
        if (iFigure instanceof WrapLabel) {
            ((WrapLabel)iFigure).setIcon(image);
        } else {
            ((Label)iFigure).setIcon(image);
        }
    }

    public void setLabel(WrapLabel wrapLabel) {
        this.unregisterVisuals();
        this.setFigure((IFigure)wrapLabel);
        this.defaultText = this.getLabelTextHelper((IFigure)wrapLabel);
        this.registerVisuals();
        this.refreshVisuals();
    }

    protected List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public IGraphicalEditPart getChildBySemanticHint(String string) {
        return null;
    }

    protected EObject getParserElement() {
        EObject eObject = this.resolveSemanticElement();
        return eObject != null ? eObject : (View)this.getModel();
    }

    protected Image getLabelIcon() {
        return ActivityDiagramEditorPlugin.getInstance().getSharedImage("diagram/iteration.gif");
    }

    protected String getLabelText() {
        String string = null;
        if (this.getParser() != null) {
            string = this.getParser().getPrintString((IAdaptable)new EObjectAdapter(this.getParserElement()), this.getParserOptions().intValue());
        }
        if (string == null || string.length() == 0) {
            string = this.defaultText;
        }
        return string;
    }

    public void setLabelText(String string) {
        this.setLabelTextHelper(this.getFigure(), string);
        EditPolicy editPolicy = this.getEditPolicy("PrimaryDrag Policy");
        if (editPolicy instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)editPolicy).refreshFeedback();
        }
    }

    public String getEditText() {
        if (this.getParser() == null) {
            return "";
        }
        return this.getParser().getEditString((IAdaptable)new EObjectAdapter(this.getParserElement()), this.getParserOptions().intValue());
    }

    protected boolean isEditable() {
        if (DiagramCoreUtil.isReadOnly((AbstractEditPart)this)) {
            return false;
        }
        return this.getEditText() != null;
    }

    public ICellEditorValidator getEditTextValidator() {
        return new ICellEditorValidator(){

            public String isValid(final Object object) {
                if (object instanceof String) {
                    final EObject eObject = StructuredActivityNodeName3EditPart.this.getParserElement();
                    final IParser iParser = StructuredActivityNodeName3EditPart.this.getParser();
                    try {
                        IParserEditStatus iParserEditStatus = (IParserEditStatus)StructuredActivityNodeName3EditPart.this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                            public void run() {
                                this.setResult(iParser.isValidEditString((IAdaptable)new EObjectAdapter(eObject), (String)object));
                            }
                        });
                        return iParserEditStatus.getCode() == 0 ? null : iParserEditStatus.getMessage();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                return null;
            }
        };
    }

    public IContentAssistProcessor getCompletionProcessor() {
        if (this.getParser() == null) {
            return null;
        }
        return this.getParser().getCompletionProcessor((IAdaptable)new EObjectAdapter(this.getParserElement()));
    }

    public ParserOptions getParserOptions() {
        return ParserOptions.NONE;
    }

    public IParser getParser() {
        if (this.parser == null) {
            String string = ((View)this.getModel()).getType();
            ParserHintAdapter parserHintAdapter = new ParserHintAdapter(this.getParserElement(), string){

                public Object getAdapter(Class clazz) {
                    if (IElementType.class.equals((Object)clazz)) {
                        return UMLElementTypes.StructuredActivityNode_1011;
                    }
                    return super.getAdapter(clazz);
                }
            };
            this.parser = ParserService.getInstance().getParser((IAdaptable)parserHintAdapter);
        }
        return this.parser;
    }

    protected DirectEditManager getManager() {
        if (this.manager == null) {
            this.setManager((DirectEditManager)new ValidatingTextDirectEditManager((GraphicalEditPart)this, TextDirectEditManager.getTextCellEditorClass((GraphicalEditPart)this), UMLEditPartFactory.getTextCellEditorLocator(this)){

                protected void performDirectEdit() {
                    ((StructuredActivityNodeName3EditPart)this.getEditPart()).performDirectEdit();
                }

                protected String validate(String string) {
                    return DiagramCoreUtil.validStringForBreakdownElements((EditPart)this.getEditPart(), (String)string);
                }
            });
        }
        return this.manager;
    }

    protected void setManager(DirectEditManager directEditManager) {
        this.manager = directEditManager;
    }

    protected void performDirectEdit() {
        this.getManager().show();
    }

    protected void performDirectEdit(Point point) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(point.getSWTPoint());
        }
    }

    private void performDirectEdit(char c) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(c);
        } else {
            this.performDirectEdit();
        }
    }

    protected void performDirectEditRequest(Request request) {
        final Request request2 = request;
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    if (StructuredActivityNodeName3EditPart.this.isActive() && StructuredActivityNodeName3EditPart.this.isEditable()) {
                        if (request2.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character c = (Character)request2.getExtendedData().get("directedit_extendeddata_initial_char");
                            StructuredActivityNodeName3EditPart.this.performDirectEdit(c.charValue());
                        } else if (request2 instanceof DirectEditRequest && StructuredActivityNodeName3EditPart.this.getEditText().equals(StructuredActivityNodeName3EditPart.this.getLabelText())) {
                            DirectEditRequest directEditRequest = (DirectEditRequest)request2;
                            StructuredActivityNodeName3EditPart.this.performDirectEdit(directEditRequest.getLocation());
                        } else {
                            StructuredActivityNodeName3EditPart.this.performDirectEdit();
                        }
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLabel();
        this.refreshFont();
        this.refreshFontColor();
        this.refreshUnderline();
        this.refreshStrikeThrough();
    }

    protected void refreshLabel() {
        this.setLabelTextHelper(this.getFigure(), this.getLabelText());
        this.setLabelIconHelper(this.getFigure(), this.getLabelIcon());
        EditPolicy editPolicy = this.getEditPolicy("PrimaryDrag Policy");
        if (editPolicy instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)editPolicy).refreshFeedback();
        }
    }

    protected void refreshUnderline() {
        FontStyle fontStyle = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (fontStyle != null && this.getFigure() instanceof WrapLabel) {
            ((WrapLabel)this.getFigure()).setTextUnderline(fontStyle.isUnderline());
        }
    }

    protected void refreshStrikeThrough() {
        FontStyle fontStyle = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (fontStyle != null && this.getFigure() instanceof WrapLabel) {
            ((WrapLabel)this.getFigure()).setTextStrikeThrough(fontStyle.isStrikeThrough());
        }
    }

    protected void refreshFont() {
        FontStyle fontStyle = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (fontStyle != null) {
            String string = DiagramConstants.getFontName((FontStyle)fontStyle);
            FontData fontData = new FontData(string, fontStyle.getFontHeight(), (fontStyle.isBold() ? 1 : 0) | (fontStyle.isItalic() ? 2 : 0));
            this.setFont(fontData);
        }
    }

    protected void setFontColor(Color color) {
        Color color2 = DiagramCoreUtil.getFontColor((AbstractEditPart)this);
        if (color2 != null) {
            color = color2;
        }
        this.getFigure().setForegroundColor(color);
    }

    protected void addSemanticListeners() {
        if (this.getParser() instanceof ISemanticParser) {
            EObject eObject = this.resolveSemanticElement();
            this.parserElements = ((ISemanticParser)this.getParser()).getSemanticElementsBeingParsed(eObject);
            int n = 0;
            while (n < this.parserElements.size()) {
                this.addListenerFilter("SemanticModel" + n, (NotificationListener)this, (EObject)this.parserElements.get(n));
                ++n;
            }
        } else {
            super.addSemanticListeners();
        }
    }

    protected void removeSemanticListeners() {
        if (this.parserElements != null) {
            int n = 0;
            while (n < this.parserElements.size()) {
                this.removeListenerFilter("SemanticModel" + n);
                ++n;
            }
        } else {
            super.removeSemanticListeners();
        }
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent accessibleEvent) {
                    accessibleEvent.result = StructuredActivityNodeName3EditPart.this.getLabelTextHelper(StructuredActivityNodeName3EditPart.this.getFigure());
                }
            };
        }
        return this.accessibleEP;
    }

    private View getFontStyleOwnerView() {
        return this.getPrimaryView();
    }

    protected void addNotationalListeners() {
        super.addNotationalListeners();
        this.addListenerFilter("PrimaryView", (NotificationListener)this, (EObject)this.getPrimaryView());
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.removeListenerFilter("PrimaryView");
    }

    protected void handleNotificationEvent(Notification notification) {
        Object object = notification.getFeature();
        if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(object)) {
            Integer n = (Integer)notification.getNewValue();
            this.setFontColor(DiagramColorRegistry.getInstance().getColor(n));
        } else if (NotationPackage.eINSTANCE.getFontStyle_Underline().equals(object)) {
            this.refreshUnderline();
        } else if (NotationPackage.eINSTANCE.getFontStyle_StrikeThrough().equals(object)) {
            this.refreshStrikeThrough();
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(object) || NotationPackage.eINSTANCE.getFontStyle_FontName().equals(object) || NotationPackage.eINSTANCE.getFontStyle_Bold().equals(object) || NotationPackage.eINSTANCE.getFontStyle_Italic().equals(object)) {
            this.refreshFont();
        } else {
            ISemanticParser iSemanticParser;
            if (this.getParser() != null && this.getParser().isAffectingEvent((Object)notification, this.getParserOptions().intValue())) {
                this.refreshLabel();
            }
            if (this.getParser() instanceof ISemanticParser && (iSemanticParser = (ISemanticParser)this.getParser()).areSemanticElementsAffected(null, (Object)notification)) {
                this.removeSemanticListeners();
                if (this.resolveSemanticElement() != null) {
                    this.addSemanticListeners();
                }
                this.refreshLabel();
            }
        }
        super.handleNotificationEvent(notification);
    }

    protected IFigure createFigure() {
        return null;
    }
}

