/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.web.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.Hits;
import org.eclipse.epf.web.search.IndexLoader;
import org.eclipse.epf.web.search.IndexSearch;
import org.eclipse.epf.web.search.SearchResources;
import org.eclipse.epf.web.search.utils.StrUtil;
import org.eclipse.epf.web.search.utils.UNCUtil;
import org.eclipse.epf.web.search.utils.XMLUtil;
import org.eclipse.epf.web.search.utils.XSLTProcessor;

public class SearchServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String DefaultEncoding = "iso-8859-1";
    private static final String ServletEncoding = "utf-8";
    private int _hitsPerPage = 10;
    private static String _indexPath = null;
    private static String _xslURL;
    private static String _pathDocumentBase;
    private static String _siteFolderName;
    private String _currentSearchString;
    private String _queryString;
    private String _webAppName;
    private Hits _hits;
    private int _numHits;
    private int _currentPage;
    private String analyzerName;
    private HttpServletResponse _response;
    public static final String EMPTY_HTML = "<html></html>";
    private Properties xslParams = null;

    static {
        _siteFolderName = null;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            _indexPath = config.getServletContext().getRealPath(config.getInitParameter("searchIndex"));
            _xslURL = config.getServletContext().getRealPath(config.getInitParameter("xslFile"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        response.setContentType("text/html; charset=utf-8");
        PrintWriter out = response.getWriter();
        this._response = response;
        request.setCharacterEncoding("UTF-8");
        String requestUrl = request.getRequestURL().toString();
        _pathDocumentBase = requestUrl.substring(0, requestUrl.lastIndexOf(47));
        try {
            _siteFolderName = IndexLoader.getSiteFolderName((String)_pathDocumentBase);
            this.analyzerName = IndexLoader.getAnalyzerName();
            HttpSession httpSession = session;
            synchronized (httpSession) {
                String action = request.getParameter("action");
                this._webAppName = request.getContextPath();
                if (action != null && action.length() > 0) {
                    this._hits = (Hits)session.getAttribute("hits");
                    this._queryString = (String)session.getAttribute("queryString");
                    this._numHits = (Integer)session.getAttribute("numHits");
                    this._currentPage = (Integer)session.getAttribute("currentPage");
                    if (action.indexOf("next") > -1) {
                        String results = this.getPageResult(true);
                        session.setAttribute("numHits", (Object)new Integer(this._numHits));
                        session.setAttribute("currentPage", (Object)new Integer(this._currentPage));
                        out.println(results);
                    } else {
                        String results = this.getPageResult(false);
                        session.setAttribute("numHits", (Object)new Integer(this._numHits));
                        session.setAttribute("currentPage", (Object)new Integer(this._currentPage));
                        out.println(results);
                    }
                } else {
                    String searchString = request.getParameter("searchString");
                    System.out.println("LD> searchString: " + searchString);
                    if (searchString == null || searchString.length() == 0) {
                        response.sendError(204);
                        return;
                    }
                    searchString = this.convert(searchString);
                    String resultsPerPage = request.getParameter("hitsPerPage");
                    if (resultsPerPage != null && resultsPerPage.length() > 0) {
                        this._hitsPerPage = Integer.parseInt(resultsPerPage);
                    }
                    String results = this.runSearch(searchString);
                    session.setAttribute("hits", (Object)this._hits);
                    session.setAttribute("queryString", (Object)this._queryString);
                    session.setAttribute("numHits", (Object)new Integer(this._numHits));
                    session.setAttribute("currentPage", (Object)new Integer(this._currentPage));
                    out.println(results);
                }
            }
        }
        catch (Exception ex) {
            this.writeOutputError(response.getOutputStream(), SearchResources.getString((String)"SearchFailed"), ex);
        }
    }

    private String convert(String str) {
        try {
            byte[] bytes = str.getBytes(DefaultEncoding);
            String newStr = new String(bytes, ServletEncoding);
            System.out.println("convert " + str + " -> " + newStr);
            return newStr;
        }
        catch (Exception exception) {
            return str;
        }
    }

    private String runSearch(String searchString) {
        block3: {
            try {
                this._queryString = searchString.replace(':', ' ');
                this._currentSearchString = IndexSearch.detectHyphenated((String)this._queryString);
                if (this._currentSearchString.length() != 0) break block3;
                return EMPTY_HTML;
            }
            catch (Exception e) {
                e.printStackTrace();
                return EMPTY_HTML;
            }
        }
        boolean safe = this.runQuery("contents");
        String result = this.updateOutput(safe);
        return result == null ? EMPTY_HTML : result;
    }

    private boolean runQuery(String searchField) {
        boolean result = false;
        try {
            System.out.println("LD> _indexPath: " + _indexPath);
            System.out.println("LD> _currentSearchString: " + this._currentSearchString);
            if (this._currentSearchString != null) {
                System.out.println("LD> unicodes: " + SearchServlet.escapeUnicodeString(this._currentSearchString, false));
            }
            System.out.println("LD> analyzerName: " + this.analyzerName);
            this._hits = IndexSearch.search((String)_indexPath, (String)this._currentSearchString, (String)searchField, (String)this.analyzerName);
            System.out.println("LD> _hits: " + (this._hits == null ? "null" : Integer.toString(this._hits.length())));
            this._numHits = this._hits.length();
            result = true;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            this._numHits = 0;
            this._hits = null;
        }
        this._currentPage = 0;
        return result;
    }

    private String updateOutput(boolean safe) {
        String output = null;
        if (safe) {
            output = this.generateOutput(this._numHits, this._currentPage);
        } else {
            this._hits = null;
        }
        return output;
    }

    private String generateOutput(int numHits, int pageNum) {
        boolean prevEnabled;
        int init = pageNum * this._hitsPerPage;
        int max = Math.min(numHits, init + this._hitsPerPage);
        boolean nextEnabled = numHits > (this._currentPage + 1) * this._hitsPerPage;
        boolean bl = prevEnabled = this._currentPage > 0;
        if (this._hits == null) {
            return null;
        }
        try {
            StringBuffer searchResultXML = new StringBuffer();
            searchResultXML.append("<SearchResult").append(" totalHits=\"").append(numHits).append("\" initPageNum=\"").append(init > 0 ? init + 1 : (numHits < 1 ? 0 : 1)).append("\" maxPageNum=\"").append(max).append("\" hitsPerPage=\"").append(this._hitsPerPage).append("\" nextEnabled=\"").append(nextEnabled).append("\" prevEnabled=\"").append(prevEnabled).append("\" nextText=\"").append(SearchResources.getString((String)"nextActionText")).append("\" prevText=\"").append(SearchResources.getString((String)"previousActionText")).append("\" imagePath=\"").append(String.valueOf(_pathDocumentBase) + "/search/images/").append("\" searchString=\"").append(XMLUtil.escape((String)this._queryString)).append("\" nextHref=\"").append(this._response.encodeURL(String.valueOf(this._webAppName) + "/SearchServlet?action=next")).append("\" prevHref=\"").append(this._response.encodeURL(String.valueOf(this._webAppName) + "/SearchServlet?action=prev")).append("\">");
            int i = init;
            while (i < max) {
                String strSummary;
                String strTitle;
                Document doc = this._hits.doc(i);
                Field url = doc.getField("url");
                Field title = doc.getField("title");
                Field summary = doc.getField("summary");
                Field umaType = doc.getField("uma.type");
                searchResultXML.append("<SearchHit");
                if (url != null) {
                    StringBuffer bufferURL = new StringBuffer();
                    String strUrl = url.stringValue();
                    bufferURL.append(_pathDocumentBase).append(strUrl.substring(strUrl.indexOf(_siteFolderName) + _siteFolderName.length()));
                    if (strUrl != null) {
                        strUrl = XMLUtil.escape((String)strUrl);
                        searchResultXML.append(" url=\"").append(UNCUtil.convertFilenameToUNC((String)bufferURL.toString())).append("\"");
                    }
                }
                if (title != null && (strTitle = title.stringValue()) != null) {
                    strTitle = XMLUtil.escape((String)strTitle);
                    searchResultXML.append(" title=\"").append(strTitle).append("\"");
                }
                if (summary != null && (strSummary = summary.stringValue()) != null) {
                    strSummary = XMLUtil.escape((String)strSummary);
                    searchResultXML.append(" summary=\"").append(strSummary).append("\"");
                }
                if (umaType != null) {
                    String[] keyWords = new String[]{"Product", "Descriptor", "Process", "Pattern", "Type", "Definition", "Asset", "Considerations", "Category", "Material", "Grouping", "Set", "Tool"};
                    String strUmaType = StrUtil.convertFirstLetterCase((String)umaType.stringValue(), (String[])keyWords);
                    if (strUmaType.equalsIgnoreCase("General_content")) {
                        searchResultXML.append(" icon=\"").append("Other.gif").append("\"");
                    } else {
                        strUmaType = XMLUtil.escape((String)strUmaType);
                        searchResultXML.append(" icon=\"").append(strUmaType).append(".gif").append("\"");
                    }
                }
                searchResultXML.append("/>");
                ++i;
            }
            searchResultXML.append("</SearchResult>");
            StringWriter result = new StringWriter();
            XSLTProcessor.transform((String)_xslURL, (String)searchResultXML.toString(), (Properties)this.xslParams, (Writer)result);
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return EMPTY_HTML;
        }
    }

    private String getPageResult(boolean isNext) {
        this._currentPage = isNext ? ++this._currentPage : --this._currentPage;
        String result = this.updateOutput(true);
        return result == null ? EMPTY_HTML : result;
    }

    private void writeOutputError(ServletOutputStream os, String message, Exception ex) throws ServletException {
        Throwable t = ex;
        System.out.println("Exceptio: " + ex);
        if (ex instanceof InvocationTargetException) {
            t = ((InvocationTargetException)ex).getTargetException();
        }
        try {
            os.println("<hr>" + message + "<hr>");
            t.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String escapeUnicodeString(String str, boolean escapeAscii) {
        StringBuffer ostr = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (!escapeAscii && ch >= ' ' && ch <= '~') {
                ostr.append(ch);
            } else {
                ostr.append("\\u");
                String hex = Integer.toHexString(str.charAt(i) & 0xFFFF);
                int j = 0;
                while (j < 4 - hex.length()) {
                    ostr.append("0");
                    ++j;
                }
                ostr.append(hex.toUpperCase(Locale.ENGLISH));
            }
            ++i;
        }
        return new String(ostr);
    }
}

