/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.html;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.regex.Pattern;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.w3c.tidy.Tidy;

public class HTMLFormatter {
    private static final String HTML_BODY_START_TAG = "<body";
    private static final String HTML_BODY_END_TAG = "</body>";
    private static final int HTML_BODY_START_TAG_LENGTH = "<body".length();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.epf.common.HTMLFormatter";
    private int lineWidth;
    private boolean indent;
    private int indentSize;
    private String lastErrorStr;
    private static final Pattern p_whitespace = Pattern.compile("^\\s+", 8);
    public static final Pattern jTidyErrorParser = Pattern.compile("(line\\s+(\\d+)\\s+column\\s+(\\d+))\\s+-\\s+(.+)", 2);
    public static final String PRE_TAG_START = "<pre>";
    public static final String PRE_TAG_END = "</pre>";
    public static final int PRE_TAG_END_LENGTH = "</pre>".length();

    public HTMLFormatter() {
        this(132, true, 4);
    }

    public HTMLFormatter(int n, boolean bl, int n2) {
        this.lineWidth = n;
        this.indent = bl;
        this.indentSize = n2;
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
    }

    public void setIndent(boolean bl) {
        this.indent = bl;
    }

    public void setIndentSize(int n) {
        this.indentSize = n;
    }

    public String formatHTML(String string) throws UnsupportedEncodingException {
        return this.formatHTML(string, false, false, false, false);
    }

    public String formatHTML(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws UnsupportedEncodingException {
        this.lastErrorStr = null;
        if (string == null || string.length() == 0) {
            return string;
        }
        string = HTMLFormatter.removeLeadingWhitespace(string);
        Tidy tidy = new Tidy();
        tidy.setXHTML(true);
        tidy.setDropEmptyParas(false);
        tidy.setDropFontTags(false);
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        tidy.setSmartIndent(false);
        tidy.setTidyMark(false);
        tidy.setWraplen(this.lineWidth);
        tidy.setIndentAttributes(false);
        tidy.setIndentContent(this.indent);
        tidy.setSpaces(this.indentSize);
        tidy.setInputEncoding("UTF-16");
        tidy.setOutputEncoding("UTF-16");
        tidy.setFixBackslash(false);
        if (bl2) {
            tidy.setForceOutput(true);
        }
        if (bl3) {
            tidy.setMakeBare(true);
        }
        if (bl4) {
            tidy.setWord2000(true);
        }
        StringReader stringReader = new StringReader(string);
        StringWriter stringWriter = new StringWriter();
        StringWriter stringWriter2 = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter2);
        tidy.setErrout(printWriter);
        tidy.parse((Reader)stringReader, (Writer)stringWriter);
        String string2 = stringWriter2.getBuffer().toString();
        if (string2 != null && string2.length() > 0 && string2.startsWith("line") && string2.indexOf("column") > 0) {
            this.lastErrorStr = string2;
            if (!bl2) {
                return string;
            }
        }
        String string3 = ((Object)stringWriter).toString();
        string3 = StrUtil.getEscapedHTML(string3);
        String string4 = string.substring(0, Math.min(10, string.length())).toUpperCase();
        if (bl || !string4.startsWith("<!DOCTYPE") && !string4.startsWith("<HTML")) {
            int n = string3.indexOf(HTML_BODY_START_TAG);
            int n2 = -1;
            if (n != -1) {
                n2 = string3.indexOf(">", n);
            }
            int n3 = string3.indexOf(HTML_BODY_END_TAG);
            if (n2 == -1 || n3 == -1) {
                return "";
            }
            if (++n2 >= n3) {
                return "";
            }
            n2 += FileUtil.LINE_SEP_LENGTH;
            n3 -= FileUtil.LINE_SEP_LENGTH;
            if (this.indent && this.indentSize > 0) {
                n3 -= this.indentSize;
            }
            if (n2 >= n3) {
                return "";
            }
            String string5 = string3.substring(n2, n3);
            if (this.indent && this.indentSize > 0) {
                String string6 = HTMLFormatter.getIndentStr(this.indentSize * 2);
                string5 = HTMLFormatter.fixIndentation(string5, string6);
                return string5;
            }
        }
        return string3;
    }

    private static String getIndentStr(int n) {
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(' ');
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static String fixIndentation(String string, String string2) {
        if (string.startsWith(string2)) {
            string = string.substring(string2.length());
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        int n2 = -1;
        while ((n = string.indexOf(PRE_TAG_START, n2)) != -1) {
            stringBuffer.append(string.substring(n2 < 0 ? 0 : n2 + PRE_TAG_END_LENGTH, n).replaceAll("\r\n" + string2, "\r\n"));
            n2 = string.indexOf(PRE_TAG_END, n);
            if (n2 != -1) {
                stringBuffer.append(string.substring(n, n2 + PRE_TAG_END_LENGTH));
                continue;
            }
            stringBuffer.append(string.substring(n));
            return stringBuffer.toString();
        }
        stringBuffer.append(string.substring(n2 < 0 ? 0 : n2 + PRE_TAG_END_LENGTH).replaceAll("\r\n" + string2, "\r\n"));
        return stringBuffer.toString();
    }

    public String getLastErrorStr() {
        return this.lastErrorStr;
    }

    public static String removeLeadingWhitespace(String string) {
        return p_whitespace.matcher(string).replaceAll("");
    }
}

