/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.FullyRevertibleCommandStack;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;

public class ActionManager
implements IActionManager {
    protected static final Map RESOURCE_TO_MODIFIERS_MAP = new HashMap();
    private EditingDomain editingDomain;
    private FullyRevertibleCommandStack commandStack = this.createCommandStack();

    public ActionManager() {
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory(), (CommandStack)this.commandStack);
    }

    protected FullyRevertibleCommandStack createCommandStack() {
        return new FullyRevertibleCommandStack(this);
    }

    protected void registerAsModifierOf(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource == null) {
            return;
        }
        this.registerAsModifierOf(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerAsModifierOf(Resource resource) {
        Map map = RESOURCE_TO_MODIFIERS_MAP;
        synchronized (map) {
            HashSet<ActionManager> hashSet = (HashSet<ActionManager>)RESOURCE_TO_MODIFIERS_MAP.get(resource);
            if (hashSet == null) {
                hashSet = new HashSet<ActionManager>();
                RESOURCE_TO_MODIFIERS_MAP.put(resource, hashSet);
            }
            hashSet.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterAsModifier() {
        Map map = RESOURCE_TO_MODIFIERS_MAP;
        synchronized (map) {
            for (Resource resource : this.getModifiedResources()) {
                Set set = (Set)RESOURCE_TO_MODIFIERS_MAP.get(resource);
                if (set == null) continue;
                set.remove(this);
                if (!set.isEmpty()) continue;
                this.save(resource);
                RESOURCE_TO_MODIFIERS_MAP.remove(resource);
            }
        }
    }

    public boolean doAction(int n, EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n2) {
        RemoveCommand removeCommand = null;
        Object object2 = null;
        switch (n) {
            case 3: {
                if (n2 >= 0) {
                    removeCommand = new AddCommand(this.editingDomain, eObject, eStructuralFeature, object, n2);
                    break;
                }
                removeCommand = new AddCommand(this.editingDomain, eObject, eStructuralFeature, object);
                break;
            }
            case 5: {
                if (n2 >= 0) {
                    removeCommand = new AddCommand(this.editingDomain, eObject, eStructuralFeature, (Collection)object, n2);
                    break;
                }
                removeCommand = new AddCommand(this.editingDomain, eObject, eStructuralFeature, (Collection)object);
                break;
            }
            case 4: {
                removeCommand = new RemoveCommand(this.editingDomain, eObject, eStructuralFeature, object);
                break;
            }
            case 6: {
                removeCommand = new RemoveCommand(this.editingDomain, eObject, eStructuralFeature, (Collection)object);
                break;
            }
            case 1: {
                object2 = eObject.eGet(eStructuralFeature);
                if ((object2 == null || object2.equals(object)) && (object2 != null || object == null)) break;
                removeCommand = new SetCommand(this.editingDomain, eObject, eStructuralFeature, object);
            }
        }
        if (removeCommand != null) {
            return this.commandStack.doExecute((Command)removeCommand);
        }
        return false;
    }

    public void undo() {
        this.commandStack.undo();
    }

    public void redo() {
        this.commandStack.redo();
    }

    public boolean undoAll() {
        boolean bl = this.commandStack.undoAll();
        this.unregisterAsModifier();
        return bl;
    }

    public void saveIsDone() {
        this.commandStack.saveIsDone();
        this.unregisterAsModifier();
    }

    public boolean isSaveNeeded() {
        boolean bl = this.commandStack.isSaveNeeded();
        if (!bl) {
            return false;
        }
        if (this.getModifiedResources().isEmpty()) {
            return false;
        }
        return bl;
    }

    public void dispose() {
        this.commandStack.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getModifiedResources() {
        Map map = RESOURCE_TO_MODIFIERS_MAP;
        synchronized (map) {
            HashSet hashSet = new HashSet();
            for (Map.Entry entry : RESOURCE_TO_MODIFIERS_MAP.entrySet()) {
                Set set = (Set)entry.getValue();
                if (!set.contains(this)) continue;
                hashSet.add(entry.getKey());
            }
            return hashSet;
        }
    }

    protected void save(Resource resource) {
    }

    public CommandStack getCommandStack() {
        return this.commandStack;
    }

    public boolean execute(IResourceAwareCommand iResourceAwareCommand) {
        if (iResourceAwareCommand != null) {
            return this.commandStack.doExecute(iResourceAwareCommand);
        }
        return false;
    }
}

