/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.UmaUtil;

public class AddToCategoryCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private ContentCategory category;
    private EStructuralFeature feature;
    private MethodElement element;
    private String[] categoryPkgPath;
    private boolean checkForExistingContributor;
    private ContentCategory usedCategory = null;
    private boolean createNewContributor = false;
    private ContentPackage categoryPkg;
    private Collection modifiedResources;
    private Object oldOppositeFeatureValue;
    private List usedCategories;

    public AddToCategoryCommand(ContentCategory contentCategory, MethodElement methodElement, EStructuralFeature eStructuralFeature, String[] stringArray, boolean bl, List list) {
        this.category = contentCategory;
        this.feature = eStructuralFeature;
        this.element = methodElement;
        this.categoryPkgPath = stringArray;
        this.checkForExistingContributor = bl;
        this.usedCategories = list;
    }

    protected boolean prepare() {
        return UserInteractionHelper.checkModifyOpposite((MethodElement)this.category, this.feature, this.element);
    }

    public String getLabel() {
        return "Add To Category";
    }

    public void execute() {
        MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)this.element);
        MethodPlugin methodPlugin2 = UmaUtil.getMethodPlugin((EObject)this.category);
        if (methodPlugin2 != methodPlugin && Misc.isBaseOf(methodPlugin2, methodPlugin)) {
            if (this.category.getVariabilityBasedOnElement() != null) {
                throw new IllegalArgumentException("Could not add element to an extended category that is in a different plug-in: " + this.category);
            }
            if (!this.feature.isMany()) {
                throw new UnsupportedOperationException();
            }
            this.categoryPkg = UmaUtil.findContentPackage((MethodPlugin)methodPlugin, (String[])this.categoryPkgPath);
            ContentCategory contentCategory = null;
            if (this.checkForExistingContributor) {
                contentCategory = TngUtil.findContributor(this.categoryPkg, this.category);
            }
            if (contentCategory == null) {
                this.createNewContributor = true;
            } else {
                this.usedCategory = contentCategory;
            }
        } else {
            this.usedCategory = this.category;
        }
        this.modifiedResources = new HashSet();
        this.redo();
    }

    public void redo() {
        Collection collection;
        MultiResourceEObject multiResourceEObject;
        OppositeFeature oppositeFeature;
        if (this.createNewContributor) {
            oppositeFeature = (ContentCategory)UmaFactory.eINSTANCE.create(this.category.eClass());
            oppositeFeature.setVariabilityBasedOnElement((VariabilityElement)this.category);
            oppositeFeature.setVariabilityType(VariabilityType.CONTRIBUTES_LITERAL);
            this.categoryPkg.getContentElements().add(oppositeFeature);
            this.usedCategory = oppositeFeature;
            if (this.usedCategory instanceof CustomCategory) {
                multiResourceEObject = TngUtil.getRootCustomCategory(UmaUtil.getMethodPlugin((EObject)this.usedCategory));
                collection = multiResourceEObject.getCategorizedElements();
                collection.add(this.usedCategory);
                TngUtil.setDefaultName((CustomCategory)multiResourceEObject, (CustomCategory)this.usedCategory, this.category.getName());
            } else {
                this.usedCategory.setName(this.category.getName());
            }
        }
        oppositeFeature = OppositeFeature.getOppositeFeature((EStructuralFeature)this.feature);
        multiResourceEObject = (MultiResourceEObject)this.element;
        this.oldOppositeFeatureValue = multiResourceEObject.getOppositeFeatureMap().get(oppositeFeature);
        if (this.feature.isMany()) {
            collection = (Collection)this.usedCategory.eGet(this.feature);
            if (this.oldOppositeFeatureValue != null && !oppositeFeature.isMany() && this.oldOppositeFeatureValue != this.usedCategory) {
                EObject eObject = (EObject)this.oldOppositeFeatureValue;
                ((Collection)eObject.eGet(this.feature)).remove(this.element);
                if (eObject.eResource() != null) {
                    this.modifiedResources.add(eObject.eResource());
                }
                collection.add(this.element);
            }
            if (!collection.contains(this.element)) {
                collection.add(this.element);
            }
        } else {
            if (this.oldOppositeFeatureValue != null && !oppositeFeature.isMany() && this.oldOppositeFeatureValue != this.usedCategory) {
                collection = (EObject)this.oldOppositeFeatureValue;
                collection.eSet(this.feature, null);
                if (collection.eResource() != null) {
                    this.modifiedResources.add(collection.eResource());
                }
            }
            if (this.usedCategory != this.oldOppositeFeatureValue) {
                this.usedCategory.eSet(this.feature, (Object)this.element);
            }
        }
        if (this.usedCategory.eResource() != null) {
            this.modifiedResources.add(this.usedCategory.eResource());
        }
        if (this.usedCategories.contains(this.category)) {
            this.usedCategories.remove(this.category);
        }
    }

    public void undo() {
        Collection collection;
        OppositeFeature oppositeFeature = OppositeFeature.getOppositeFeature((EStructuralFeature)this.feature);
        if (this.feature.isMany()) {
            collection = (Collection)this.usedCategory.eGet(this.feature);
            collection.remove(this.element);
        } else {
            this.usedCategory.eSet(this.feature, null);
        }
        if (!oppositeFeature.isMany() && this.oldOppositeFeatureValue != null && this.oldOppositeFeatureValue != this.usedCategory) {
            collection = (EObject)this.oldOppositeFeatureValue;
            if (this.feature.isMany()) {
                ((Collection)collection.eGet(this.feature)).add(this.element);
            } else {
                collection.eSet(this.feature, this.element);
            }
        }
        if (this.createNewContributor && TngUtil.isEmpty(this.usedCategory)) {
            collection = UmaUtil.getMethodPlugin((EObject)this.usedCategory);
            EcoreUtil.remove((EObject)this.usedCategory);
            if (this.usedCategory instanceof CustomCategory) {
                TngUtil.getRootCustomCategory((MethodPlugin)collection).getCategorizedElements().remove(this.usedCategory);
            }
            this.usedCategory = null;
        }
        if (!this.usedCategories.contains(this.category)) {
            this.usedCategories.add(this.category);
        }
    }

    public Collection getAffectedObjects() {
        return Collections.singletonList(this.usedCategory);
    }

    public Collection getModifiedResources() {
        if (this.category != null && this.category.eResource() != null && this.modifiedResources == null) {
            this.modifiedResources = new HashSet();
            this.modifiedResources.add(this.category.eResource());
        }
        if (this.modifiedResources == null) {
            return Collections.EMPTY_LIST;
        }
        return this.modifiedResources;
    }
}

