/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.IConfigurable;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.ILibraryItemProvider;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.configuration.UncategorizedItemProvider;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.util.UmaUtil;

public class CategoriesItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IConfigurable,
ILibraryItemProvider {
    protected List children;
    private String label;
    private Object parent;
    protected String[] categoryPkgPath;
    protected IFilter filter;
    private Object image;
    protected IFilter uncategorizedFilter;
    protected String uncategorizedLabel;
    protected IFilter categorizedFilter;
    protected Object uncategorizedImage;
    protected MethodConfiguration methodConfig;
    private UncategorizedItemProvider uncategorizedItemProvider;

    public CategoriesItemProvider(AdapterFactory adapterFactory, MethodConfiguration methodConfiguration, String string, Object object, String[] stringArray) {
        super(adapterFactory);
        this.methodConfig = methodConfiguration;
        this.label = string;
        this.categoryPkgPath = stringArray;
        this.image = object;
    }

    protected UncategorizedItemProvider createUncategorizedItemProvider() {
        if (this.uncategorizedItemProvider == null) {
            this.uncategorizedItemProvider = new UncategorizedItemProvider(this.adapterFactory, this.methodConfig, this.uncategorizedFilter, this.uncategorizedLabel, this.uncategorizedImage);
        }
        return this.uncategorizedItemProvider;
    }

    public Collection getChildren(Object object) {
        if (this.children == null) {
            this.children = new ArrayList();
        } else {
            this.children.clear();
        }
        for (Object object2 : this.methodConfig.getMethodPluginSelection()) {
            ContentPackage contentPackage = UmaUtil.findContentPackage((MethodPlugin)object2, (String[])this.categoryPkgPath);
            if (contentPackage == null) continue;
            for (ContentCategory contentCategory : contentPackage.getContentElements()) {
                if (!this.categorizedFilter.accept(contentCategory) || this.filter != null && !this.filter.accept(contentCategory)) continue;
                this.children.add(contentCategory);
            }
        }
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object object2;
            object2 = TngAdapterFactory.INSTANCE.getConfigurationView_ComposedAdapterFactory().adapt(iterator.next(), ITreeItemContentProvider.class);
            if (object2 instanceof ILibraryItemProvider) {
                ((ILibraryItemProvider)object2).setParent(this);
            }
            if (!(object2 instanceof IConfigurable)) continue;
            ((IConfigurable)object2).setFilter(this.filter);
        }
        if (this.uncategorizedFilter != null) {
            this.children.add(this.createUncategorizedItemProvider());
        }
        return this.children;
    }

    public Collection getNewChildDescriptors(Object object, EditingDomain editingDomain, Object object2) {
        return super.getNewChildDescriptors((Object)this.methodConfig, editingDomain, object2);
    }

    public Object getParent(Object object) {
        if (this.parent != null) {
            return this.parent;
        }
        if (object instanceof EObject) {
            return super.getParent(object);
        }
        return null;
    }

    public Object getImage(Object object) {
        return this.image;
    }

    public String getText(Object object) {
        if (this.label != null) {
            return this.label;
        }
        return super.getText(object);
    }

    public void setFilter(IFilter iFilter) {
        this.filter = iFilter;
    }

    public void setCategorizedFilter(IFilter iFilter) {
        this.categorizedFilter = iFilter;
    }

    public void setUncategorizedFilter(IFilter iFilter) {
        this.uncategorizedFilter = iFilter;
    }

    public void setUncategorizedLabel(String string) {
        this.uncategorizedLabel = string;
    }

    public void setUncategorizedImage(Object object) {
        this.uncategorizedImage = object;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setParent(Object object) {
        this.parent = object;
    }

    public Collection getChildrenFeatures(Object object) {
        return super.getChildrenFeatures(object);
    }

    public void dispose() {
        if (this.uncategorizedItemProvider != null) {
            this.uncategorizedItemProvider.dispose();
        }
        super.dispose();
    }
}

