/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.element;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.library.edit.IConfigurable;
import org.eclipse.epf.library.edit.IDefaultNameSetter;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.ILibraryItemProvider;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.edit.command.MethodElementCreateCopyCommand;
import org.eclipse.epf.uma.edit.command.MethodElementInitializeCopyCommand;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.swt.graphics.Image;

public class ArtifactItemProvider
extends org.eclipse.epf.uma.provider.ArtifactItemProvider
implements IDefaultNameSetter,
ILibraryItemProvider,
IConfigurable {
    private IFilter filter;

    public ArtifactItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Object getParent(Object object) {
        Artifact artifact = (Artifact)object;
        if (artifact != null && artifact.eContainer() instanceof Artifact) {
            return super.getParent(object);
        }
        return TngUtil.getNavigatorParentItemProvider((WorkProduct)artifact);
    }

    protected void collectNewChildDescriptors(Collection collection, Object object) {
        collection.add(this.createChildParameter(UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts(), UmaFactory.eINSTANCE.createArtifact()));
    }

    public void notifyChanged(Notification notification) {
        this.setDefaultName(notification);
        this.updateChildren(notification);
        TngUtil.refreshParentIfNameChanged(notification, (ItemProviderAdapter)this);
        switch (notification.getFeatureID(Discipline.class)) {
            case 0: {
                TngUtil.refreshContributors((IChangeNotifier)this, notification, false, true);
                break;
            }
            case 20: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                TngUtil.refreshWorkProductTypeUncategorized(UmaUtil.getMethodPlugin((EObject)((EObject)this.target)), notification);
                return;
            }
            case 25: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public Collection getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            this.childrenFeatures = new ArrayList();
            this.childrenFeatures.add(UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts());
        }
        return this.childrenFeatures;
    }

    public void setDefaultName(Notification notification) {
        int n;
        ArtifactItemProvider artifactItemProvider = this;
        if (artifactItemProvider.getInterestedFeatureOwnerClass() != null && (n = notification.getFeatureID(artifactItemProvider.getInterestedFeatureOwnerClass())) == artifactItemProvider.getInterestedFeatureID()) {
            switch (notification.getEventType()) {
                case 3: {
                    this.setDefaultName(notification.getNewValue(), notification.getNotifier());
                    break;
                }
                case 5: {
                    Iterator iterator = ((Collection)notification.getNewValue()).iterator();
                    while (iterator.hasNext()) {
                        this.setDefaultName(iterator.next(), notification.getNotifier());
                    }
                    break;
                }
            }
        }
    }

    private void setDefaultName(Object object, Object object2) {
        String string = null;
        if (object instanceof Artifact) {
            string = "new_artifact";
        }
        if (string != null) {
            TngUtil.setDefaultName(((Artifact)object2).getContainedArtifacts(), (MethodElement)object, string);
        }
    }

    public void setDefaultName(Object object) {
        String string = null;
        if (object instanceof Artifact) {
            string = "new_artifact";
        }
        if (string != null) {
            TngUtil.setDefaultName(((Artifact)this.target).getContainedArtifacts(), (MethodElement)object, string);
        }
    }

    public int getInterestedFeatureID() {
        return 25;
    }

    public Class getInterestedFeatureOwnerClass() {
        return Artifact.class;
    }

    public String getText(Object object) {
        return TngUtil.getLabel(object, this.getString("_UI_Artifact_type"));
    }

    public Object getImage(Object object) {
        URI uRI;
        Image image;
        if (object instanceof DescribableElement && ((DescribableElement)object).getNodeicon() != null && (image = LibraryEditPlugin.INSTANCE.getSharedImage(uRI = TngUtil.getFullPathofNodeorShapeIconURI((EObject)((DescribableElement)object), ((DescribableElement)object).getNodeicon()))) != null) {
            return image;
        }
        return super.getImage(object);
    }

    protected Command createInitializeCopyCommand(EditingDomain editingDomain, EObject eObject, CopyCommand.Helper helper) {
        return new MethodElementInitializeCopyCommand(editingDomain, eObject, helper);
    }

    protected Command createCreateCopyCommand(EditingDomain editingDomain, EObject eObject, CopyCommand.Helper helper) {
        return new MethodElementCreateCopyCommand(editingDomain, eObject, helper);
    }

    protected Command createAddCommand(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature, Collection collection, int n) {
        return new MethodElementAddCommand((Command)((AddCommand)super.createAddCommand(editingDomain, eObject, eStructuralFeature, collection, n)));
    }

    public void setParent(Object object) {
    }

    public void setFilter(IFilter iFilter) {
        this.filter = iFilter;
    }

    public void setLabel(String string) {
    }

    public Collection getChildren(Object object) {
        Collection collection = super.getChildren(object);
        if (this.filter != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (this.filter.accept(e)) continue;
                iterator.remove();
            }
        }
        return collection;
    }
}

