/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.library.edit.ICachedChildrenItemProvider;
import org.eclipse.epf.library.edit.IConfigurable;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.IWrapperItemProviderFactory;
import org.eclipse.epf.library.edit.IWrapperItemProviderFactoryProvider;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.VariabilityInfo;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.ComposedBreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.IBreakdownElementWrapperItemProviderFactory;
import org.eclipse.epf.library.edit.process.IColumnAware;
import org.eclipse.epf.library.edit.process.IProcessItemProvider;
import org.eclipse.epf.library.edit.process.TeamProfileWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.ActivityAddCommand;
import org.eclipse.epf.library.edit.util.GraphicalData;
import org.eclipse.epf.library.edit.util.PredecessorList;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Iteration;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.edit.command.MethodElementCreateCopyCommand;
import org.eclipse.epf.uma.edit.command.MethodElementInitializeCopyCommand;
import org.eclipse.epf.uma.provider.ActivityItemProvider;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BSActivityItemProvider
extends ActivityItemProvider
implements IProcessItemProvider,
IBSItemProvider,
ITableItemLabelProvider,
IConfigurable,
ICachedChildrenItemProvider {
    private Object parent;
    private int id;
    protected Object topItem = null;
    private boolean rolledUp;
    private GraphicalData graphicalData;
    private PredecessorList predecessors;
    private Boolean expanded;
    protected Adapter baseListener;
    private IFilter childFilter = new IFilter(){

        public boolean accept(Object object) {
            return BSActivityItemProvider.this.acceptAsChild(object);
        }
    };
    private boolean refreshAllIDsRequired;
    private IFilter filter;
    protected List cachedChildren;
    protected List cachedRollupChildren;
    private IConfigurator configurator;
    private Disposable contributedWrappers;
    private VariabilityInfo variabilityInfo;
    private boolean enableVariabilityInfo = true;
    private Disposable rolledUpWrappers;

    public BSActivityItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public void dispose() {
        if (this.baseListener != null) {
            Activity activity;
            VariabilityElement variabilityElement;
            EObject eObject = (EObject)this.baseListener.getTarget();
            if (eObject != null) {
                eObject.eAdapters().remove((Object)this.baseListener);
            }
            if (this.getTarget() instanceof Activity && (variabilityElement = (activity = (Activity)this.getTarget()).getVariabilityBasedOnElement()) != null) {
                variabilityElement.eAdapters().remove((Object)this.baseListener);
            }
        }
        if (this.predecessors != null) {
            this.predecessors.dispose();
        }
        if (this.cachedChildren != null) {
            this.cachedChildren.clear();
            this.cachedChildren = null;
        }
        if (this.cachedRollupChildren != null) {
            this.cachedRollupChildren.clear();
            this.cachedRollupChildren = null;
        }
        if (this.contributedWrappers != null) {
            this.contributedWrappers.dispose();
            this.contributedWrappers = null;
        }
        if (this.rolledUpWrappers != null) {
            this.rolledUpWrappers.dispose();
            this.rolledUpWrappers = null;
        }
        super.dispose();
    }

    protected boolean acceptAsChild(Object object) {
        if (this.filter != null) {
            return this.filter.accept(object);
        }
        return true;
    }

    protected boolean acceptAsRolledUpChild(Object object) {
        object = TngUtil.unwrap(object);
        if (this.filter != null && !(object instanceof Activity) && !(object instanceof TeamProfile)) {
            return this.filter.accept(object);
        }
        return true;
    }

    protected abstract Object getObject(Descriptor var1);

    public Collection getNewChildDescriptors(Object object, EditingDomain editingDomain, Object object2) {
        if (this.isRolledUp()) {
            return Collections.EMPTY_LIST;
        }
        return super.getNewChildDescriptors(object, editingDomain, object2);
    }

    protected void collectNewChildDescriptors(Collection collection, Object object) {
    }

    @Override
    public Boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(Boolean bl) {
        this.expanded = bl;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Object getTopItem() {
        if (this.topItem == null) {
            IBSItemProvider iBSItemProvider;
            Object object;
            if (ProcessUtil.isTopProcess(this.target)) {
                return this.target;
            }
            Object object2 = this.getParent(this.target);
            if (object2 != null && (object = this.getRootAdapterFactory().adapt(object2, ITreeItemContentProvider.class)) instanceof IBSItemProvider && (iBSItemProvider = (IBSItemProvider)object) != null) {
                Object object3 = iBSItemProvider.getTopItem();
                if (object3 == null && object2 instanceof Process && ((Process)object2).getSuperActivities() == null) {
                    object3 = object2;
                    iBSItemProvider.setTopItem(object3);
                }
                return object3;
            }
        }
        return this.topItem;
    }

    @Override
    public void setId(int n) {
        this.id = n;
    }

    private static boolean isTopActivity(Object object) {
        EObject eObject = (EObject)object;
        EObject eObject2 = eObject.eContainer();
        if (eObject2 instanceof ProcessComponent) {
            ProcessComponent processComponent = (ProcessComponent)eObject2;
            return object == processComponent.getProcess();
        }
        return false;
    }

    protected static boolean hasChildDescriptor(Activity activity) {
        for (Object e : activity.getBreakdownElements()) {
            if (!(e instanceof Descriptor)) continue;
            return true;
        }
        return false;
    }

    public Collection getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            this.childrenFeatures = new ArrayList();
            this.childrenFeatures.add(UmaPackage.eINSTANCE.getActivity_BreakdownElements());
        }
        return this.childrenFeatures;
    }

    protected void setParentFor(Object object, Object object2) {
        ProcessUtil.setParent(object, object2, this.getRootAdapterFactory());
    }

    private Collection getImmediateChildren(Object object) {
        Collection collection = new ArrayList();
        for (Object object2 : super.getChildren(object)) {
            if (!this.acceptAsChild(object2)) continue;
            if (this.configurator != null) {
                object2 = this.configurator.resolve(object2);
            }
            if (object2 == null || collection.contains(object2)) continue;
            this.setParentFor(object2, object);
            collection.add(object2);
        }
        collection = this.addInherited(object, (List)collection);
        return collection;
    }

    private Collection getRolledUpChildren(Object object) {
        if (this.rolledUpWrappers != null) {
            this.rolledUpWrappers.dispose();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(object, false){
            private static final long serialVersionUID = -3159537629619737368L;

            protected Iterator getChildren(Object object) {
                if (object instanceof Activity) {
                    Iterator iterator;
                    BSActivityItemProvider bSActivityItemProvider = (BSActivityItemProvider)((ItemProviderAdapter)BSActivityItemProvider.this).adapterFactory.adapt(object, ITreeItemContentProvider.class);
                    boolean bl = bSActivityItemProvider.isRolledUp();
                    try {
                        bSActivityItemProvider.basicSetRolledUp(false);
                        iterator = bSActivityItemProvider.getChildren(object).iterator();
                    }
                    finally {
                        bSActivityItemProvider.basicSetRolledUp(bl);
                    }
                    return iterator;
                }
                if (object instanceof BreakdownElementWrapperItemProvider && !(object instanceof TeamProfileWrapperItemProvider)) {
                    return ((BreakdownElementWrapperItemProvider)object).getChildren(object).iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        while (abstractTreeIterator.hasNext()) {
            Object object2 = abstractTreeIterator.next();
            if (!this.acceptAsRolledUpChild(object2)) continue;
            Object object3 = TngUtil.unwrap(object2);
            if (object3 instanceof Descriptor) {
                ComposedBreakdownElementWrapperItemProvider composedBreakdownElementWrapperItemProvider;
                Object object4 = this.findDescriptor(arrayList2, object3);
                if (object4 == null) {
                    if (this.isWrappingRollupNeeded(object2)) {
                        object2 = this.createRollupWrapper(object2, object, this.adapterFactory);
                    }
                    arrayList.add(object2);
                    arrayList2.add(object2);
                    continue;
                }
                if (!this.isWrappingRollupNeeded(object2) || (composedBreakdownElementWrapperItemProvider = ProcessUtil.getComposedWrapper(object4)) == null) continue;
                composedBreakdownElementWrapperItemProvider.addElement(object2);
                continue;
            }
            arrayList.add(object2);
        }
        arrayList2.clear();
        arrayList2 = null;
        return arrayList;
    }

    protected boolean isWrappingRollupNeeded(Object object) {
        return false;
    }

    protected ComposedBreakdownElementWrapperItemProvider createComposedWrapper(Object object, Object object2, AdapterFactory adapterFactory) {
        return new ComposedBreakdownElementWrapperItemProvider(object, object2, adapterFactory);
    }

    protected Object createRollupWrapper(Object object, Object object2, AdapterFactory adapterFactory) {
        ComposedBreakdownElementWrapperItemProvider composedBreakdownElementWrapperItemProvider = this.createComposedWrapper(object, object2, adapterFactory);
        composedBreakdownElementWrapperItemProvider.readOnly = true;
        composedBreakdownElementWrapperItemProvider.isRollupChild = true;
        if (this.rolledUpWrappers == null) {
            this.rolledUpWrappers = new Disposable();
        }
        this.rolledUpWrappers.add((Object)composedBreakdownElementWrapperItemProvider);
        return composedBreakdownElementWrapperItemProvider;
    }

    private Collection doGetChildren(Object object) {
        if (this.isRolledUp()) {
            return this.getRolledUpChildren(object);
        }
        return this.getImmediateChildren(object);
    }

    public Collection getChildren(Object object) {
        Activity activity = (Activity)object;
        this.variabilityInfo = this.configurator != null ? (this.enableVariabilityInfo ? this.configurator.getVariabilityInfo((VariabilityElement)activity) : null) : null;
        if (this.variabilityInfo != null) {
            Collection collection;
            Object e = this.variabilityInfo.getInheritanceList().get(0);
            BSActivityItemProvider bSActivityItemProvider = (BSActivityItemProvider)this.adapterFactory.adapt(e, ITreeItemContentProvider.class);
            boolean bl = bSActivityItemProvider.isRolledUp();
            try {
                bSActivityItemProvider.basicSetRolledUp(this.isRolledUp());
                collection = bSActivityItemProvider.doGetChildren(e);
            }
            finally {
                bSActivityItemProvider.basicSetRolledUp(bl);
            }
            if (!this.variabilityInfo.getContributors().isEmpty()) {
                ArrayList arrayList = new ArrayList();
                for (Object object22 : this.variabilityInfo.getContributors()) {
                    Object object3 = this.adapterFactory.adapt(object22, ITreeItemContentProvider.class);
                    if (!(object3 instanceof BSActivityItemProvider)) continue;
                    bSActivityItemProvider = (BSActivityItemProvider)object3;
                    bl = bSActivityItemProvider.isRolledUp();
                    try {
                        bSActivityItemProvider.basicSetRolledUp(this.isRolledUp());
                        for (Object object22 : bSActivityItemProvider.getImmediateChildren(object22)) {
                            object22 = Providers.getConfigurationApplicator().resolve(object22, this.configurator.getMethodConfiguration());
                            if (object22 == null || TngUtil.contains(collection, object22)) continue;
                            arrayList.add(object22);
                        }
                    }
                    finally {
                        bSActivityItemProvider.basicSetRolledUp(bl);
                    }
                }
                if (!arrayList.isEmpty()) {
                    collection.addAll(this.wrapContributed(activity, arrayList));
                }
            }
            return collection;
        }
        return this.doGetChildren(object);
    }

    protected void updateCachedChildren(Collection collection) {
    }

    @Override
    public Collection getChildrenFromCache() {
        if (this.cachedChildren == null) {
            this.getChildren(this.target);
        }
        return this.cachedChildren;
    }

    @Override
    public Collection getRollupChildrenFromCache() {
        if (this.cachedRollupChildren == null) {
            boolean bl = this.rolledUp;
            try {
                this.rolledUp = true;
                this.getChildren(this.target);
            }
            finally {
                this.rolledUp = bl;
            }
        }
        return this.cachedRollupChildren;
    }

    private BreakdownElementWrapperItemProvider findWrapper(Object object, Object object2) {
        List list;
        Object object3 = this.adapterFactory.adapt(object2, ITreeItemContentProvider.class);
        BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider = null;
        if (object3 instanceof IBSItemProvider && (list = ((IBSItemProvider)object3).getListeners()) != null) {
            for (Object e : list) {
                if (!(e instanceof BreakdownElementWrapperItemProvider)) continue;
                breakdownElementWrapperItemProvider = (BreakdownElementWrapperItemProvider)e;
                if (breakdownElementWrapperItemProvider.getValue() == object2 && breakdownElementWrapperItemProvider.getParent(object2) == object) break;
                breakdownElementWrapperItemProvider = null;
            }
        }
        return breakdownElementWrapperItemProvider;
    }

    private List wrapInherited(Activity activity, Collection collection) {
        if (this.wrappers == null) {
            this.wrappers = new Disposable();
        }
        return this.wrap(activity, collection, true, false, this.wrappers);
    }

    private List wrapContributed(Activity activity, Collection collection) {
        if (this.contributedWrappers == null) {
            this.contributedWrappers = new Disposable();
        }
        return this.wrap(activity, collection, false, true, this.contributedWrappers);
    }

    private IWrapperItemProviderFactory getWrapperItemProviderFactory() {
        IWrapperItemProviderFactory iWrapperItemProviderFactory = null;
        if (this.adapterFactory instanceof IWrapperItemProviderFactoryProvider) {
            iWrapperItemProviderFactory = ((IWrapperItemProviderFactoryProvider)this.adapterFactory).getWrapperItemProviderFactory();
        }
        if (iWrapperItemProviderFactory == null) {
            iWrapperItemProviderFactory = IBreakdownElementWrapperItemProviderFactory.INSTANCE;
        }
        return iWrapperItemProviderFactory;
    }

    private List wrap(Activity activity, Collection collection, boolean bl, boolean bl2, Disposable disposable) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        IWrapperItemProviderFactory iWrapperItemProviderFactory = this.getWrapperItemProviderFactory();
        for (Object e : collection) {
            Object object = TngUtil.unwrap(e);
            if (!(object instanceof BreakdownElement)) continue;
            BreakdownElement breakdownElement = (BreakdownElement)object;
            if (TngUtil.isBase(activity.getBreakdownElements(), breakdownElement)) continue;
            Object object2 = BSActivityItemProvider.getWrapper(activity, breakdownElement, (Collection)disposable);
            if (object2 == null) {
                object2 = iWrapperItemProviderFactory.createWrapper(breakdownElement, activity, this.adapterFactory);
                if (object2 instanceof BreakdownElementWrapperItemProvider) {
                    BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider = (BreakdownElementWrapperItemProvider)object2;
                    if (bl) {
                        breakdownElementWrapperItemProvider.isInherited = true;
                    } else if (bl2) {
                        breakdownElementWrapperItemProvider.contributed = true;
                        if (e instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)e).isInherited()) {
                            breakdownElementWrapperItemProvider.isInherited = true;
                        }
                    }
                }
            } else {
                disposable.remove(object2);
            }
            arrayList.add(object2);
        }
        disposable.dispose();
        disposable.addAll(arrayList);
        return arrayList;
    }

    private static Object getWrapper(Activity activity, BreakdownElement breakdownElement, Collection collection) {
        for (IWrapperItemProvider iWrapperItemProvider : collection) {
            if (iWrapperItemProvider.getOwner() != activity || iWrapperItemProvider.getValue() != breakdownElement) continue;
            return iWrapperItemProvider;
        }
        return null;
    }

    protected Adapter createBaseListener() {
        if (this.baseListener == null) {
            this.baseListener = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    Activity activity = (Activity)BSActivityItemProvider.this.getTarget();
                    switch (notification.getFeatureID(Activity.class)) {
                        case 7: {
                            if (!ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)activity)) break;
                            BSActivityItemProvider.this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)activity, false, true));
                            break;
                        }
                        case 0: {
                            if (activity.getVariabilityBasedOnElement() == null) break;
                            BSActivityItemProvider.this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)activity, false, true));
                            break;
                        }
                        case 5: {
                            BSActivityItemProvider.this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)activity, true, false));
                            break;
                        }
                        case 24: {
                            BSActivityItemProvider.this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)activity, true, true));
                            BSActivityItemProvider.this.refreshAffectedViewers();
                            break;
                        }
                        case 27: {
                            List list;
                            if (BSActivityItemProvider.this.handleReplaceBreakdownElement(notification) || (list = BSActivityItemProvider.this.getAffectedChildren(notification)).isEmpty()) break;
                            boolean bl = BSActivityItemProvider.this.refreshChildrenData(notification, list);
                            BSActivityItemProvider.this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)activity, true, bl));
                            BSActivityItemProvider.this.refreshAffectedViewers();
                        }
                    }
                }
            };
        }
        return this.baseListener;
    }

    protected Activity listenToBaseActivity() {
        Adapter adapter;
        Activity activity = (Activity)this.target;
        if (!ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)activity)) {
            return null;
        }
        Activity activity2 = this.variabilityInfo != null ? (this.variabilityInfo.getInheritanceList().size() > 1 ? (Activity)this.variabilityInfo.getInheritanceList().get(1) : (Activity)this.configurator.resolve(activity.getVariabilityBasedOnElement())) : (Activity)activity.getVariabilityBasedOnElement();
        if (activity2 == null) {
            return null;
        }
        this.createBaseListener();
        EObject eObject = (EObject)this.baseListener.getTarget();
        if (eObject != null) {
            eObject.eAdapters().remove((Object)this.baseListener);
        }
        if (!activity2.eAdapters().contains((Object)this.baseListener)) {
            activity2.eAdapters().add((Object)this.baseListener);
        }
        if ((adapter = this.adapterFactory.adapt((Notifier)activity2, ITreeItemContentProvider.class)) instanceof BSActivityItemProvider) {
            BSActivityItemProvider bSActivityItemProvider = (BSActivityItemProvider)adapter;
            bSActivityItemProvider.listenToBaseActivity();
        } else {
            System.out.println();
        }
        return activity2;
    }

    protected Collection addInherited(Object object, List list) {
        if (object instanceof Activity) {
            Activity activity = (Activity)object;
            Activity activity2 = this.listenToBaseActivity();
            if (activity2 != null) {
                VariabilityType variabilityType = activity.getVariabilityType();
                if (variabilityType == VariabilityType.LOCAL_REPLACEMENT_LITERAL) {
                    return list;
                }
                if (variabilityType == VariabilityType.LOCAL_CONTRIBUTION_LITERAL || variabilityType == VariabilityType.EXTENDS_LITERAL) {
                    List list2;
                    BSActivityItemProvider bSActivityItemProvider = (BSActivityItemProvider)this.getRootAdapterFactory().adapt((Notifier)activity2, ITreeItemContentProvider.class);
                    boolean bl = bSActivityItemProvider.isRolledUp();
                    try {
                        if (bl) {
                            bSActivityItemProvider.basicSetRolledUp(false);
                        }
                        list2 = this.wrapInherited(activity, bSActivityItemProvider.getChildren(activity2));
                    }
                    finally {
                        if (bl) {
                            bSActivityItemProvider.basicSetRolledUp(true);
                        }
                    }
                    if (list2.isEmpty()) {
                        return list;
                    }
                    TngUtil.addAllTo(list2, list);
                    return list2;
                }
            }
        }
        return list;
    }

    protected boolean isNewDescriptor(List list, Object object) {
        return this.findDescriptor(list, object) == null;
    }

    protected Object findDescriptor(List list, Object object) {
        Object object2 = this.getObject((Descriptor)TngUtil.unwrap(object));
        if (object2 == null) {
            return null;
        }
        int n = list.size() - 1;
        while (n > -1) {
            Object e = list.get(n);
            if (object2 == this.getObject((Descriptor)TngUtil.unwrap(e))) {
                return e;
            }
            --n;
        }
        return null;
    }

    public Object getCreateChildImage(Object object, Object object2, Object object3, Collection collection) {
        return this.getImage(object3);
    }

    protected Command createRemoveCommand(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature, Collection collection) {
        return super.createRemoveCommand(editingDomain, eObject, eStructuralFeature, collection);
    }

    public IBSItemProvider getItemProvider(EObject eObject) {
        return (IBSItemProvider)TngUtil.getAdapter(eObject, IBSItemProvider.class);
    }

    @Override
    public void setParent(Object object) {
        this.parent = object;
    }

    public Object getParent(Object object) {
        if (this.parent == null && this.target instanceof Activity) {
            return ((Activity)this.target).getSuperActivities();
        }
        return this.parent;
    }

    protected List getAffectedChildren(Notification notification) {
        return ProcessUtil.getAffectedElements(notification, this.childFilter);
    }

    protected boolean refreshChildrenData(Notification notification, List list) {
        return false;
    }

    protected void doRefreshChildren(Notification notification, List list) {
        this.refreshChildrenData(notification, list);
        Process process = (Process)this.getTopItem();
        AdapterFactory adapterFactory = this.getRootAdapterFactory();
        ProcessUtil.refreshViewer(adapterFactory, process);
    }

    protected void refreshChildren(final Notification notification, final List list) {
        if (!list.isEmpty()) {
            Display display = null;
            try {
                display = Display.getCurrent();
            }
            catch (Exception exception) {}
            Runnable runnable = new Runnable(){

                public void run() {
                    BSActivityItemProvider.this.doRefreshChildren(notification, list);
                }
            };
            if (display != null) {
                display.asyncExec(runnable);
            } else {
                runnable.run();
            }
        }
    }

    protected void refreshAffectedViewers() {
        Display display = null;
        try {
            display = Display.getCurrent();
        }
        catch (Exception exception) {}
        if (display == null) {
            try {
                display = Display.getDefault();
            }
            catch (Exception exception) {}
        }
        Runnable runnable = new Runnable(){

            public void run() {
                BSActivityItemProvider.this.doRefreshAffectedViewers();
            }
        };
        if (display != null) {
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    protected void doRefreshAffectedViewers() {
    }

    protected boolean handlePredecessorListChange(Notification notification) {
        return TngUtil.handlePredecessorListChange((ItemProviderAdapter)this, notification);
    }

    protected boolean handleReplaceBreakdownElement(Notification notification) {
        if (notification.getEventType() == 1 && notification.getNewValue() != notification.getOldValue()) {
            WorkBreakdownElement workBreakdownElement;
            if (notification.getNewValue() instanceof WorkBreakdownElement && !AssociationHelper.getLinkToSuccessor((BreakdownElement)(workBreakdownElement = (WorkBreakdownElement)notification.getNewValue())).isEmpty()) {
                ProcessUtil.refreshPredeccessorLists(this.adapterFactory, (Process)this.getTopItem());
            }
            this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)this.getTarget(), true, false));
            this.refreshAffectedViewers();
            return true;
        }
        return false;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        if (this.handlePredecessorListChange(notification)) {
            return;
        }
        switch (notification.getFeatureID(Activity.class)) {
            case 27: {
                if (this.handleReplaceBreakdownElement(notification)) {
                    return;
                }
                List list = this.getAffectedChildren(notification);
                if (!list.isEmpty()) {
                    switch (notification.getEventType()) {
                        case 3: 
                        case 5: {
                            this.createOrMovePackageFor(list);
                        }
                    }
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                    this.refreshAffectedViewers();
                }
                return;
            }
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
            case 23: 
            case 24: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                this.refreshAffectedViewers();
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void createOrMovePackageFor(List<?> list) {
        ProcessPackage processPackage = (ProcessPackage)((EObject)this.target).eContainer();
        if (processPackage == null) {
            return;
        }
        for (Object obj : list) {
            if (obj instanceof Activity) {
                ProcessPackage processPackage2;
                Activity activity = (Activity)obj;
                if (activity.eContainer() == null) {
                    processPackage2 = UmaFactory.eINSTANCE.createProcessPackage();
                    processPackage2.setName(activity.getName());
                    processPackage.getChildPackages().add(processPackage2);
                    processPackage2.getProcessElements().add(obj);
                    continue;
                }
                processPackage2 = (ProcessPackage)activity.eContainer();
                if (processPackage2.eContainer() == processPackage) continue;
                processPackage.getChildPackages().add(processPackage2);
                continue;
            }
            processPackage.getProcessElements().add(obj);
        }
    }

    private static void getAllBreakdownElements(Set set, BreakdownElement breakdownElement) {
        boolean bl = set.add(breakdownElement);
        if (bl && breakdownElement instanceof Activity) {
            for (BreakdownElement breakdownElement2 : ((Activity)breakdownElement).getBreakdownElements()) {
                BSActivityItemProvider.getAllBreakdownElements(set, breakdownElement2);
            }
        }
    }

    private void refreshPredecessors(Notification notification, List list) {
        HashSet<WorkBreakdownElement> hashSet = new HashSet<WorkBreakdownElement>();
        HashSet hashSet2 = new HashSet();
        for (BreakdownElement object : list) {
            if (notification.getEventType() == 4 || notification.getEventType() == 6) {
                this.setParentFor(object, null);
            }
            BSActivityItemProvider.getAllBreakdownElements(hashSet2, object);
        }
        for (BreakdownElement breakdownElement : hashSet2) {
            for (WorkOrder workOrder : AssociationHelper.getLinkToSuccessor((BreakdownElement)breakdownElement)) {
                WorkBreakdownElement workBreakdownElement = AssociationHelper.getSuccessor((WorkOrder)workOrder);
                if (hashSet2.contains(workBreakdownElement)) continue;
                hashSet.add(workBreakdownElement);
            }
        }
        for (Object e : hashSet) {
            this.fireNotifyChanged((Notification)new ViewerNotification(notification, e, false, true));
        }
    }

    private void createPackageFor(Activity activity, EObject eObject) {
        ProcessPackage processPackage = (ProcessPackage)eObject.eContainer();
        ProcessPackage processPackage2 = UmaFactory.eINSTANCE.createProcessPackage();
        processPackage2.setName(activity.getName());
        processPackage.getChildPackages().add(processPackage2);
        ArrayList<Activity> arrayList = new ArrayList<Activity>();
        arrayList.add(activity);
        arrayList.addAll(activity.getBreakdownElements());
        processPackage2.getProcessElements().addAll(arrayList);
    }

    protected String getColumnName(int n) {
        Map map;
        AdapterFactory adapterFactory = this.getRootAdapterFactory();
        if (adapterFactory instanceof IColumnAware && (map = ((IColumnAware)adapterFactory).getColumnIndexToNameMap()) != null) {
            return (String)map.get(new Integer(n));
        }
        return null;
    }

    public Object getColumnImage(Object object, int n) {
        String string = this.getColumnName(n);
        return TngUtil.getColumnImage(object, string);
    }

    public String getColumnText(Object object, int n) {
        String string = this.getColumnName(n);
        return this.getAttribute(object, string);
    }

    public String getText(Object object) {
        return TngUtil.getLabel(object);
    }

    @Override
    public void setTopItem(Object object) {
        this.topItem = object;
    }

    @Override
    public boolean isRolledUp() {
        return this.rolledUp;
    }

    @Override
    public void setRolledUp(boolean bl) {
        this.rolledUp = bl;
        if (!this.rolledUp) {
            AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(this.target, false){
                private static final long serialVersionUID = -7840687264753640250L;

                protected Iterator getChildren(Object object) {
                    ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)((ItemProviderAdapter)BSActivityItemProvider.this).adapterFactory.adapt(object, ITreeItemContentProvider.class);
                    return iTreeItemContentProvider.getChildren(object).iterator();
                }
            };
            while (abstractTreeIterator.hasNext()) {
                Object e = abstractTreeIterator.next();
                Object object = this.adapterFactory.adapt(e, ITreeItemContentProvider.class);
                if (!(object instanceof IBSItemProvider)) continue;
                ((IBSItemProvider)object).setRolledUp(false);
            }
        }
    }

    public GraphicalData getGraphicalData() {
        return this.graphicalData;
    }

    public void setGraphicalData(GraphicalData graphicalData) {
        this.graphicalData = graphicalData;
    }

    @Override
    public String getAttribute(Object object, String string) {
        return ProcessUtil.getAttribute(object, string, this);
    }

    @Override
    public void setAttribute(Object object, String string, String string2) {
        Activity activity = (Activity)object;
        ProcessUtil.setAttribute((WorkBreakdownElement)activity, string, string2);
    }

    protected Command createCreateChildCommand(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n, Collection collection) {
        if (object instanceof Iteration) {
            ((Iteration)object).setIsRepeatable(Boolean.TRUE);
        }
        return super.createCreateChildCommand(editingDomain, eObject, eStructuralFeature, object, n, collection);
    }

    @Override
    public List getListeners() {
        if (this.changeNotifier == null) {
            return null;
        }
        return Collections.unmodifiableList((List)this.changeNotifier);
    }

    @Override
    public PredecessorList getPredecessors() {
        if (this.predecessors == null) {
            this.predecessors = new PredecessorList(TngUtil.getBestAdapterFactory(this.adapterFactory), this.target);
        }
        return this.predecessors;
    }

    @Override
    public boolean isFirstElement(Object object) {
        return ProcessUtil.isFirstElement(this.getRootAdapterFactory(), (ItemProviderAdapter)this, object);
    }

    @Override
    public boolean isLastElement(Object object) {
        return ProcessUtil.isLastElement(this.getRootAdapterFactory(), (ItemProviderAdapter)this, object);
    }

    @Override
    public void moveUp(Object object, IActionManager iActionManager) {
        Object object2 = this.getParent(object);
        if (object2 != null && object2 instanceof Activity) {
            TngUtil.moveUp((Activity)object2, object, this.getEClasses(), iActionManager);
        }
    }

    @Override
    public void moveDown(Object object, IActionManager iActionManager) {
        Object object2 = this.getParent(object);
        if (object2 != null && object2 instanceof Activity) {
            TngUtil.moveDown((Activity)object2, object, this.getEClasses(), iActionManager);
        }
    }

    protected Command createInitializeCopyCommand(EditingDomain editingDomain, EObject eObject, CopyCommand.Helper helper) {
        return new MethodElementInitializeCopyCommand(editingDomain, eObject, helper);
    }

    protected Command createCreateCopyCommand(EditingDomain editingDomain, EObject eObject, CopyCommand.Helper helper) {
        return new MethodElementCreateCopyCommand(editingDomain, eObject, helper);
    }

    protected Command createAddCommand(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature, Collection collection, int n) {
        return new ActivityAddCommand((Command)((AddCommand)super.createAddCommand(editingDomain, eObject, eStructuralFeature, collection, n)));
    }

    public Object getImage(Object object) {
        Object object2 = TngUtil.getImage(object);
        return object2 != null ? object2 : super.getImage(object);
    }

    public IFilter getChildFilter() {
        return this.childFilter;
    }

    public void setRefreshAllIDsRequired(boolean bl) {
        this.refreshAllIDsRequired = bl;
    }

    public boolean isRefreshAllIDsRequired() {
        return this.refreshAllIDsRequired;
    }

    public IFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(IFilter iFilter) {
        this.filter = iFilter;
        this.configurator = iFilter instanceof IConfigurator ? (IConfigurator)iFilter : null;
    }

    @Override
    public void setLabel(String string) {
    }

    @Override
    public IResourceAwareCommand createDropCommand(Object object, List list) {
        return null;
    }

    public void basicSetRolledUp(boolean bl) {
        this.rolledUp = bl;
    }

    public boolean isEnableVariabilityInfo() {
        return this.enableVariabilityInfo;
    }

    public void setEnableVariabilityInfo(boolean bl) {
        this.enableVariabilityInfo = bl;
    }

    protected Command createMoveCommand(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n) {
        return new MoveCommandEx(editingDomain, eObject, eStructuralFeature, object, n);
    }

    private class MoveCommandEx
    extends MoveCommand
    implements IResourceAwareCommand {
        private Set<Resource> modifiedResources;

        public MoveCommandEx(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n) {
            super(editingDomain, eObject, eStructuralFeature, object, n);
        }

        public void doExecute() {
            List list = (List)BSActivityItemProvider.this.getChildren(BSActivityItemProvider.this.getTarget());
            Object e = list.get(this.index);
            this.index = this.ownerList.indexOf(e);
            if (this.index != -1) {
                super.doExecute();
            }
        }

        public Collection getModifiedResources() {
            if (this.modifiedResources == null) {
                Resource resource = this.owner.eResource();
                this.modifiedResources = resource != null ? Collections.singleton(resource) : Collections.EMPTY_SET;
            }
            return this.modifiedResources;
        }
    }
}

