/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.command.AddMethodElementCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;

public class AssignWPToTaskDescriptor
extends AddMethodElementCommand {
    private List workProducts;
    private Activity activity;
    private TaskDescriptor taskDesc;
    private Collection modifiedResources;
    private int action;
    private HashMap map = new HashMap();
    List existingWPDescList = new ArrayList();
    List newWPDescList = new ArrayList();
    private MethodConfiguration config;

    public AssignWPToTaskDescriptor(TaskDescriptor taskDescriptor, List list, int n, MethodConfiguration methodConfiguration) {
        super(TngUtil.getOwningProcess((BreakdownElement)taskDescriptor));
        this.workProducts = list;
        this.taskDesc = taskDescriptor;
        this.action = n;
        this.config = methodConfiguration;
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)taskDescriptor, ITreeItemContentProvider.class);
        Object object = itemProviderAdapter.getParent((Object)taskDescriptor);
        if (object instanceof Activity) {
            this.activity = (Activity)object;
        }
        this.modifiedResources = new HashSet();
    }

    public void execute() {
        if (!super.addToDefaultConfiguration(this.workProducts)) {
            return;
        }
        for (WorkProduct workProduct : this.workProducts) {
            WorkProductDescriptor workProductDescriptor = null;
            boolean bl = false;
            workProductDescriptor = (WorkProductDescriptor)ProcessCommandUtil.getDescriptor((Object)workProduct, this.activity, this.config);
            if (workProductDescriptor == null && (workProductDescriptor = (WorkProductDescriptor)ProcessCommandUtil.getInheritedDescriptor(workProduct, this.activity, this.config)) == null) {
                workProductDescriptor = ProcessUtil.createWorkProductDescriptor(workProduct);
                bl = true;
            }
            if (bl) {
                this.newWPDescList.add(workProductDescriptor);
            } else {
                this.existingWPDescList.add(workProductDescriptor);
            }
            WorkProductDescriptor workProductDescriptor2 = UserInteractionHelper.getDeliverable(this.activity, workProduct);
            if (workProductDescriptor2 == null) continue;
            this.map.put(workProductDescriptor, workProductDescriptor2);
        }
        this.redo();
    }

    public void redo() {
        if (this.action == 3) {
            this.taskDesc.getExternalInput().addAll(this.existingWPDescList);
            this.taskDesc.getExternalInput().addAll(this.newWPDescList);
        } else if (this.action == 4) {
            this.taskDesc.getMandatoryInput().addAll(this.existingWPDescList);
            this.taskDesc.getMandatoryInput().addAll(this.newWPDescList);
        } else if (this.action == 5) {
            this.taskDesc.getOptionalInput().addAll(this.existingWPDescList);
            this.taskDesc.getOptionalInput().addAll(this.newWPDescList);
        } else if (this.action == 6) {
            this.taskDesc.getOutput().addAll(this.existingWPDescList);
            this.taskDesc.getOutput().addAll(this.newWPDescList);
        }
        this.activity.getBreakdownElements().addAll(this.newWPDescList);
        if (this.map != null) {
            Set set = this.map.keySet();
            for (Object k : set) {
                WorkProductDescriptor workProductDescriptor = (WorkProductDescriptor)this.map.get(k);
                workProductDescriptor.getDeliverableParts().add((WorkProductDescriptor)k);
            }
        }
    }

    public void undo() {
        super.undo();
        if (this.action == 3) {
            this.taskDesc.getExternalInput().removeAll(this.existingWPDescList);
            this.taskDesc.getExternalInput().removeAll(this.newWPDescList);
        } else if (this.action == 4) {
            this.taskDesc.getMandatoryInput().removeAll(this.existingWPDescList);
            this.taskDesc.getMandatoryInput().removeAll(this.newWPDescList);
        } else if (this.action == 5) {
            this.taskDesc.getOptionalInput().removeAll(this.existingWPDescList);
            this.taskDesc.getOptionalInput().removeAll(this.newWPDescList);
        } else if (this.action == 6) {
            this.taskDesc.getOutput().removeAll(this.existingWPDescList);
            this.taskDesc.getOutput().removeAll(this.newWPDescList);
        }
        this.activity.getBreakdownElements().removeAll(this.newWPDescList);
        if (this.map != null) {
            Set set = this.map.keySet();
            for (Object k : set) {
                WorkProductDescriptor workProductDescriptor = (WorkProductDescriptor)this.map.get(k);
                workProductDescriptor.getDeliverableParts().remove((WorkProductDescriptor)k);
            }
        }
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        if (this.workProducts != null && !this.workProducts.isEmpty()) {
            if (this.activity.eResource() != null) {
                this.modifiedResources.add(this.activity.eResource());
            }
            if (this.taskDesc.eResource() != null) {
                this.modifiedResources.add(this.taskDesc.eResource());
            }
        }
        return this.modifiedResources;
    }
}

