/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IUserInteractionHandler;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.edit.command.UserInput;
import org.eclipse.epf.library.edit.navigator.ProcessPackageItemProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Element;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessFamily;
import org.eclipse.epf.uma.ProcessPlanningTemplate;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.MessageException;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateProcessComponentCommand
extends CreateChildCommand {
    private static final Collection<EClass> ECLASSES = new HashSet<EClass>();
    private Process process;
    private IStatus status;

    static {
        ECLASSES.add(UmaPackage.eINSTANCE.getMethodPackage());
    }

    public CreateProcessComponentCommand(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n, Collection<?> collection, CreateChildCommand.Helper helper) {
        super(editingDomain, eObject, eStructuralFeature, object, n, collection, helper);
    }

    public boolean canUndo() {
        return false;
    }

    public void execute() {
        Object object;
        String string;
        Object object22;
        MethodLibrary methodLibrary = UmaUtil.getMethodLibrary((EObject)this.owner);
        Shell shell = MsgBox.getDefaultShell();
        this.status = UserInteractionHelper.checkModify(this.owner, shell);
        if (!this.status.isOK()) {
            return;
        }
        List list = methodLibrary.getPredefinedConfigurations();
        ArrayList arrayList = new ArrayList();
        for (Object object22 : list) {
            if (object22 instanceof ProcessFamily) continue;
            arrayList.add(object22);
        }
        if (arrayList.isEmpty()) {
            this.status = new Status(4, LibraryEditPlugin.getDefault().getId(), 0, LibraryEditResources.noConfigError_msg, null);
            return;
        }
        ProcessPackageItemProvider processPackageItemProvider = (ProcessPackageItemProvider)this.helper;
        object22 = new ArrayList();
        if (processPackageItemProvider.getProcessType() == UmaPackage.eINSTANCE.getProcessPlanningTemplate()) {
            ((ArrayList)object22).add(DeliveryProcess.class);
            ((ArrayList)object22).add(CapabilityPattern.class);
        }
        MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)((Element)this.owner));
        List list2 = TngUtil.getAvailableBaseProcesses(methodPlugin, (List)object22);
        Collections.sort(arrayList, new CompareByName());
        MethodConfiguration[] methodConfigurationArray = new MethodConfiguration[arrayList.size()];
        arrayList.toArray(methodConfigurationArray);
        Process[] processArray = new Process[list2.size()];
        list2.toArray(processArray);
        final ProcessComponent processComponent = (ProcessComponent)this.child;
        EClass eClass = processPackageItemProvider.getProcessType();
        processComponent.setProcess((Process)UmaFactory.eINSTANCE.create(eClass));
        IUserInteractionHandler iUserInteractionHandler = ExtensionManager.getDefaultUserInteractionHandler();
        ArrayList<UserInput> arrayList2 = new ArrayList<UserInput>();
        IValidator iValidator = IValidatorFactory.INSTANCE.createNameValidator((Object)this.owner, (NamedElement)processComponent);
        UserInput userInput = new UserInput(LibraryEditResources.nameLabel_text, 0, false, null, null, iValidator, null);
        arrayList2.add(userInput);
        UserInput userInput2 = new UserInput(LibraryEditResources.defaultConfigLabel_text, 1, false, arrayList, (ILabelProvider)new LabelProvider(){

            public String getText(Object object) {
                if (object instanceof MethodElement) {
                    return ((MethodElement)object).getName();
                }
                return object.toString();
            }
        }, new ConfigValidator(), null);
        arrayList2.add(userInput2);
        UserInput userInput3 = null;
        if (processComponent.getProcess() instanceof ProcessPlanningTemplate) {
            userInput3 = new UserInput(LibraryEditResources.basedOnProcessesLabel_text, 1, true, list2, (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()), null);
            arrayList2.add(userInput3);
        }
        boolean bl = false;
        String string2 = NLS.bind((String)LibraryEditResources.CreateProcessComponentCommand_Message, (Object)TngUtil.getTypeText(eClass.getName()).toLowerCase());
        if (iUserInteractionHandler.requestInput(LibraryEditResources.newProcessComponentDialog_title, string2, arrayList2)) {
            string = (String)userInput.getInput();
            processComponent.setName(string);
            this.process = processComponent.getProcess();
            this.process.setName(string);
            this.process.setPresentationName(string);
            this.process.setDefaultContext((MethodConfiguration)userInput2.getInput());
            if (userInput3 != null && !(object = (List)userInput3.getInput()).isEmpty()) {
                ((ProcessPlanningTemplate)processComponent).getBasedOnProcesses().addAll(object);
            }
            bl = true;
        }
        if (bl) {
            this.status = UserInteractionHelper.checkModify((EObject)processComponent.getProcess().getDefaultContext(), shell);
            if (!this.status.isOK()) {
                return;
            }
            super.execute();
            string = this.getCommand();
            if (string instanceof MethodElementAddCommand && (object = ((MethodElementAddCommand)((Object)string)).getStatus()) != null && !object.isOK()) {
                this.status = object;
                return;
            }
            object = this.process.getDefaultContext();
            List list3 = object.getMethodPackageSelection();
            Object object3 = processComponent;
            while (object3 != null) {
                if (object3 instanceof MethodPackage) {
                    list3.add(object3);
                }
                object3 = object3.eContainer();
            }
            object.getMethodPluginSelection().add(methodPlugin);
            this.process.getValidContext().add(object);
            this.process.setPresentation(ContentDescriptionFactory.createContentDescription((DescribableElement)this.process));
            object3 = new Runnable((MethodConfiguration)object){
                private final /* synthetic */ MethodConfiguration val$procCtx;
                {
                    this.val$procCtx = methodConfiguration;
                }

                public void run() {
                    Resource resource = CreateProcessComponentCommand.this.owner.eResource();
                    if (resource != null) {
                        ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = Services.getDefaultLibraryPersister().getFailSafePersister();
                        try {
                            failSafeMethodLibraryPersister.save(processComponent.eResource());
                            failSafeMethodLibraryPersister.save(resource);
                            failSafeMethodLibraryPersister.save(this.val$procCtx.eResource());
                            failSafeMethodLibraryPersister.commit();
                        }
                        catch (Exception exception) {
                            try {
                                failSafeMethodLibraryPersister.rollback();
                            }
                            catch (Exception exception2) {
                                LibraryEditPlugin.INSTANCE.log(exception2);
                                LibraryEditPlugin.INSTANCE.log(exception);
                            }
                            CreateProcessComponentCommand.this.status = Status.CANCEL_STATUS;
                            throw new MessageException(NLS.bind((String)LibraryEditResources.saveProcessError_reason, (Object)processComponent.getName()), exception);
                        }
                    }
                }
            };
            UserInteractionHelper.runWithProgress((Runnable)object3, MessageFormat.format(LibraryEditResources.creatingProcessComponentTask_name, processComponent.getName()));
        }
    }

    public void redo() {
        super.redo();
        ProcessComponent processComponent = (ProcessComponent)this.child;
        MethodConfiguration methodConfiguration = this.process.getDefaultContext();
        if (methodConfiguration instanceof MethodConfiguration) {
            methodConfiguration.getMethodPackageSelection().add(processComponent);
        }
    }

    public void undo() {
        MethodConfiguration methodConfiguration = this.process.getDefaultContext();
        if (methodConfiguration instanceof MethodConfiguration) {
            methodConfiguration.getMethodPackageSelection().remove(this.child);
        }
        super.undo();
    }

    public IStatus getStatus() {
        return this.status;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompareByName
    implements Comparator<MethodElement> {
        @Override
        public int compare(MethodElement methodElement, MethodElement methodElement2) {
            String string = methodElement.getName();
            String string2 = methodElement2.getName();
            return string.compareToIgnoreCase(string2);
        }
    }

    public class ConfigValidator
    implements IValidator {
        public IStatus isValid(Object object) {
            if (object == null) {
                String string = LibraryEditResources.noDefaultConfigError_msg;
                return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, string, null);
            }
            return Status.OK_STATUS;
        }

        public String isValid(String string) {
            return null;
        }
    }
}

