/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.process.command.PBSDropCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.UniqueNamePNameHandler;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;

public class OBSDropCommand
extends BSDropCommand {
    private ArrayList wpDescList;
    private ArrayList roleDescList;
    private Map roleDescTeamProfileMap;
    private Map wpDescToDeliverableParts;
    private HashMap wpdToDeliverableDescriptorMap;
    private HashMap wpdToTaskFeaturesMap;
    private IConfigurator configrator;
    private boolean newDuplicatesRemoved;

    public OBSDropCommand(Activity activity, List list) {
        super(activity, list);
        Iterator iterator = this.dropElements.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Role) continue;
            iterator.remove();
        }
    }

    public OBSDropCommand(Activity activity, List list, MethodConfiguration methodConfiguration, Set set, IConfigurator iConfigurator) {
        super(activity, list, methodConfiguration, set);
        this.configrator = iConfigurator;
    }

    protected boolean preExecute() {
        List list;
        Role role;
        if (!super.preExecute()) {
            return false;
        }
        this.roleDescList = new ArrayList();
        this.taskDescList = new ArrayList();
        this.wpDescList = new ArrayList();
        this.wpDescToDeliverableParts = new HashMap();
        this.wpdToDeliverableDescriptorMap = new HashMap();
        MethodConfiguration methodConfiguration = this.getMethodConfiguration();
        Set set = this.synchronize ? this.batchCommand.getDescriptorsToRefresh() : null;
        List list2 = this.activity.getBreakdownElements();
        UniqueNamePNameHandler uniqueNamePNameHandler = new UniqueNamePNameHandler(list2, list2);
        int n = this.dropElements.size();
        int n2 = 0;
        while (n2 < n) {
            role = (Role)this.dropElements.get(n2);
            if (TngUtil.isContributor((VariabilityElement)role)) {
                role = (Role)TngUtil.getBase((VariabilityElement)role);
            }
            list = null;
            if (this.synchronize) {
                list = (RoleDescriptor)ProcessCommandUtil.getDescriptor((Object)role, this.activity, methodConfiguration);
            }
            if (list == null) {
                list = ProcessUtil.createRoleDescriptor(role);
                uniqueNamePNameHandler.ensureUnique((DescribableElement)list);
                this.roleDescList.add(list);
            } else if (this.synchronize && list.getIsSynchronizedWithSource().booleanValue()) {
                this.batchCommand.getDescriptorsToRefresh().add(list);
            }
            ++n2;
        }
        if (!this.synchronize) {
            n2 = 0;
            while (n2 < n) {
                role = (Role)this.dropElements.get(n2);
                list = ProcessUtil.getWorkProductsForRole(role, methodConfiguration);
                if (list != null && !list.isEmpty()) {
                    Object object;
                    Object object22;
                    HashMap<WorkProduct, WorkProductDescriptor> hashMap = new HashMap<WorkProduct, WorkProductDescriptor>();
                    ArrayList arrayList = new ArrayList(this.activity.getBreakdownElements());
                    arrayList.addAll(this.wpDescList);
                    for (Object object22 : list) {
                        object = ProcessUtil.getWorkProductDescriptor(this.wpDescList, object22);
                        if (object == null) {
                            object = ProcessCommandUtil.getDescriptor(object22, this.activity, methodConfiguration);
                        }
                        if (object == null) continue;
                        hashMap.put((WorkProduct)object22, (WorkProductDescriptor)object);
                    }
                    ArrayList arrayList2 = new ArrayList(hashMap.keySet());
                    list.removeAll(arrayList2);
                    object22 = new ArrayList();
                    if (!list.isEmpty()) {
                        object = new ArrayList();
                        object.addAll(list);
                        Role role2 = role;
                        UserInteractionHelper.runInUIThread(new Runnable((List)object, role2, (List)object22){
                            private final /* synthetic */ List val$finalWps;
                            private final /* synthetic */ Role val$finalRole;
                            private final /* synthetic */ List val$finalSelectedWps;
                            {
                                this.val$finalWps = list;
                                this.val$finalRole = role;
                                this.val$finalSelectedWps = list2;
                            }

                            public void run() {
                                List list = UserInteractionHelper.selectWorkProducts(this.val$finalWps, this.val$finalRole);
                                if (list != null) {
                                    this.val$finalSelectedWps.addAll(list);
                                }
                            }
                        });
                    }
                    arrayList2.addAll(object22);
                    if (!arrayList2.isEmpty()) {
                        WorkProduct workProduct;
                        object = new HashSet();
                        int n3 = 0;
                        while (n3 < arrayList2.size()) {
                            List list3;
                            WorkProductDescriptor workProductDescriptor;
                            workProduct = (WorkProduct)arrayList2.get(n3);
                            if (TngUtil.isContributor((VariabilityElement)workProduct)) {
                                workProduct = (WorkProduct)TngUtil.getBase((VariabilityElement)workProduct);
                            }
                            if ((workProductDescriptor = (WorkProductDescriptor)hashMap.get(workProduct)) == null) {
                                workProductDescriptor = (WorkProductDescriptor)ProcessCommandUtil.getDescriptor((Object)workProduct, this.activity, methodConfiguration);
                            }
                            if (workProductDescriptor == null) {
                                workProductDescriptor = ProcessCommandUtil.createWorkProductDescriptor(workProduct, methodConfiguration, this.wpDescToDeliverableParts);
                                this.wpDescList.add(workProductDescriptor);
                                list3 = UserInteractionHelper.getDeliverable(this.activity, workProduct);
                                if (list3 != null) {
                                    this.wpdToDeliverableDescriptorMap.put(workProductDescriptor, list3);
                                }
                            } else {
                                if (set != null && workProductDescriptor.getIsSynchronizedWithSource().booleanValue()) {
                                    set.add(workProductDescriptor);
                                }
                                if (workProduct instanceof Deliverable && this.synchFeatures.contains(UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts())) {
                                    ProcessCommandUtil.createDeliverableParts(workProductDescriptor, (Deliverable)workProduct, methodConfiguration, this.wpDescToDeliverableParts, set);
                                }
                            }
                            if ((list3 = ProcessUtil.getTasksForWorkProduct(workProduct, methodConfiguration)) != null && list3.size() > 0) {
                                Object object3;
                                Task task;
                                list3.removeAll((Collection<?>)object);
                                Object object4 = list3.iterator();
                                while (object4.hasNext()) {
                                    task = (Task)object4.next();
                                    object3 = ProcessUtil.getTaskDescriptor(this.taskDescList, task);
                                    if (object3 == null) {
                                        object3 = ProcessCommandUtil.getDescriptor((Object)task, this.activity, methodConfiguration);
                                    }
                                    if (object3 == null) continue;
                                    object4.remove();
                                }
                                if (!list3.isEmpty()) {
                                    object4 = list3;
                                    task = workProduct;
                                    object3 = new ArrayList();
                                    ArrayList arrayList3 = new ArrayList();
                                    UserInteractionHelper.runInUIThread(new Runnable((List)object4, (WorkProduct)task, (List)object3){
                                        private final /* synthetic */ List val$finalTasks;
                                        private final /* synthetic */ WorkProduct val$finalWp;
                                        private final /* synthetic */ List val$finalSelected;
                                        {
                                            this.val$finalTasks = list;
                                            this.val$finalWp = workProduct;
                                            this.val$finalSelected = list2;
                                        }

                                        public void run() {
                                            List list = UserInteractionHelper.selectTasks(this.val$finalTasks, this.val$finalWp);
                                            this.val$finalSelected.addAll(list);
                                        }
                                    });
                                    arrayList3.addAll(object3);
                                    if (arrayList3 != null && !arrayList3.isEmpty()) {
                                        ((AbstractCollection)object).addAll(arrayList3);
                                    } else {
                                        ProcessCommandUtil.addResponsibleRoleDescriptors(workProductDescriptor, this.activity, this.roleDescList, null, methodConfiguration);
                                    }
                                }
                            } else {
                                ProcessCommandUtil.addResponsibleRoleDescriptors(workProductDescriptor, this.activity, this.roleDescList, null, methodConfiguration);
                            }
                            ++n3;
                        }
                        if (object != null && !((HashSet)object).isEmpty()) {
                            Iterator iterator = ((HashSet)object).iterator();
                            while (iterator.hasNext()) {
                                workProduct = (Task)iterator.next();
                                PBSDropCommand.addToDescriptorLists((Task)workProduct, this.activity, this.taskDescList, this.roleDescList, this.wpDescList, this.wpDescToDeliverableParts, set, this.batchCommand.getObjectToNewFeatureValuesMap(), methodConfiguration, this.synchronize, this.synchFeatures);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.wpDescList.size()) {
            role = (WorkProductDescriptor)this.wpDescList.get(n2);
            if (role != null) {
                uniqueNamePNameHandler.ensureUnique((DescribableElement)role);
            }
            ++n2;
        }
        return !this.roleDescList.isEmpty() || !this.taskDescList.isEmpty() || !this.wpDescList.isEmpty() || this.wpDescToDeliverableParts != null && !this.wpDescToDeliverableParts.isEmpty() || !this.wpdToDeliverableDescriptorMap.isEmpty() || set != null && !set.isEmpty() || this.batchCommand.canExecute();
    }

    protected void doExecute() {
        TeamProfile teamProfile;
        Object object2;
        this.removeNewDuplicates();
        this.activity.getBreakdownElements().addAll(this.roleDescList);
        if (this.roleDescTeamProfileMap == null) {
            this.roleDescTeamProfileMap = new HashMap();
            for (Object object2 : this.roleDescList) {
                teamProfile = UserInteractionHelper.getTeam(this.activity, object2.getRole());
                if (teamProfile == null) continue;
                this.roleDescTeamProfileMap.put(object2, teamProfile);
            }
        }
        Iterator iterator = this.roleDescTeamProfileMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            teamProfile = (TeamProfile)object2.getValue();
            teamProfile.getTeamRoles().add(object2.getKey());
        }
        if (!this.wpdToDeliverableDescriptorMap.isEmpty()) {
            iterator = this.wpdToDeliverableDescriptorMap.entrySet().iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                teamProfile = (WorkProductDescriptor)object2.getValue();
                teamProfile.getDeliverableParts().add(object2.getKey());
            }
        }
        this.activity.getBreakdownElements().addAll(this.wpDescList);
        this.activity.getBreakdownElements().addAll(this.taskDescList);
        if (!this.wpDescToDeliverableParts.isEmpty()) {
            iterator = this.wpDescToDeliverableParts.entrySet().iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                teamProfile = (WorkProductDescriptor)object2.getKey();
                teamProfile.getDeliverableParts().addAll((Collection)object2.getValue());
            }
        }
        if ((iterator = (ProcessPackage)this.activity.eContainer()) != null) {
            iterator.getProcessElements().addAll(this.taskDescList);
            iterator.getProcessElements().addAll(this.roleDescList);
            iterator.getProcessElements().addAll(this.wpDescList);
            object2 = this.wpDescToDeliverableParts.values().iterator();
            while (object2.hasNext()) {
                iterator.getProcessElements().addAll((Collection)object2.next());
            }
        }
    }

    private void removeNewDuplicates() {
        if (this.synchronize && !this.newDuplicatesRemoved) {
            Iterator iterator = this.wpDescList.iterator();
            while (iterator.hasNext()) {
                WorkProductDescriptor workProductDescriptor = (WorkProductDescriptor)iterator.next();
                Object object = ProcessCommandUtil.getDescriptor((Object)workProductDescriptor.getWorkProduct(), this.activity, this.getMethodConfiguration());
                if (object == null) continue;
                iterator.remove();
                if (this.wpDescToDeliverableParts != null) {
                    this.wpDescToDeliverableParts.remove(workProductDescriptor);
                }
                if (this.wpdToTaskFeaturesMap != null) {
                    this.wpdToTaskFeaturesMap.remove(workProductDescriptor);
                }
                if (this.wpdToDeliverableDescriptorMap == null) continue;
                this.wpdToDeliverableDescriptorMap.remove(workProductDescriptor);
            }
            this.newDuplicatesRemoved = true;
        }
    }

    protected void doUndo() {
        TeamProfile teamProfile;
        Object object;
        this.activity.getBreakdownElements().removeAll(this.roleDescList);
        ProcessPackage processPackage = this.roleDescTeamProfileMap.entrySet().iterator();
        while (processPackage.hasNext()) {
            object = processPackage.next();
            teamProfile = (TeamProfile)object.getValue();
            teamProfile.getTeamRoles().remove(object.getKey());
        }
        this.activity.getBreakdownElements().removeAll(this.wpDescList);
        this.activity.getBreakdownElements().removeAll(this.taskDescList);
        if (!this.wpDescToDeliverableParts.isEmpty()) {
            processPackage = this.wpDescToDeliverableParts.entrySet().iterator();
            while (processPackage.hasNext()) {
                object = (Map.Entry)processPackage.next();
                teamProfile = (WorkProductDescriptor)object.getKey();
                teamProfile.getDeliverableParts().removeAll((Collection)object.getValue());
            }
        }
        if (!this.wpdToDeliverableDescriptorMap.isEmpty()) {
            processPackage = this.wpdToDeliverableDescriptorMap.entrySet().iterator();
            while (processPackage.hasNext()) {
                object = (Map.Entry)processPackage.next();
                teamProfile = (WorkProductDescriptor)object.getValue();
                teamProfile.getDeliverableParts().remove(object.getKey());
            }
        }
        if ((processPackage = (ProcessPackage)this.activity.eContainer()) != null) {
            processPackage.getProcessElements().removeAll(this.taskDescList);
            processPackage.getProcessElements().removeAll(this.roleDescList);
            processPackage.getProcessElements().removeAll(this.wpDescList);
            object = this.wpDescToDeliverableParts.values().iterator();
            while (object.hasNext()) {
                processPackage.getProcessElements().removeAll((Collection)object.next());
            }
        }
    }

    public Collection getAffectedObjects() {
        if (this.roleDescList != null) {
            return this.roleDescList;
        }
        return super.getAffectedObjects();
    }

    public void dispose() {
        if (this.roleDescList != null) {
            this.roleDescList.clear();
        }
        if (this.roleDescTeamProfileMap != null) {
            this.roleDescTeamProfileMap.clear();
        }
        if (this.wpDescList != null) {
            this.wpDescList.clear();
        }
        if (this.wpDescToDeliverableParts != null) {
            this.wpDescToDeliverableParts.clear();
        }
        if (this.wpdToDeliverableDescriptorMap != null) {
            this.wpdToDeliverableDescriptorMap.clear();
        }
        if (this.wpdToTaskFeaturesMap != null) {
            this.wpdToTaskFeaturesMap.clear();
        }
        super.dispose();
    }
}

