/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IConfigurationApplicator;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.command.BatchCommand;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.AssociationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessCommandUtil {
    public static final EStructuralFeature[] DESCRIPTOR_REFRESHABLE_FEATURES = new EStructuralFeature[]{UmaPackage.eINSTANCE.getMethodElement_BriefDescription()};
    public static final EStructuralFeature[] TASK_DESCRIPTOR_REFRESHABLE_FEATURES = new EStructuralFeature[]{UmaPackage.eINSTANCE.getTaskDescriptor_AdditionallyPerformedBy(), UmaPackage.eINSTANCE.getTaskDescriptor_MandatoryInput(), UmaPackage.eINSTANCE.getTaskDescriptor_OptionalInput(), UmaPackage.eINSTANCE.getTaskDescriptor_Output(), UmaPackage.eINSTANCE.getTaskDescriptor_PerformedPrimarilyBy(), UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps()};
    public static final EStructuralFeature[] ROLE_DESCRIPTOR_REFRESHABLE_FEATURES = new EStructuralFeature[]{UmaPackage.eINSTANCE.getRoleDescriptor_ResponsibleFor()};

    public static Map createRefreshableFeatureMap(Descriptor descriptor, Set set) {
        HashMap<EReference, List> hashMap = new HashMap<EReference, List>();
        ProcessCommandUtil.addToFeatureMap((EObject)descriptor, DESCRIPTOR_REFRESHABLE_FEATURES, hashMap, set);
        if (descriptor instanceof TaskDescriptor) {
            ProcessCommandUtil.addToFeatureMap((EObject)descriptor, TASK_DESCRIPTOR_REFRESHABLE_FEATURES, hashMap, set);
        } else if (descriptor instanceof RoleDescriptor) {
            ProcessCommandUtil.addToFeatureMap((EObject)descriptor, ROLE_DESCRIPTOR_REFRESHABLE_FEATURES, hashMap, set);
        } else if (descriptor instanceof WorkProductDescriptor) {
            WorkProductDescriptor workProductDescriptor = (WorkProductDescriptor)descriptor;
            EReference eReference = UmaPackage.eINSTANCE.getWorkProductDescriptor_DeliverableParts();
            if (workProductDescriptor.getWorkProduct() instanceof Deliverable && !set.contains(eReference)) {
                hashMap.put(eReference, workProductDescriptor.getDeliverableParts());
            }
        }
        return hashMap;
    }

    private static void addToFeatureMap(EObject eObject, EStructuralFeature[] eStructuralFeatureArray, Map map, Set set) {
        int n = 0;
        while (n < eStructuralFeatureArray.length) {
            EStructuralFeature eStructuralFeature = eStructuralFeatureArray[n];
            if (!set.contains(eStructuralFeature)) {
                ArrayList arrayList = eObject.eGet(eStructuralFeature);
                if (eStructuralFeature.isMany()) {
                    arrayList = new ArrayList(arrayList);
                }
                map.put(eStructuralFeature, arrayList);
            }
            ++n;
        }
    }

    public static Map clearRefreshableFeatures(Descriptor descriptor, Set set) {
        Map map = ProcessCommandUtil.createRefreshableFeatureMap(descriptor, set);
        for (EStructuralFeature eStructuralFeature : map.keySet()) {
            if (eStructuralFeature instanceof EAttribute) {
                descriptor.eSet(eStructuralFeature, eStructuralFeature.getDefaultValue());
                continue;
            }
            if (eStructuralFeature.isMany()) {
                List list = (List)descriptor.eGet(eStructuralFeature);
                switch (list.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        list.remove(0);
                        break;
                    }
                    default: {
                        list.clear();
                        break;
                    }
                }
                continue;
            }
            descriptor.eSet(eStructuralFeature, eStructuralFeature.getDefaultValue());
        }
        return map;
    }

    public static boolean clearDescriptor(Descriptor descriptor, Map map, Set set) {
        if (map != null && !map.containsKey(descriptor)) {
            map.put(descriptor, ProcessCommandUtil.clearRefreshableFeatures(descriptor, set));
            return true;
        }
        return false;
    }

    private static boolean isValidDescriptorOf(Object object, MethodConfiguration methodConfiguration, Object object2, boolean bl) {
        if (object2 instanceof Descriptor) {
            Descriptor descriptor = (Descriptor)object2;
            if (bl && descriptor.getSuppressed().booleanValue()) {
                return false;
            }
            Object object3 = ProcessUtil.getAssociatedElement(descriptor);
            object3 = Providers.getConfigurationApplicator().resolve(object3, methodConfiguration);
            return object == object3;
        }
        return false;
    }

    private static boolean isValidDescriptorOrDescriptorWrapperOf(Object object, MethodConfiguration methodConfiguration, Suppression suppression, Object object2) {
        if (object2 instanceof BreakdownElementWrapperItemProvider) {
            if (suppression.isInSuppressedList((BreakdownElementWrapperItemProvider)object2)) {
                return false;
            }
            return ProcessCommandUtil.isValidDescriptorOf(object, methodConfiguration, TngUtil.unwrap(object2), false);
        }
        return ProcessCommandUtil.isValidDescriptorOf(object, methodConfiguration, object2, true);
    }

    public static Object getDescriptor(Object object, List list, MethodConfiguration methodConfiguration) {
        return ProcessCommandUtil.getDescriptor(object, list, methodConfiguration, true);
    }

    static Object getDescriptor(Object object, List list, MethodConfiguration methodConfiguration, boolean bl) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = list.get(n2);
            if (ProcessCommandUtil.isValidDescriptorOf(object, methodConfiguration, e, bl)) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    public static Descriptor getValidDescriptor(Object object, Activity activity, AdapterFactory adapterFactory) {
        Process process = TngUtil.getOwningProcess((BreakdownElement)activity);
        MethodConfiguration methodConfiguration = process.getDefaultContext();
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)activity, ITreeItemContentProvider.class);
        for (Object e : iTreeItemContentProvider.getChildren((Object)activity)) {
            if (!ProcessCommandUtil.isValidDescriptorOrDescriptorWrapperOf(object, methodConfiguration, Suppression.getSuppression(process), e)) continue;
            return (Descriptor)TngUtil.unwrap(e);
        }
        return null;
    }

    public static Object getDescriptor(Object object, Activity activity, MethodConfiguration methodConfiguration) {
        return ProcessCommandUtil.getDescriptor(object, activity.getBreakdownElements(), methodConfiguration);
    }

    public static void addResponsibleRoleDescriptors(WorkProductDescriptor workProductDescriptor, Activity activity, List<RoleDescriptor> list, Set set, MethodConfiguration methodConfiguration) {
        WorkProduct workProduct;
        if (workProductDescriptor != null && (workProduct = workProductDescriptor.getWorkProduct()) != null) {
            if (TngUtil.isContributor((VariabilityElement)workProduct)) {
                workProduct = (WorkProduct)TngUtil.getBase((VariabilityElement)workProduct);
            }
            List list2 = AssociationHelper.getResponsibleRoles((WorkProduct)workProduct);
            for (Role role : list2) {
                if (TngUtil.isContributor((VariabilityElement)role)) {
                    role = (Role)TngUtil.getBase((VariabilityElement)role);
                }
                boolean bl = false;
                RoleDescriptor roleDescriptor = (RoleDescriptor)ProcessCommandUtil.getDescriptor((Object)role, activity, methodConfiguration);
                if (roleDescriptor == null && (roleDescriptor = (RoleDescriptor)ProcessCommandUtil.getInheritedDescriptor(role, activity, methodConfiguration)) == null && (roleDescriptor = (RoleDescriptor)ProcessCommandUtil.getDescriptor((Object)role, list, methodConfiguration)) == null) {
                    roleDescriptor = ProcessUtil.createRoleDescriptor(role);
                    list.add(roleDescriptor);
                    bl = true;
                }
                if (bl || set == null || !roleDescriptor.getIsSynchronizedWithSource().booleanValue()) continue;
                set.add(roleDescriptor);
            }
        }
    }

    private static void collectWorkProductDescrtiptors(Task task, TaskDescriptor taskDescriptor, EReference eReference, EStructuralFeature eStructuralFeature, MethodConfiguration methodConfiguration, Activity activity, List list, Map map, Map map2, Set set, Map map3) {
        List list2 = (List)Providers.getConfigurationApplicator().getReference((VariabilityElement)task, eReference, methodConfiguration);
        ArrayList arrayList = new ArrayList();
        ProcessCommandUtil.createWorkProductDescriptors(list2, arrayList, activity, list, map, map2, set, methodConfiguration);
        if (!arrayList.isEmpty()) {
            BatchCommand.addFeatureValues(map3, (EObject)taskDescriptor, eStructuralFeature, arrayList);
        }
    }

    static void createWorkProductDescriptors(List list, List list2, Activity activity, List list3, Map map, Map map2, Set set, MethodConfiguration methodConfiguration) {
        if (list != null) {
            boolean bl = list2.isEmpty();
            int n = 0;
            while (n < list.size()) {
                WorkProduct workProduct = (WorkProduct)list.get(n);
                if (workProduct != null) {
                    WorkProductDescriptor workProductDescriptor;
                    if (TngUtil.isContributor((VariabilityElement)workProduct)) {
                        workProduct = (WorkProduct)TngUtil.getBase((VariabilityElement)workProduct);
                    }
                    if ((workProductDescriptor = (WorkProductDescriptor)ProcessCommandUtil.getDescriptor((Object)workProduct, activity, methodConfiguration)) == null && (workProductDescriptor = (WorkProductDescriptor)ProcessCommandUtil.getInheritedDescriptor(workProduct, activity, methodConfiguration)) == null) {
                        workProductDescriptor = (WorkProductDescriptor)ProcessCommandUtil.getDescriptor((Object)workProduct, list3, methodConfiguration);
                        if (workProductDescriptor == null) {
                            workProductDescriptor = ProcessCommandUtil.createWorkProductDescriptor(workProduct, methodConfiguration, map);
                            list3.add(workProductDescriptor);
                            WorkProductDescriptor workProductDescriptor2 = UserInteractionHelper.getDeliverable(activity, workProduct);
                            if (workProductDescriptor2 != null) {
                                map2.put(workProductDescriptor, workProductDescriptor2);
                            }
                        } else {
                            if (set != null) {
                                set.add(workProductDescriptor);
                            }
                            if (workProduct instanceof Deliverable && map != null) {
                                ProcessCommandUtil.createDeliverableParts(workProductDescriptor, (Deliverable)workProduct, methodConfiguration, map, set);
                            }
                        }
                    }
                    if (bl || !list2.contains(workProductDescriptor)) {
                        list2.add(workProductDescriptor);
                    }
                }
                ++n;
            }
        }
    }

    public static TaskDescriptor createTaskDescriptor(Task task, Activity activity, List list, List list2, Map map, Map map2, Set set, Map map3, MethodConfiguration methodConfiguration, boolean bl, Set set2) {
        Object object;
        if (TngUtil.isContributor((VariabilityElement)task)) {
            task = (Task)TngUtil.getBase((VariabilityElement)task);
        }
        TaskDescriptor taskDescriptor = null;
        if (bl) {
            taskDescriptor = (TaskDescriptor)ProcessCommandUtil.getDescriptor((Object)task, activity, methodConfiguration);
        }
        boolean bl2 = false;
        if (taskDescriptor == null) {
            taskDescriptor = ProcessCommandUtil.createTaskDescriptor(task);
            bl2 = true;
        } else if (set != null && taskDescriptor.getIsSynchronizedWithSource().booleanValue()) {
            set.add(taskDescriptor);
        }
        IConfigurationApplicator iConfigurationApplicator = Providers.getConfigurationApplicator();
        if (bl2) {
            object = (List)iConfigurationApplicator.getReference(task.getPresentation(), (DescribableElement)task, UmaPackage.eINSTANCE.getContentDescription_Sections(), methodConfiguration);
            taskDescriptor.getSelectedSteps().addAll(object);
        }
        if (list != null) {
            int n;
            RoleDescriptor roleDescriptor;
            Role role;
            object = UmaPackage.eINSTANCE.getTask_PerformedBy();
            Role role2 = role = set2.contains(object) ? (Role)iConfigurationApplicator.getReference((VariabilityElement)task, (EReference)object, methodConfiguration) : null;
            if (role != null) {
                roleDescriptor = (RoleDescriptor)ProcessCommandUtil.getDescriptor((Object)role, activity, methodConfiguration);
                n = 0;
                if (roleDescriptor == null && (roleDescriptor = (RoleDescriptor)ProcessCommandUtil.getInheritedDescriptor(role, activity, methodConfiguration)) == null && (roleDescriptor = (RoleDescriptor)ProcessCommandUtil.getDescriptor((Object)role, list, methodConfiguration)) == null) {
                    roleDescriptor = ProcessUtil.createRoleDescriptor(role);
                    n = 1;
                    list.add(roleDescriptor);
                }
                if (set != null && n == 0 && roleDescriptor.getIsSynchronizedWithSource().booleanValue()) {
                    set.add(roleDescriptor);
                }
                if (bl2 && n != 0) {
                    taskDescriptor.setPerformedPrimarilyBy(roleDescriptor);
                } else {
                    BatchCommand.addFeatureValue(map3, (EObject)taskDescriptor, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_PerformedPrimarilyBy(), roleDescriptor);
                }
            }
            List list3 = roleDescriptor = set2.contains(object = UmaPackage.eINSTANCE.getTask_AdditionallyPerformedBy()) ? (List)iConfigurationApplicator.getReference((VariabilityElement)task, (EReference)object, methodConfiguration) : null;
            if (roleDescriptor != null) {
                n = 0;
                while (n < roleDescriptor.size()) {
                    Role role3 = (Role)roleDescriptor.get(n);
                    RoleDescriptor roleDescriptor2 = (RoleDescriptor)ProcessCommandUtil.getDescriptor((Object)role3, activity, methodConfiguration);
                    boolean bl3 = false;
                    if (roleDescriptor2 == null && (roleDescriptor2 = (RoleDescriptor)ProcessCommandUtil.getInheritedDescriptor(role3, activity, methodConfiguration)) == null && (roleDescriptor2 = (RoleDescriptor)ProcessCommandUtil.getDescriptor((Object)role3, list, methodConfiguration)) == null) {
                        roleDescriptor2 = ProcessUtil.createRoleDescriptor(role3);
                        bl3 = true;
                        list.add(roleDescriptor2);
                    }
                    if (set != null && !bl3 && roleDescriptor2.getIsSynchronizedWithSource().booleanValue()) {
                        set.add(roleDescriptor2);
                    }
                    if (bl2 && bl3) {
                        taskDescriptor.getAdditionallyPerformedBy().add(roleDescriptor2);
                    } else {
                        BatchCommand.addFeatureValue(map3, (EObject)taskDescriptor, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_AdditionallyPerformedBy(), roleDescriptor2);
                    }
                    ++n;
                }
            }
        }
        if (list2 != null) {
            if (!bl2 && !set2.contains(UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts())) {
                map = null;
            }
            if (bl2 || set2.contains(UmaPackage.eINSTANCE.getTask_MandatoryInput())) {
                ProcessCommandUtil.collectWorkProductDescrtiptors(task, taskDescriptor, UmaPackage.eINSTANCE.getTask_MandatoryInput(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_MandatoryInput(), methodConfiguration, activity, list2, map, map2, set, map3);
            }
            if (bl2 || set2.contains(UmaPackage.eINSTANCE.getTask_OptionalInput())) {
                ProcessCommandUtil.collectWorkProductDescrtiptors(task, taskDescriptor, UmaPackage.eINSTANCE.getTask_OptionalInput(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_OptionalInput(), methodConfiguration, activity, list2, map, map2, set, map3);
            }
            if (bl2 || set2.contains(UmaPackage.eINSTANCE.getTask_Output())) {
                ProcessCommandUtil.collectWorkProductDescrtiptors(task, taskDescriptor, UmaPackage.eINSTANCE.getTask_Output(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_Output(), methodConfiguration, activity, list2, map, map2, set, map3);
            }
        }
        if (bl2) {
            return taskDescriptor;
        }
        return null;
    }

    private static TaskDescriptor createTaskDescriptor(Task task) {
        TaskDescriptor taskDescriptor = UmaFactory.eINSTANCE.createTaskDescriptor();
        taskDescriptor.setTask(task);
        taskDescriptor.setName(task.getName());
        taskDescriptor.setPresentationName(StrUtil.isBlank((String)task.getPresentationName()) ? task.getName() : task.getPresentationName());
        return taskDescriptor;
    }

    public static void createDeliverableParts(WorkProductDescriptor workProductDescriptor, Deliverable deliverable, MethodConfiguration methodConfiguration, Map map, Set set) {
        IConfigurationApplicator iConfigurationApplicator = Providers.getConfigurationApplicator();
        List list = (List)iConfigurationApplicator.getReference((VariabilityElement)deliverable, UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts(), methodConfiguration);
        ArrayList<WorkProductDescriptor> arrayList = new ArrayList<WorkProductDescriptor>();
        if (workProductDescriptor.getDeliverableParts().isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(ProcessCommandUtil.createWorkProductDescriptor((WorkProduct)iterator.next(), methodConfiguration, map));
            }
        } else {
            for (WorkProduct workProduct : list) {
                WorkProductDescriptor workProductDescriptor2 = (WorkProductDescriptor)ProcessCommandUtil.getDescriptor((Object)workProduct, workProductDescriptor.getDeliverableParts(), methodConfiguration);
                if (workProductDescriptor2 == null) {
                    workProductDescriptor2 = ProcessCommandUtil.createWorkProductDescriptor(workProduct, methodConfiguration, map);
                } else {
                    if (set != null) {
                        set.add(workProductDescriptor2);
                    }
                    if (workProduct instanceof Deliverable) {
                        ProcessCommandUtil.createDeliverableParts(workProductDescriptor2, (Deliverable)workProduct, methodConfiguration, map, set);
                    }
                }
                arrayList.add(workProductDescriptor2);
            }
        }
        if (!arrayList.isEmpty()) {
            map.put(workProductDescriptor, arrayList);
        }
    }

    public static WorkProductDescriptor createWorkProductDescriptor(WorkProduct workProduct, MethodConfiguration methodConfiguration, Map map) {
        WorkProductDescriptor workProductDescriptor = ProcessUtil.createWorkProductDescriptor(workProduct);
        if (workProduct instanceof Deliverable && map != null) {
            ProcessCommandUtil.createDeliverableParts(workProductDescriptor, (Deliverable)workProduct, methodConfiguration, map, null);
        }
        return workProductDescriptor;
    }

    public static Object getInheritedDescriptor(Object object, Activity activity, MethodConfiguration methodConfiguration) {
        VariabilityType variabilityType = activity.getVariabilityType();
        while (variabilityType == VariabilityType.EXTENDS_LITERAL || variabilityType == VariabilityType.LOCAL_CONTRIBUTION_LITERAL) {
            VariabilityElement variabilityElement = activity.getVariabilityBasedOnElement();
            if (!(variabilityElement instanceof Activity)) break;
            Activity activity2 = (Activity)variabilityElement;
            Object object2 = ProcessCommandUtil.getDescriptor(object, activity2.getBreakdownElements(), methodConfiguration, false);
            if (object2 != null) {
                return object2;
            }
            activity = activity2;
            variabilityType = activity.getVariabilityType();
        }
        return null;
    }

    public static Map getFeaturesMap(List list, WorkProduct workProduct, MethodConfiguration methodConfiguration) {
        HashMap<Task, ArrayList<EReference>> hashMap = new HashMap<Task, ArrayList<EReference>>();
        EReference[] eReferenceArray = new EReference[]{UmaPackage.eINSTANCE.getTask_MandatoryInput(), UmaPackage.eINSTANCE.getTask_OptionalInput(), UmaPackage.eINSTANCE.getTask_Output()};
        int n = list.size() - 1;
        while (n > -1) {
            Task task = (Task)list.get(n);
            int n2 = 0;
            while (n2 < eReferenceArray.length) {
                EReference eReference = eReferenceArray[n2];
                Object object = Providers.getConfigurationApplicator().getReference((VariabilityElement)task, eReference, methodConfiguration);
                if (eReference.isMany() && ((List)object).contains(workProduct) || object == workProduct) {
                    ArrayList<EReference> arrayList = (ArrayList<EReference>)hashMap.get(task);
                    if (arrayList == null) {
                        arrayList = new ArrayList<EReference>();
                        hashMap.put(task, arrayList);
                    }
                    arrayList.add(eReference);
                }
                ++n2;
            }
            --n;
        }
        return hashMap;
    }
}

