/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.edit.navigator.PluginUIPackagesItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessComponent;

public final class Comparators {
    public static final Comparator<Object> DEFAULT_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            Collator collator = Collator.getInstance();
            if (object instanceof MethodElement && object2 instanceof MethodElement) {
                return collator.compare(((MethodElement)object).getName(), ((MethodElement)object2).getName());
            }
            Object object3 = TngUtil.unwrap(object);
            Object object4 = TngUtil.unwrap(object2);
            if (object3 instanceof MethodElement && object4 instanceof MethodElement) {
                return collator.compare(((MethodElement)object3).getName(), ((MethodElement)object4).getName());
            }
            return 0;
        }
    };
    public static final Comparator<Object> REVERSE_DEFAULT_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            Collator collator = Collator.getInstance();
            if (object instanceof MethodElement && object2 instanceof MethodElement) {
                return Comparators.oppositeValue(collator.compare(((MethodElement)object).getName(), ((MethodElement)object2).getName()));
            }
            Object object3 = TngUtil.unwrap(object);
            Object object4 = TngUtil.unwrap(object2);
            if (object3 instanceof MethodElement && object4 instanceof MethodElement) {
                return Comparators.oppositeValue(collator.compare(((MethodElement)object3).getName(), ((MethodElement)object4).getName()));
            }
            return 0;
        }
    };
    public static final Comparator PRESENTATION_NAME_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if ((object = Comparators.getDescribableElement(object)) == null) {
                return 0;
            }
            if ((object2 = Comparators.getDescribableElement(object2)) == null) {
                return 0;
            }
            return Comparators.comparePresentationName((DescribableElement)object, (DescribableElement)object2);
        }
    };
    public static final Comparator REVERSE_PRESENTATION_NAME_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (!(object instanceof DescribableElement) && !((object = TngUtil.unwrap(object)) instanceof DescribableElement)) {
                return 0;
            }
            if (!(object2 instanceof DescribableElement) && !((object2 = TngUtil.unwrap(object2)) instanceof DescribableElement)) {
                return 0;
            }
            return Comparators.oppositeValue(Comparators.comparePresentationName((DescribableElement)object, (DescribableElement)object2));
        }
    };
    public static final Comparator METHOD_TYPE_COMPARATOR = new TypeComparator(){

        protected Comparator getDefaultComparator() {
            return PresentationContext.INSTANCE.getComparator();
        }

        protected int getOrderId(Object object) {
            if (object instanceof MethodElement) {
                int n = ((MethodElement)object).eClass().getClassifierID();
                if (n == 82) {
                    n = Integer.MAX_VALUE;
                }
                return n;
            }
            return -1;
        }
    };
    public static final Comparator METHOD_TYPE_PRES_NAME_COMPARATOR = new TypeComparator(){

        protected Comparator getDefaultComparator() {
            return PresentationContext.INSTANCE.getPresNameComparator();
        }

        protected int getOrderId(Object object) {
            if (object instanceof MethodElement) {
                int n = ((MethodElement)object).eClass().getClassifierID();
                if (n == 82) {
                    n = Integer.MAX_VALUE;
                }
                return n;
            }
            return -1;
        }
    };
    public static final Comparator PLUGINPACKAGE_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            object = TngUtil.unwrap(object);
            object2 = TngUtil.unwrap(object2);
            if (object instanceof PluginUIPackagesItemProvider && object2 instanceof MethodPlugin) {
                return -1;
            }
            if (object instanceof MethodPlugin && object2 instanceof PluginUIPackagesItemProvider) {
                return 1;
            }
            boolean bl = PresentationContext.INSTANCE.isShowPresentationNames();
            String string = null;
            String string2 = null;
            if (bl && object instanceof DescribableElement) {
                string = ((DescribableElement)object).getPresentationName();
            } else if (object instanceof MethodElement) {
                string = ((MethodElement)object).getName();
            } else if (object instanceof PluginUIPackagesItemProvider) {
                string = ((PluginUIPackagesItemProvider)object).getFullName();
            } else if (object instanceof String) {
                string = (String)object;
            }
            if (bl && object2 instanceof DescribableElement) {
                string2 = ((DescribableElement)object2).getPresentationName();
            } else if (object2 instanceof MethodElement) {
                string2 = ((MethodElement)object2).getName();
            } else if (object2 instanceof PluginUIPackagesItemProvider) {
                string2 = ((PluginUIPackagesItemProvider)object2).getFullName();
            } else if (object2 instanceof String) {
                string2 = (String)object2;
            }
            if (string == null || string2 == null) {
                return 0;
            }
            return string.compareToIgnoreCase(string2);
        }
    };

    private static int oppositeValue(int n) {
        if (n != 0) {
            n = 0 - n;
        }
        return n;
    }

    private static int comparePresentationName(DescribableElement describableElement, DescribableElement describableElement2) {
        String string;
        String string2;
        Collator collator = Collator.getInstance();
        String string3 = string2 = describableElement instanceof BreakdownElement ? ProcessUtil.getPresentationName((BreakdownElement)describableElement) : describableElement.getPresentationName();
        if (string2.length() < 1) {
            string2 = describableElement.getName();
        }
        String string4 = string = describableElement2 instanceof BreakdownElement ? ProcessUtil.getPresentationName((BreakdownElement)describableElement2) : describableElement2.getPresentationName();
        if (string.length() < 1) {
            string = describableElement2.getName();
        }
        return collator.compare(string2, string);
    }

    private static DescribableElement getDescribableElement(Object object) {
        Object object2 = TngUtil.unwrap(object);
        if (object2 instanceof ProcessComponent) {
            object2 = ((ProcessComponent)object2).getProcess();
        }
        if ((object2 = TngUtil.unwrap(object2)) instanceof DescribableElement) {
            return (DescribableElement)object2;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class TypeComparator
    implements Comparator {
        protected Comparator<Object> getDefaultComparator() {
            return DEFAULT_COMPARATOR;
        }

        protected abstract int getOrderId(Object var1);

        public int compare(Object object, Object object2) {
            if ((object = TngUtil.unwrap(object)) == (object2 = TngUtil.unwrap(object2))) {
                return 0;
            }
            int n = 0;
            n = this.getOrderId((EObject)object) - this.getOrderId((EObject)object2);
            if (n == 0) {
                return this.getDefaultComparator().compare(object, object2);
            }
            return n;
        }
    }
}

