/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.io.PrintStream;
import java.util.Collection;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.MethodElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DebugUtil {
    private static PrintStream output;
    private static String prompt;

    static {
        prompt = "LD> ";
    }

    public static void setOutput(PrintStream printStream) {
        output = printStream;
    }

    public static void setPrompt(String string) {
        prompt = string;
    }

    private static PrintStream out() {
        if (output != null) {
            return output;
        }
        return System.out;
    }

    public static void print(String string, String string2, Collection<? extends MethodElement> collection, int n) {
        if (string != null) {
            Object object = "";
            if (collection == null) {
                object = "null";
            } else if (collection.isEmpty()) {
                object = collection.toString();
            }
            DebugUtil.out().println(String.valueOf(prompt) + string + (String)object);
        }
        if (collection == null) {
            return;
        }
        for (MethodElement methodElement : collection) {
            DebugUtil.out().println(String.valueOf(prompt) + DebugUtil.toString(methodElement, n));
        }
        if (string2 != null) {
            DebugUtil.out().println(String.valueOf(prompt) + string2);
        }
        DebugUtil.out().println("");
    }

    public static String toString(MethodElement methodElement, int n) {
        if (n == 1) {
            return TngUtil.getLabelWithPath(methodElement);
        }
        if (n == 2) {
            return String.valueOf(methodElement.eClass().getName()) + ", " + methodElement.getGuid() + ", " + TngUtil.getLabelWithPath(methodElement);
        }
        return methodElement.toString();
    }
}

