/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.command.IUserInteractionHandler;
import org.eclipse.epf.library.edit.util.ExtensionManager;

public class Messenger
implements IUserInteractionHandler.IMessenger {
    public static final Messenger INSTANCE = new Messenger();
    private static final String NEW_LINE = System.getProperty("line.separator", "\n");
    private IUserInteractionHandler.IMessenger delegate;
    private Logger logger = LibraryEditPlugin.getDefault().getLogger();

    private Messenger() {
        IUserInteractionHandler iUserInteractionHandler = ExtensionManager.getDefaultUserInteractionHandler();
        if (iUserInteractionHandler != null) {
            this.delegate = iUserInteractionHandler.getMessenger();
        }
    }

    public void showError(String string, String string2) {
        if (this.delegate != null) {
            this.delegate.showError(string, string2);
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!StrUtil.isBlank((String)string2)) {
                stringBuffer.append(NEW_LINE).append(string2);
            }
            this.logger.logError(stringBuffer.toString());
        }
    }

    public void showError(String string, String string2, IStatus iStatus) {
        if (this.delegate != null) {
            this.delegate.showError(string, string2, iStatus);
        } else {
            LibraryEditPlugin.getDefault().getLog().log(iStatus);
        }
    }

    public void showError(String string, String string2, String string3, Exception exception) {
        if (this.delegate != null) {
            this.delegate.showError(string, string2, string3, exception);
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!StrUtil.isBlank((String)string2)) {
                stringBuffer.append(NEW_LINE).append(string2);
            }
            this.logger.logError(stringBuffer.toString(), (Throwable)exception);
        }
    }

    public void showWarning(String string, String string2) {
        if (this.delegate != null) {
            this.delegate.showWarning(string, string2);
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!StrUtil.isBlank((String)string2)) {
                stringBuffer.append(NEW_LINE).append(string2);
            }
            this.logger.logWarning(stringBuffer.toString());
        }
    }

    public void showWarning(String string, String string2, String string3) {
        if (this.delegate != null) {
            this.delegate.showWarning(string, string2, string3);
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!StrUtil.isBlank((String)string2)) {
                stringBuffer.append(NEW_LINE).append(string2);
            }
            if (!StrUtil.isBlank((String)string3)) {
                stringBuffer.append(NEW_LINE).append(string3);
            }
            this.logger.logWarning(stringBuffer.toString());
        }
    }

    public void showInfo(String string, String string2) {
        if (this.delegate != null) {
            this.delegate.showInfo(string, string2);
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!StrUtil.isBlank((String)string2)) {
                stringBuffer.append(NEW_LINE).append(string2);
            }
            this.logger.logInfo(stringBuffer.toString());
        }
    }

    public void showError(String string, String string2, String string3, String string4, Exception exception) {
        if (this.delegate != null) {
            this.delegate.showInfo(string, string2);
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!StrUtil.isBlank((String)string2)) {
                stringBuffer.append(NEW_LINE).append(string2);
            }
            if (!StrUtil.isBlank((String)string3)) {
                stringBuffer.append(NEW_LINE).append(string3);
            }
            if (!StrUtil.isBlank((String)string4)) {
                stringBuffer.append(NEW_LINE).append(string4);
            }
            this.logger.logError(stringBuffer.toString(), (Throwable)exception);
        }
    }
}

