/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation;

import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.INameProvider;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.osgi.util.NLS;

public final class NameChecker {
    private static final String ELEMENT_TEXT = LibraryEditResources.element_text;
    private static final INameProvider presentationNameProvider = new INameProvider(){

        public String getName(Object object) {
            if (object instanceof BreakdownElement) {
                return ProcessUtil.getPresentationName((BreakdownElement)object);
            }
            if (object instanceof DescribableElement) {
                return ((DescribableElement)object).getPresentationName();
            }
            return null;
        }
    };

    private static String checkName(AdapterFactory adapterFactory, Object object, Object object2, final Class clazz, INameProvider iNameProvider, String string, Suppression suppression, boolean bl) {
        IFilter iFilter = new IFilter(){

            public boolean accept(Object object) {
                return clazz.isInstance(object);
            }
        };
        return NameChecker.checkName(adapterFactory, object, object2, iFilter, iNameProvider, string, suppression, bl);
    }

    private static String checkName(AdapterFactory adapterFactory, Object object, Object object2, IFilter iFilter, EStructuralFeature eStructuralFeature, String string, Suppression suppression, boolean bl) {
        return NameChecker.checkName(adapterFactory, object, object2, iFilter, NameChecker.createNameProvider(eStructuralFeature), string, suppression, bl);
    }

    private static String checkName(AdapterFactory adapterFactory, Object object, Object object2, IFilter iFilter, INameProvider iNameProvider, String string, Suppression suppression, boolean bl) {
        Collection collection;
        if (bl && suppression != null && suppression.isSuppressed(object2)) {
            return null;
        }
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt(object, ITreeItemContentProvider.class);
        boolean bl2 = false;
        BSActivityItemProvider bSActivityItemProvider = null;
        if (iTreeItemContentProvider instanceof BSActivityItemProvider) {
            bSActivityItemProvider = (BSActivityItemProvider)iTreeItemContentProvider;
            bl2 = bSActivityItemProvider.isRolledUp();
        }
        try {
            if (bl2) {
                bSActivityItemProvider.setRolledUp(false);
            }
            collection = iTreeItemContentProvider.getChildren(object);
        }
        finally {
            if (bl2) {
                bSActivityItemProvider.basicSetRolledUp(bl2);
            }
        }
        if (object2 instanceof BreakdownElement) {
            return null;
        }
        for (Object e : collection) {
            String string2;
            Object object3 = TngUtil.unwrap(e);
            if (object3 == object2 || !iFilter.accept(object3) || !(string2 = iNameProvider.getName(object3)).equalsIgnoreCase(string)) continue;
            return NLS.bind((String)LibraryEditResources.duplicateElementNameError_msg, (Object)string2);
        }
        return null;
    }

    private static INameProvider createNameProvider(final EStructuralFeature eStructuralFeature) {
        if (eStructuralFeature == UmaPackage.eINSTANCE.getDescribableElement_PresentationName()) {
            return presentationNameProvider;
        }
        return new INameProvider(){

            public String getName(Object object) {
                if (object instanceof EObject) {
                    return (String)((EObject)object).eGet(eStructuralFeature);
                }
                return null;
            }
        };
    }

    public static String checkName(AdapterFactory adapterFactory, BreakdownElement breakdownElement, Class clazz, EStructuralFeature eStructuralFeature, String string, Suppression suppression) {
        return NameChecker.checkName(adapterFactory, null, breakdownElement, clazz, eStructuralFeature, string, suppression, false);
    }

    public static String checkName(AdapterFactory adapterFactory, Object object, final BreakdownElement breakdownElement, Class clazz, EStructuralFeature eStructuralFeature, String string, Suppression suppression, boolean bl) {
        Object object2;
        String string2 = NameChecker.checkEmpty(breakdownElement, string);
        if (string2 != null) {
            return string2;
        }
        if (clazz == null) {
            clazz = NameChecker.chooseType(breakdownElement);
        }
        if (object == null && (object = (object2 = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class)).getParent((Object)breakdownElement)) == null) {
            return null;
        }
        string2 = NameChecker.checkName(adapterFactory, object, (Object)breakdownElement, clazz, NameChecker.createNameProvider(eStructuralFeature), string, suppression, bl);
        if (string2 != null) {
            return string2;
        }
        object2 = null;
        if (breakdownElement instanceof TeamProfile) {
            object2 = new IFilter(){

                public boolean accept(Object object) {
                    return breakdownElement instanceof TeamProfile;
                }
            };
        }
        if (object2 != null) {
            return NameChecker.checkNameInScope(adapterFactory, object, breakdownElement, eStructuralFeature, string, (IFilter)object2, suppression, bl);
        }
        return null;
    }

    private static String checkEmpty(Object object, String string) {
        if (object instanceof Activity && ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)object)) {
            return null;
        }
        String string2 = object instanceof NamedElement ? TngUtil.getTypeText((EObject)((NamedElement)object)) : ELEMENT_TEXT;
        if (string == null || string.trim().length() == 0) {
            return NLS.bind((String)LibraryEditResources.emptyElementNameError_msg, (Object)StrUtil.toLower((String)string2));
        }
        return null;
    }

    private static Class chooseType(BreakdownElement breakdownElement) {
        if (breakdownElement instanceof Activity) {
            return Activity.class;
        }
        if (breakdownElement instanceof TaskDescriptor) {
            return TaskDescriptor.class;
        }
        if (breakdownElement instanceof RoleDescriptor) {
            return RoleDescriptor.class;
        }
        if (breakdownElement instanceof WorkProductDescriptor) {
            return WorkProductDescriptor.class;
        }
        return breakdownElement.getClass();
    }

    private static String checkNameInScope(AdapterFactory adapterFactory, Object object, BreakdownElement breakdownElement, EStructuralFeature eStructuralFeature, String string, IFilter iFilter, Suppression suppression, boolean bl) {
        Object object2;
        Object object3;
        Object object4 = object;
        while (object4 != null) {
            object3 = NameChecker.checkName(adapterFactory, object4, (Object)breakdownElement, iFilter, eStructuralFeature, string, suppression, bl);
            if (object3 != null) {
                return object3;
            }
            object2 = (ITreeItemContentProvider)adapterFactory.adapt(object4, ITreeItemContentProvider.class);
            object4 = object2.getParent(object4);
        }
        if (object != null) {
            object4 = new AdapterFactoryTreeIterator(adapterFactory, object, false);
            while (object4.hasNext()) {
                object3 = TngUtil.unwrap(object4.next());
                if (object3 == breakdownElement || !iFilter.accept(object3) || !string.equalsIgnoreCase((String)(object2 = (String)((EObject)object3).eGet(eStructuralFeature)))) continue;
                return NLS.bind((String)LibraryEditResources.duplicateElementNameError_msg, (Object)string);
            }
        }
        return null;
    }

    public static String checkName(AdapterFactory adapterFactory, BreakdownElement breakdownElement, EStructuralFeature eStructuralFeature, String string, Suppression suppression) {
        return NameChecker.checkName(adapterFactory, breakdownElement, eStructuralFeature, string, suppression, false);
    }

    public static String checkName(AdapterFactory adapterFactory, BreakdownElement breakdownElement, EStructuralFeature eStructuralFeature, String string, Suppression suppression, boolean bl) {
        return NameChecker.checkName(adapterFactory, null, breakdownElement, null, eStructuralFeature, string, suppression, bl);
    }

    public static boolean canHaveEmptyPresentationName(DescribableElement describableElement) {
        if (describableElement instanceof VariabilityElement) {
            VariabilityType variabilityType = ((VariabilityElement)describableElement).getVariabilityType();
            return variabilityType == VariabilityType.EXTENDS_LITERAL || variabilityType == VariabilityType.CONTRIBUTES_LITERAL || variabilityType == VariabilityType.LOCAL_CONTRIBUTION_LITERAL;
        }
        return false;
    }

    public static boolean checkFilePathLength(MethodElement methodElement, MethodElement methodElement2, String string, int n, String[] stringArray) {
        Resource resource = methodElement.eResource();
        URI uRI = resource.getURI();
        if (stringArray != null) {
            int cfr_ignored_0 = stringArray.length;
        }
        int n2 = uRI.toFileString().length();
        int n3 = 20;
        if (methodElement instanceof MethodLibrary) {
            n3 = 0;
        } else if (methodElement2 instanceof Role) {
            n3 = 5;
        } else if (methodElement2 instanceof CapabilityPattern) {
            n3 = 18;
        }
        int n4 = n2 + n3 + string.length();
        return n4 <= n;
    }
}

