/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.DiagramResources;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.diagram.model.impl.NodeContainerImpl;
import org.eclipse.epf.diagram.model.impl.NodeImpl;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.model.util.GraphicalDataManager;
import org.eclipse.epf.diagram.model.util.IDiagramChangeListener;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.SemanticModelBridge;
import org.eclipse.epf.uma.SimpleSemanticModelElement;

public class DiagramImpl
extends NodeContainerImpl
implements Diagram {
    private boolean newDiagram;
    protected IDiagramChangeListener diagramChangeListener;
    private Activity baseAct;
    private Object diagramAdapter = new AdapterImpl(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void notifyChanged(Notification notification) {
            if (!DiagramImpl.this.notificationEnabled) {
                return;
            }
            DiagramImpl.this.notificationEnabled = false;
            try {
                switch (notification.getFeatureID(Diagram.class)) {
                    case 7: {
                        switch (notification.getEventType()) {
                            case 3: {
                                DiagramImpl.this.nodeAdded(notification.getPosition(), (Node)notification.getNewValue());
                                return;
                            }
                            case 4: {
                                DiagramImpl.this.nodeRemoved((Node)notification.getOldValue());
                                return;
                            }
                            case 5: {
                                Collection collection = (Collection)notification.getNewValue();
                                Iterator iterator = collection.iterator();
                                while (true) {
                                    if (!iterator.hasNext()) {
                                        return;
                                    }
                                    Node node = (Node)iterator.next();
                                    DiagramImpl.this.nodeAdded(notification.getPosition(), node);
                                }
                            }
                            case 6: {
                                Collection collection = (Collection)notification.getOldValue();
                                Iterator iterator = collection.iterator();
                                while (iterator.hasNext()) {
                                    DiagramImpl.this.nodeRemoved((Node)iterator.next());
                                }
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            finally {
                DiagramImpl.this.notificationEnabled = true;
            }
        }
    };
    private Suppression suppression;
    protected BreakdownElementWrapperItemProvider wrapper;
    protected IFilter filter;
    private boolean graphicalDataRequired = true;

    protected DiagramImpl() {
    }

    protected EClass eStaticClass() {
        return ModelPackage.Literals.DIAGRAM;
    }

    protected Node addNode(Object object) {
        Node node = this.addNode((Collection)this.getNodes(), object);
        if (node == null) {
            return node;
        }
        this.populateLinks(node, true);
        return node;
    }

    protected Node addNode(Collection collection, Object object) {
        Node node;
        if (TngUtil.isInstanceOf((Collection)this.getBreakdownElementTypes(), (Object)object) && (node = this.toNode((MethodElement)object)) != null) {
            collection.add(node);
            return node;
        }
        return null;
    }

    protected Collection addNodes(Collection collection) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addNode(arrayList, iterator.next());
        }
        this.getNodes().addAll(arrayList);
        return arrayList;
    }

    protected boolean removeNode(Object object) {
        if (!TngUtil.isInstanceOf((Collection)this.getBreakdownElementTypes(), (Object)object)) {
            return false;
        }
        Node node = GraphicalDataHelper.findNode(this, object);
        if (node == null) {
            return false;
        }
        for (Link link : node.getOutgoingConnections()) {
            link.setTarget(null);
        }
        for (Link link : node.getIncomingConnections()) {
            link.setSource(null);
        }
        node.getOutgoingConnections().clear();
        node.getIncomingConnections().clear();
        this.getNodes().remove((Object)node);
        return true;
    }

    protected void removeNodes(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.removeNode(iterator.next());
        }
    }

    public org.eclipse.epf.uma.Diagram getUMADiagram() {
        return (org.eclipse.epf.uma.Diagram)this.getGraphNode();
    }

    protected Class getDiagramChangeListenerType() {
        return IDiagramChangeListener.class;
    }

    protected List getBreakdownElementTypes() {
        return Collections.singletonList(BreakdownElement.class);
    }

    protected int getType() {
        return -1;
    }

    protected void nodeAdded(int n, Node node) {
        this.addToUmaModel(n, node);
        node.addConsumer(this);
    }

    protected void nodeRemoved(Node node) {
        this.removeFromUmaModel(node);
        node.removeConsumer(this);
    }

    public boolean isNew() {
        return this.newDiagram;
    }

    public void setNew(boolean bl) {
        this.newDiagram = bl;
    }

    public void setObject(Object object) {
        if (object instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)object).isReadOnly()) {
            this.wrapper = (BreakdownElementWrapperItemProvider)object;
            this.setReadOnly(true);
        }
        this.object = object = TngUtil.unwrap((Object)object);
        Activity activity = (Activity)object;
        if (ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)activity)) {
            this.baseAct = (Activity)activity.getVariabilityBasedOnElement();
        }
        this.baseAct = null;
        if (object == null) {
            return;
        }
        if (this.isGraphicalDataRequired()) {
            this.graphNode = GraphicalDataManager.getInstance().getUMADiagram(activity, this.getType(), false);
            if (this.graphNode == null) {
                this.graphNode = GraphicalDataManager.getInstance().getUMADiagram(activity, this.getType(), true);
                this.setNew(true);
            }
        }
        if (!activity.eAdapters().contains((Object)this.diagramChangeListener)) {
            activity.eAdapters().add((Object)this.diagramChangeListener);
        }
        if (this.baseAct != null && !this.baseAct.eAdapters().contains((Object)this.diagramChangeListener)) {
            this.baseAct.eAdapters().add((Object)this.diagramChangeListener);
        }
        this.populateDiagram();
        if (!this.eAdapters().contains(this.diagramAdapter)) {
            this.eAdapters().add((Object)((Adapter)this.diagramAdapter));
        }
    }

    protected void populateDiagram() {
        this.populateNodes();
        this.populateLinks();
        for (NodeImpl nodeImpl : this.getNodes()) {
            nodeImpl.addConsumer(this);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void populateLinks(Node var1_1, boolean var2_2) {
        block7: {
            var3_3 = 0;
            var4_4 = null;
            try {
                if (var2_2) {
                    var3_3 = this.getNodes().size();
                    var4_4 = new boolean[var3_3];
                    var5_5 = 0;
                    while (var5_5 < var3_3) {
                        var6_7 = (Node)this.getNodes().get(var5_5);
                        var4_4[var5_5] = var6_7.eDeliver();
                        var6_7.eSetDeliver(false);
                        ++var5_5;
                    }
                }
                if ((var5_6 = var1_1.getGraphNode()) != null) {
                    GraphicalDataHelper.fillConnections(var1_1, var5_6);
                }
            }
            finally {
                if (!var2_2) break block7;
                var8_10 = 0;
                if (true) ** GOTO lbl27
            }
            {
            }
            do {
                ((EObject)this.getNodes().get(var8_10)).eSetDeliver(var4_4[var8_10]);
                ++var8_10;
lbl27:
                // 2 sources

            } while (var8_10 < var3_3);
        }
    }

    protected void populateNodes() {
        org.eclipse.epf.uma.Diagram diagram = this.getUMADiagram();
        if (diagram != null) {
            ArrayList<TypedNode> arrayList = new ArrayList<TypedNode>();
            for (Object e : diagram.getContained()) {
                int n = DiagramImpl.getType(e);
                if (n <= 0) continue;
                TypedNode typedNode = ModelFactory.eINSTANCE.createTypedNode();
                typedNode.setType(n);
                typedNode.setObject(e);
                arrayList.add(typedNode);
            }
            this.getNodes().addAll(arrayList);
        }
    }

    private static int getType(Object object) {
        GraphNode graphNode;
        SemanticModelBridge semanticModelBridge;
        if (object instanceof GraphNode && (semanticModelBridge = (graphNode = (GraphNode)object).getSemanticModel()) instanceof SimpleSemanticModelElement) {
            String string = ((SimpleSemanticModelElement)semanticModelBridge).getTypeInfo();
            if ("synchnonization bar".equals(string)) {
                return 1;
            }
            if ("decision node".equals(string)) {
                return 2;
            }
            if ("end node".equals(string)) {
                return 4;
            }
            if ("start node".equals(string)) {
                return 3;
            }
            if ("free text".equals(string)) {
                return 6;
            }
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    protected void populateLinks() {
        var1_1 = this.getNodes().size();
        var2_2 = new boolean[var1_1];
        try {
            var3_3 = 0;
            while (var3_3 < var1_1) {
                var4_5 = (Node)this.getNodes().get(var3_3);
                var2_2[var3_3] = var4_5.eDeliver();
                var4_5.eSetDeliver(false);
                ++var3_3;
            }
            for (Node var4_5 : this.getNodes()) {
                this.populateLinks(var4_5, false);
            }
        }
        finally {
            var6_8 = 0;
            ** while (var6_8 < var1_1)
        }
lbl-1000:
        // 1 sources

        {
            ((EObject)this.getNodes().get(var6_8)).eSetDeliver(var2_2[var6_8]);
            ++var6_8;
            continue;
        }
lbl21:
        // 1 sources

    }

    protected void removeFromUmaModel(Node node) {
        Activity activity = (Activity)this.getObject();
        if (node.getObject() instanceof BreakdownElement) {
            activity.getBreakdownElements().remove(node.getObject());
        }
        if (this.getUMADiagram() != null) {
            this.getUMADiagram().getContained().remove(node.getGraphNode());
        }
    }

    protected void addToUmaModel(int n, Node node) {
        if (node.getGraphNode() == null) {
            ((NodeImpl)node).basicSetObject(node.getObject());
        }
        if (this.getUMADiagram() != null) {
            this.getUMADiagram().getContained().add(node.getGraphNode());
        }
    }

    protected Node toNode(MethodElement methodElement) {
        Node node = this.newNode();
        if (node == null) {
            return null;
        }
        node.setUMADiagram(this.getUMADiagram());
        node.setDiagram(this);
        node.setObject(methodElement);
        return node;
    }

    protected Node newNode() {
        return null;
    }

    public Class getMethodElementAdapterType() {
        return this.getDiagramChangeListenerType();
    }

    protected void dispose() {
        if (this.diagramChangeListener != null) {
            Activity activity = (Activity)this.getObject();
            if (this.baseAct != null) {
                this.baseAct.eAdapters().remove((Object)this.diagramChangeListener);
            }
            if (activity != null) {
                activity.eAdapters().remove((Object)this.diagramChangeListener);
            }
        }
        super.dispose();
    }

    public void setDefaultName(NamedNode namedNode) {
        MethodElement methodElement = (MethodElement)namedNode.getObject();
        int n = methodElement.eClass().getClassifierID();
        Activity activity = (Activity)this.getObject();
        ArrayList<BreakdownElement> arrayList = new ArrayList<BreakdownElement>();
        for (BreakdownElement breakdownElement : activity.getBreakdownElements()) {
            if (breakdownElement.eClass().getClassifierID() != n) continue;
            arrayList.add(breakdownElement);
        }
        String string = MessageFormat.format(DiagramResources.defaultBaseName, TngUtil.getTypeText((String)methodElement.eClass().getName()));
        TngUtil.setDefaultName(arrayList, (MethodElement)methodElement, (String)string);
        namedNode.setName(methodElement.getName());
    }

    protected void extractChildren(ITreeItemContentProvider iTreeItemContentProvider, Object object, Collection collection, boolean bl) {
        Object object2;
        boolean bl2 = false;
        if (iTreeItemContentProvider instanceof BSActivityItemProvider) {
            object2 = (BSActivityItemProvider)iTreeItemContentProvider;
            bl2 = object2.isRolledUp();
            object2.basicSetRolledUp(false);
        } else if (iTreeItemContentProvider instanceof IBSItemProvider) {
            object2 = (IBSItemProvider)iTreeItemContentProvider;
            bl2 = object2.isRolledUp();
            object2.setRolledUp(false);
        }
        try {
            if (iTreeItemContentProvider != null) {
                if (bl) {
                    for (Object e : iTreeItemContentProvider.getChildren(object)) {
                        if (this.getSuppression().isSuppressed(e)) continue;
                        collection.add(e);
                    }
                } else {
                    collection.addAll(iTreeItemContentProvider.getChildren(object));
                }
            }
        }
        finally {
            if (iTreeItemContentProvider instanceof IBSItemProvider) {
                ((IBSItemProvider)iTreeItemContentProvider).setRolledUp(bl2);
            }
        }
    }

    public Suppression getSuppression() {
        return this.suppression;
    }

    public void setSuppression(Suppression suppression) {
        this.suppression = suppression;
    }

    public void setFilter(IFilter iFilter) {
        this.filter = iFilter;
    }

    public void moveNode(Object object, int n, Object object2) {
    }

    public boolean isGraphicalDataRequired() {
        return this.graphicalDataRequired;
    }

    public void setGraphicalDataRequired(boolean bl) {
        this.graphicalDataRequired = bl;
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public void setWrapper(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider) {
        this.wrapper = breakdownElementWrapperItemProvider;
    }

    public Collection getChildren() {
        return Collections.EMPTY_LIST;
    }

    protected class ActivityAdapter
    extends NodeImpl.TransactionalNodeLink
    implements IDiagramChangeListener {
        protected ActivityAdapter() {
            super(DiagramImpl.this);
        }

        public Diagram getDiagram() {
            return DiagramImpl.this;
        }

        protected void handleNotification(Notification notification) {
            block13: {
                block0 : switch (notification.getFeatureID(Activity.class)) {
                    case 27: {
                        switch (notification.getEventType()) {
                            case 3: {
                                Node node = DiagramImpl.this.addNode(notification.getNewValue());
                                if (node != null && notification.getNotifier() == DiagramImpl.this.baseAct) {
                                    node.setReadOnly(true);
                                    break block0;
                                }
                                break block13;
                            }
                            case 4: {
                                DiagramImpl.this.removeNode(notification.getOldValue());
                                break block0;
                            }
                            case 5: {
                                Collection collection = DiagramImpl.this.addNodes((Collection)notification.getNewValue());
                                if (notification.getNotifier() == DiagramImpl.this.baseAct) {
                                    for (NodeImpl nodeImpl : collection) {
                                        nodeImpl.setReadOnly(true);
                                    }
                                }
                                break block13;
                            }
                            case 6: {
                                DiagramImpl.this.removeNodes((Collection)notification.getOldValue());
                                break block0;
                            }
                            case 7: {
                                DiagramImpl.this.moveNode(notification.getNewValue(), notification.getPosition(), notification.getOldValue());
                            }
                        }
                    }
                }
            }
        }
    }
}

