/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.persistence;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.persistence.ILibraryResourceSetFactory;
import org.eclipse.epf.persistence.PersistencePlugin;
import org.eclipse.epf.services.Services;
import org.osgi.framework.Bundle;

public class PersistenceService {
    private static final boolean DEBUG = PersistencePlugin.getDefault().isDebugging();
    public static final PersistenceService INSTANCE = new PersistenceService();
    private static HashMap<String, FactoryDef> typeToFactoryDefMap;

    private PersistenceService() {
    }

    public ILibraryResourceSet createResourceSet(String string) {
        ILibraryResourceSetFactory iLibraryResourceSetFactory = PersistenceService.getFactory(string);
        if (iLibraryResourceSetFactory != null) {
            return iLibraryResourceSetFactory.createLibraryResourceSet();
        }
        throw new IllegalArgumentException("Unknown type: " + string);
    }

    public static final ILibraryResourceSetFactory getFactory(String string) {
        Object object;
        FactoryDef factoryDef;
        if (typeToFactoryDefMap == null) {
            typeToFactoryDefMap = new HashMap();
            factoryDef = Platform.getExtensionRegistry();
            object = factoryDef.getExtensionPoint("org.eclipse.epf.library.persistence", "resourceSetFactories");
            if (object != null) {
                IExtension[] iExtensionArray = object.getExtensions();
                int n = 0;
                while (n < iExtensionArray.length) {
                    IExtension iExtension = iExtensionArray[n];
                    String string2 = iExtension.getNamespaceIdentifier();
                    Bundle bundle = Platform.getBundle((String)string2);
                    IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                    int n2 = 0;
                    while (n2 < iConfigurationElementArray.length) {
                        IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                        try {
                            String string3 = iConfigurationElement.getAttribute("class");
                            String string4 = iConfigurationElement.getAttribute("type");
                            if (string3 != null && string3.trim().length() > 0 && string4 != null && string4.trim().length() > 0) {
                                int n3 = Services.parseVersion((String)iConfigurationElement.getAttribute("version"));
                                FactoryDef factoryDef2 = typeToFactoryDefMap.get(string4);
                                if (factoryDef2 == null || factoryDef2.version < n3) {
                                    typeToFactoryDefMap.put(string4, new FactoryDef(bundle, string4, string3, n3));
                                }
                            }
                        }
                        catch (Exception exception) {
                            CommonPlugin.INSTANCE.log((Object)exception);
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        if ((factoryDef = typeToFactoryDefMap.get(string)) != null) {
            block14: {
                if (factoryDef.instance == null) {
                    try {
                        object = (ILibraryResourceSetFactory)factoryDef.bundle.loadClass(factoryDef.className).newInstance();
                        if (string.equals(object.getPersistenceType())) {
                            factoryDef.instance = object;
                        } else {
                            PersistencePlugin.getDefault().getLogger().logError(String.valueOf(factoryDef.className) + " is registered with the wrong persistence type '" + string + "'. The correct type must be '" + object.getPersistenceType() + "'");
                        }
                    }
                    catch (Exception exception) {
                        PersistencePlugin.getDefault().getLogger().logError((Throwable)exception);
                        if (!DEBUG) break block14;
                        exception.printStackTrace();
                    }
                }
            }
            return factoryDef.instance;
        }
        return null;
    }

    private static class FactoryDef {
        Bundle bundle;
        String type;
        String className;
        int version;
        ILibraryResourceSetFactory instance;

        private FactoryDef(Bundle bundle, String string, String string2, int n) {
            this.bundle = bundle;
            this.type = string;
            this.className = string2;
            this.version = n;
        }
    }
}

