/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import java.io.File;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.osgi.util.NLS;

public class FailSafePersistenceHelper {
    private URI finalURI;
    private URI oldURI;
    private String currentTxID;
    private Resource resource;
    private URI tempURI;
    private String id;
    private String backupFile;
    private URIConverter converter;
    private boolean commitEmptyResource;

    public FailSafePersistenceHelper(Resource resource, String string) {
        this.resource = resource;
        this.id = string;
        this.converter = resource.getResourceSet() != null ? resource.getResourceSet().getURIConverter() : null;
    }

    public void setCommitEmptyResource(boolean bl) {
        this.commitEmptyResource = bl;
    }

    public URI setTempURI(String string) {
        if (this.finalURI == null) {
            this.finalURI = this.oldURI = this.resource.getURI();
            this.currentTxID = string;
            this.tempURI = this.createTempURI();
            this.resource.setURI(this.tempURI);
        }
        return this.tempURI;
    }

    private URI createTempURI() {
        return URI.createFileURI((String)new StringBuffer(MultiFileXMIResourceImpl.getTempDir()).append(File.separator).append(this.currentTxID).append("new").append(this.id).toString());
    }

    public String getBackupFilePath() {
        String string = new StringBuffer(MultiFileXMIResourceImpl.getTempDir()).append(File.separator).append(this.currentTxID).append("old").append(this.id).toString();
        return string;
    }

    private String toFileString(URI uRI) {
        return FileManager.toFileString(uRI, this.converter);
    }

    public void commit() {
        if (this.finalURI != null && (this.commitEmptyResource || !this.resource.getContents().isEmpty())) {
            Object object;
            boolean bl;
            File file = new File(this.toFileString(this.finalURI));
            boolean bl2 = bl = !this.oldURI.equals((Object)this.finalURI);
            if (!bl) {
                object = this.getBackupFilePath();
                File file2 = new File((String)object);
                if (file2.exists()) {
                    file2.delete();
                }
                if (file.exists()) {
                    if (FileUtil.moveFile((File)file, (File)file2)) {
                        this.backupFile = object;
                    } else {
                        String string = NLS.bind((String)PersistenceResources.renameError_msg, (Object)file, (Object)object);
                        throw new MultiFileIOException(string);
                    }
                }
            }
            object = new File(bl ? this.toFileString(this.oldURI) : this.toFileString(this.resource.getURI()));
            boolean bl3 = false;
            bl3 = bl ? MultiFileSaveUtil.move(this.resource, (File)object, file) : FileUtil.moveFile((File)object, (File)file);
            if (!bl3) {
                String string = NLS.bind((String)PersistenceResources.renameError_msg, (Object)object, (Object)file);
                throw new MultiFileIOException(string);
            }
            if (bl) {
                this.didMove();
            }
        }
    }

    protected void didMove() {
    }

    public void deleteBackup() {
        block3: {
            if (this.backupFile != null) {
                try {
                    new File(this.backupFile).delete();
                    this.backupFile = null;
                }
                catch (Throwable throwable) {
                    CommonPlugin.INSTANCE.log((Object)throwable);
                    if (!MultiFileSaveUtil.DEBUG) break block3;
                    throwable.printStackTrace();
                }
            }
        }
    }

    public boolean hasTempURI() {
        if (this.currentTxID != null) {
            return this.createTempURI().equals((Object)this.resource.getURI());
        }
        return false;
    }

    public URI getFinalURI() {
        if (this.finalURI != null) {
            return this.finalURI;
        }
        return this.resource.getURI();
    }

    public boolean restore() {
        File file = null;
        File file2 = null;
        boolean bl = false;
        if (this.backupFile != null) {
            file = new File(this.backupFile);
            file2 = new File(this.toFileString(this.getFinalURI()));
        } else {
            boolean bl2 = bl = this.oldURI != null && !this.oldURI.equals((Object)this.finalURI);
            if (bl) {
                File file3 = new File(this.toFileString(this.getFinalURI()));
                file2 = new File(this.toFileString(this.oldURI));
                boolean bl3 = bl = file3.exists() && !file2.exists();
                if (bl) {
                    file = file3;
                }
            }
        }
        if (file != null) {
            boolean bl4;
            if (file2.exists()) {
                FileUtil.moveFile((File)file2, (File)new File(this.toFileString(this.resource.getURI())));
            }
            if (!(bl4 = bl ? MultiFileSaveUtil.move(this.resource, file, file2) : FileUtil.moveFile((File)file, (File)file2))) {
                throw new MultiFileIOException(NLS.bind((String)PersistenceResources.restoreResourceError_msg, (Object)this));
            }
            return true;
        }
        return false;
    }

    public void txFinished(boolean bl) {
        if (bl) {
            this.resource.setURI(this.finalURI);
            this.resource.setModified(false);
        } else {
            this.restoreURI();
        }
        this.currentTxID = null;
        this.finalURI = null;
    }

    private void restoreURI() {
        if (this.oldURI != null) {
            this.resource.setURI(this.oldURI);
        }
    }
}

