/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.migration;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.epf.common.serviceability.VersionUtil;
import org.eclipse.epf.persistence.migration.IMigrator;
import org.eclipse.epf.persistence.migration.UpgradeCallerInfo;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.osgi.framework.Bundle;

public final class MappingUtil {
    private static final boolean localDebug = false;
    private static Map migrators;
    private static Set oldNsUris;
    private static Map<String, String> adjustedLibNsURIMap;

    static {
        oldNsUris = new HashSet();
        adjustedLibNsURIMap = new HashMap<String, String>();
    }

    public static final IMigrator getMigrator(String string) {
        Migrator migrator;
        if (migrators == null) {
            migrators = new HashMap();
            migrator = Platform.getExtensionRegistry();
            IExtensionPoint iExtensionPoint = migrator.getExtensionPoint("org.eclipse.epf.library.persistence", "migrators");
            if (iExtensionPoint != null) {
                IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                int n = 0;
                while (n < iExtensionArray.length) {
                    IExtension iExtension = iExtensionArray[n];
                    String string2 = iExtension.getNamespaceIdentifier();
                    Bundle bundle = Platform.getBundle((String)string2);
                    IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                    int n2 = 0;
                    while (n2 < iConfigurationElementArray.length) {
                        IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                        try {
                            String string3 = iConfigurationElement.getAttribute("class");
                            String string4 = iConfigurationElement.getAttribute("libNsURI");
                            if (string3 != null && string3.trim().length() > 0 && string4 != null && string4.trim().length() > 0) {
                                migrators.put(string4, new Migrator(bundle, string3, string4));
                            }
                        }
                        catch (Exception exception) {
                            CommonPlugin.INSTANCE.log((Object)exception);
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        if ((migrator = (Migrator)migrators.get(string)) != null) {
            if (migrator.instance == null) {
                try {
                    migrator.instance = (IMigrator)migrator.bundle.loadClass(migrator.className).newInstance();
                }
                catch (Exception exception) {
                    CommonPlugin.INSTANCE.log((Object)exception);
                }
            }
            return migrator.instance;
        }
        return null;
    }

    public static final synchronized boolean conversionRequired(String string, VersionUtil.VersionCheckInfo versionCheckInfo) {
        boolean bl;
        String string2 = PersistenceUtil.getUMANsURI();
        String string3 = PersistenceUtil.getUMANsURI(string);
        if (oldNsUris.contains(string3 = MappingUtil.getAdjustedLibNsURI(string3, versionCheckInfo))) {
            return true;
        }
        if (string2.equals(string3)) {
            return false;
        }
        boolean bl2 = bl = MappingUtil.getMigrator(string3) != null;
        if (bl) {
            oldNsUris.add(string3);
        }
        return bl;
    }

    private static String getAdjustedLibNsURI(String string, VersionUtil.VersionCheckInfo versionCheckInfo) {
        String string2 = MappingUtil.getAdjustedLibNsURI_(string, versionCheckInfo);
        if (string2 != string) {
            adjustedLibNsURIMap.put(string, string2);
        }
        return string2;
    }

    private static String getAdjustedLibNsURI_(String string, VersionUtil.VersionCheckInfo versionCheckInfo) {
        String string2 = PersistenceUtil.getUMANsURI();
        if (!string2.equals(string)) {
            return string;
        }
        if (!string.equals("http://www.eclipse.org/epf/uma/1.0.4/uma.ecore")) {
            return string;
        }
        if (versionCheckInfo.toolVersion.equals(versionCheckInfo.currentMinToolVersion)) {
            return string;
        }
        return "http://www.eclipse.org/epf/uma/1.0.3/uma.ecore";
    }

    public static void migrate(String string, IProgressMonitor iProgressMonitor, UpgradeCallerInfo upgradeCallerInfo) throws Exception {
        IMigrator iMigrator = MappingUtil.getMigratorByLibPath(string);
        if (iMigrator != null) {
            iMigrator.migrate(string, iProgressMonitor, upgradeCallerInfo);
        }
    }

    public static IMigrator getMigratorByLibPath(String string) {
        String string2 = PersistenceUtil.getUMANsURI(string);
        String string3 = adjustedLibNsURIMap.get(string2);
        if (string3 != null) {
            string2 = string3;
        }
        return MappingUtil.getMigrator(string2);
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        System.out.println("Start migrating method library at '" + string + "'...");
        try {
            MappingUtil.migrate(string, null, null);
            System.out.println();
            System.out.println("Migration successfull.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println();
            System.err.println("Migration failed.");
        }
    }

    private static class Migrator {
        Bundle bundle;
        String className;
        String libNsURI;
        IMigrator instance;

        public Migrator(Bundle bundle, String string, String string2) {
            this.bundle = bundle;
            this.className = string;
            this.libNsURI = string2;
        }
    }
}

