/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.services;

import java.io.File;
import java.io.FileFilter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.services.ConfigurationSpec;
import org.eclipse.epf.uma.MethodPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryDocument {
    public static final String TAG_methodPlugins = "methodPlugins";
    public static final String TAG_predefinedConfigurations = "predefinedConfigurations";
    public static final String TAG_resourceDescriptors = "resourceDescriptors";
    public static final String TAG_resourceSubManagers = "subManagers";
    public static final String TAG_methodElementProperty = "methodElementProperty";
    public static final String ATTR_href = "href";
    public static final String ATTR_id = "id";
    public static final String ATTR_uri = "uri";
    public static final String ATTR_guid = "guid";
    public static final String ATTR_value = "value";
    public static final String exportFile = "export.xmi";
    public static final String libraryFile = "library.xmi";
    protected File libFile;
    protected Document document;
    protected Element libTag = null;
    protected Element resTag = null;
    private HashMap guidToUriMap = null;
    private Map<String, String> guidToPlugNameMap;

    public LibraryDocument(File file) throws Exception {
        this.libFile = file;
        this.init();
    }

    private void init() throws Exception {
        this.document = XMLUtil.loadXml((File)this.libFile);
        Element element = this.document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("org.eclipse.epf.uma:MethodLibrary");
        if (nodeList != null && nodeList.getLength() > 0) {
            this.libTag = (Element)nodeList.item(0);
        }
        if ((nodeList = element.getElementsByTagName("org.eclipse.epf.uma.resourcemanager:ResourceManager")) != null && nodeList.getLength() > 0) {
            this.resTag = (Element)nodeList.item(0);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public File getFile() {
        return this.libFile;
    }

    public Element getLibTag() {
        return this.libTag;
    }

    public String getLibraryName() {
        return this.libTag.getAttribute("name");
    }

    public String getLibraryGuid() {
        return this.libTag.getAttribute(ATTR_guid);
    }

    public Element getResourceTag() {
        return this.resTag;
    }

    public void removePlugin(Element element) {
        this.libTag.removeChild(element);
    }

    public void removeConfiguration(Element element) {
        this.libTag.removeChild(element);
    }

    public void removeResourceDescriptor(Element element) {
        this.resTag.removeChild(element);
    }

    public NodeList getPlugins() {
        return this.libTag.getElementsByTagName(TAG_methodPlugins);
    }

    public NodeList getConfigurations() {
        return this.libTag.getElementsByTagName(TAG_predefinedConfigurations);
    }

    public NodeList getResourceDescriptors() {
        return this.resTag.getElementsByTagName(TAG_resourceDescriptors);
    }

    public NodeList getResourceSubManagers() {
        return this.resTag.getElementsByTagName(TAG_resourceSubManagers);
    }

    public void addPlugin(Element element) {
        this.libTag.appendChild(this.getValidNode(element));
    }

    public void addConfiguration(Element element) {
        this.libTag.appendChild(this.getValidNode(element));
    }

    public void addResource(Element element) {
        this.resTag.appendChild(this.getValidNode(element));
    }

    public Node getValidNode(Node node) {
        if (node.getOwnerDocument() == this.document) {
            return node;
        }
        return this.document.importNode(node, true);
    }

    public void removePlugins(List list) {
        NodeList nodeList = this.getPlugins();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            String string = LibraryDocument.getGuid(element);
            if (list.contains(string)) {
                this.libTag.removeChild(element);
                continue;
            }
            ++n;
        }
    }

    public void removeConfigurations(List list) {
        NodeList nodeList = this.getConfigurations();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            String string = LibraryDocument.getGuid(element);
            if (list.contains(string)) {
                this.libTag.removeChild(element);
                continue;
            }
            ++n;
        }
    }

    public void removeResourceEntries(List list) {
        String string;
        Element element;
        NodeList nodeList = this.getResourceDescriptors();
        int n = 0;
        while (n < nodeList.getLength()) {
            element = (Element)nodeList.item(n);
            string = element.getAttribute(ATTR_id);
            String string2 = element.getAttribute(ATTR_uri);
            if (list.contains(string)) {
                this.resTag.removeChild(element);
                File file = this.getFileFromUri(string2);
                file.exists();
                continue;
            }
            ++n;
        }
        nodeList = this.getResourceSubManagers();
        n = 0;
        while (n < nodeList.getLength()) {
            element = (Element)nodeList.item(n);
            string = LibraryDocument.getSubManagerBaseGuid(element.getAttribute(ATTR_href));
            if (list.contains(string)) {
                this.resTag.removeChild(element);
                continue;
            }
            ++n;
        }
    }

    public String getResourceUri(String string) {
        String string2 = this.getUriFromGuidToUriMap(string);
        if (string2 == null) {
            string2 = this.getResourceUri_(string);
        }
        return string2;
    }

    private String getResourceUri_(String string) {
        NodeList nodeList = this.getResourceDescriptors();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            String string2 = element.getAttribute(ATTR_id);
            String string3 = element.getAttribute(ATTR_uri);
            if (string.equals(string2)) {
                return this.decodeUri(string3);
            }
            ++n;
        }
        return null;
    }

    public String decodeUri(String string) {
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string;
    }

    public File getFileFromUri(String string) {
        int n = (string = this.decodeUri(string)).indexOf("#");
        if (n > 0) {
            string = string.substring(0, n);
        }
        return new File(this.libFile.getParentFile(), string);
    }

    public void save() throws Exception {
        this.saveAs(this.libFile.getAbsolutePath());
    }

    public void saveAs(String string) throws Exception {
        XMLUtil.saveDocument((Document)this.document, (String)string);
    }

    public boolean isConfigSpecsOnly() {
        NodeList nodeList = this.getPlugins();
        if (nodeList == null || nodeList.getLength() == 0) {
            return true;
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            String string = element.getAttribute(ATTR_href);
            String string2 = LibraryDocument.getGuidFromHref(string);
            String string3 = this.getResourceUri(string2);
            File file = this.getFileFromUri(string3);
            if (file.exists()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String getSubManagerBaseGuid(String string) {
        Pattern pattern = Pattern.compile("uma://(.*?)#(.*?)", 34);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return string;
    }

    public static String getChildValue(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        if (nodeList == null || nodeList.getLength() == 0) {
            return "";
        }
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node instanceof Element && ((Element)node).getTagName().equals(string)) {
                return LibraryDocument.getNodeText((Element)node);
            }
            ++n2;
        }
        return "";
    }

    public static String getNodeText(Element element) {
        NodeList nodeList = element.getChildNodes();
        if (nodeList == null || nodeList.getLength() == 0) {
            return "";
        }
        int n = nodeList.getLength();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 3) {
                stringBuffer.append(node.getNodeValue());
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String getGuidFromHref(String string) {
        int n = string.indexOf("#");
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String getGuid(Element element) {
        String string = element.getAttribute("xmi:id");
        if (string == null || string.length() == 0) {
            String string2 = element.getAttribute(ATTR_href);
            string = LibraryDocument.getGuidFromHref(string2);
        }
        return string;
    }

    protected Element getConfigNode(Element element) {
        try {
            String string = element.getAttribute(ATTR_href);
            if (string == null || string.length() == 0) {
                return element;
            }
            String string2 = LibraryDocument.getGuidFromHref(string);
            String string3 = this.getResourceUri(string2);
            if (string3 == null) {
                return element;
            }
            File file = this.getFileFromUri(string3);
            Document document = XMLUtil.loadXml((File)file);
            Element element2 = document.getDocumentElement();
            Element element3 = null;
            if (element2.getTagName().equals("org.eclipse.epf.uma:MethodConfiguration")) {
                element3 = element2;
            } else {
                NodeList nodeList = element2.getElementsByTagName("org.eclipse.epf.uma:MethodConfiguration");
                if (nodeList.getLength() > 0) {
                    element3 = (Element)nodeList.item(0);
                }
            }
            return element3;
        }
        catch (Exception exception) {
            ExportPlugin.getDefault().getLogger().logError((Throwable)exception);
            return element;
        }
    }

    public ConfigurationSpec getConfigurationSpec(Element element) {
        String string;
        Element element2;
        int n;
        ConfigurationSpec configurationSpec = new ConfigurationSpec();
        Element element3 = this.getConfigNode(element);
        configurationSpec.guid = element3.getAttribute("xmi:id");
        configurationSpec.name = element3.getAttribute("name");
        configurationSpec.brief_desc = element3.getAttribute("briefDescription");
        NodeList nodeList = element3.getElementsByTagName("methodPluginSelection");
        if (nodeList != null) {
            n = 0;
            while (n < nodeList.getLength()) {
                element2 = (Element)nodeList.item(n);
                string = LibraryDocument.getGuidFromHref(element2.getAttribute(ATTR_href));
                configurationSpec.pluginIds.add(string);
                ++n;
            }
        }
        if ((nodeList = element3.getElementsByTagName("methodPackageSelection")) != null) {
            n = 0;
            while (n < nodeList.getLength()) {
                element2 = (Element)nodeList.item(n);
                string = LibraryDocument.getGuidFromHref(element2.getAttribute(ATTR_href));
                configurationSpec.packageIds.add(string);
                ++n;
            }
        }
        if ((nodeList = element3.getElementsByTagName("processViews")) != null) {
            n = 0;
            while (n < nodeList.getLength()) {
                element2 = (Element)nodeList.item(n);
                string = LibraryDocument.getGuidFromHref(element2.getAttribute(ATTR_href));
                configurationSpec.viewIds.add(string);
                ++n;
            }
        }
        return configurationSpec;
    }

    public void addToGuidToUriMap(String string, String string2) {
        if (this.guidToUriMap == null) {
            this.guidToUriMap = new HashMap();
        }
        this.guidToUriMap.put(string, string2);
    }

    public String getUriFromGuidToUriMap(String string) {
        return this.guidToUriMap == null ? null : (String)this.guidToUriMap.get(string);
    }

    public static void visitConfigFiles(File file, ConfigDocVisitor configDocVisitor) {
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return !file.getName().equalsIgnoreCase("cvs") && file.isDirectory() || file.getName().endsWith(".xmi");
            }
        };
        File[] fileArray = file.listFiles(fileFilter);
        if (fileArray == null) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            try {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = documentBuilder.parse(file2);
                Element element = document.getDocumentElement();
                configDocVisitor.visit(file2, element);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n;
        }
    }

    public Map buildPluginGuidToResMgrGuidMap(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        NodeList nodeList = this.getResourceSubManagers();
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        while (n < list.size()) {
            String string = (String)list.get(n);
            hashMap.put(string, null);
            ++n;
        }
        n = 1;
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n2);
            String string = element.getAttribute(ATTR_href);
            String string2 = LibraryDocument.getSubManagerBaseGuid(string);
            if (hashMap.containsKey(string2)) {
                hashMap.put(string2, LibraryDocument.getGuidFromHref(string));
                n = 0;
            }
            ++n2;
        }
        return n != 0 ? null : hashMap;
    }

    public void storeExtraInfo(List<MethodPlugin> list) {
        if (list == null) {
            return;
        }
        Element element = this.document.createElement(TAG_methodElementProperty);
        element.setAttribute(ATTR_value, "0");
        this.libTag.appendChild(element);
        for (MethodPlugin methodPlugin : list) {
            Element element2 = this.document.createElement(TAG_methodElementProperty);
            element2.setAttribute(ATTR_value, methodPlugin.getGuid());
            Element element3 = this.document.createElement(TAG_methodElementProperty);
            element3.setAttribute(ATTR_value, methodPlugin.getName());
            this.libTag.appendChild(element2);
            this.libTag.appendChild(element3);
        }
    }

    private void recallExtraInfo() {
        try {
            NodeList nodeList = this.getMethodElementProperties();
            if (nodeList == null || nodeList.getLength() == 0) {
                return;
            }
            Element element = (Element)nodeList.item(0);
            String string = element.getAttribute(ATTR_value);
            if (string.equals("0")) {
                this.guidToPlugNameMap = new HashMap<String, String>();
                int n = 1;
                while (n < nodeList.getLength()) {
                    Element element2 = (Element)nodeList.item(n);
                    String string2 = element2.getAttribute(ATTR_value);
                    element2 = (Element)nodeList.item(n + 1);
                    String string3 = element2.getAttribute(ATTR_value);
                    this.guidToPlugNameMap.put(string2, string3);
                    n += 2;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.guidToPlugNameMap = null;
        }
    }

    public Map<String, String> getGuidToPlugNameMap() {
        if (this.guidToPlugNameMap == null) {
            this.recallExtraInfo();
        }
        return this.guidToPlugNameMap;
    }

    private NodeList getMethodElementProperties() {
        return this.libTag.getElementsByTagName(TAG_methodElementProperty);
    }

    public static class ConfigDocVisitor {
        public void visit(File file, Element element) {
        }
    }
}

