/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.wizards;

import java.util.ArrayList;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.ConfigurationExportData;
import org.eclipse.epf.export.wizards.ExportConfigCheckingPage;
import org.eclipse.epf.export.wizards.ExportConfigurationWizard;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ExportConfigSelectConfigPage
extends BaseWizardPage
implements ISelectionChangedListener,
Listener {
    public static final String PAGE_NAME = ExportConfigSelectConfigPage.class.getName();
    private Table table;
    private TableViewer ctrl_tableViewer;
    private Text ctrl_briefDesc;
    private ConfigurationExportData data;

    public ExportConfigSelectConfigPage(ConfigurationExportData configurationExportData) {
        super(PAGE_NAME);
        this.setTitle(ExportResources.selectConfigPage_title);
        this.setDescription(ExportResources.selectConfigPage_desc);
        this.setImageDescriptor(ExportPlugin.getDefault().getImageDescriptor("full/wizban/exp_lib_conf_wizban.gif"));
        this.data = configurationExportData;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        ExportConfigSelectConfigPage.createLabel((Composite)composite2, (String)ExportResources.selectConfigPage_configsLabel_text);
        this.ctrl_tableViewer = ExportConfigSelectConfigPage.createTableViewer((Composite)composite2, (int)360, (int)120, (int)1);
        this.table = this.ctrl_tableViewer.getTable();
        MethodConfiguration[] methodConfigurationArray = LibraryServiceUtil.getMethodConfigurations((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary());
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object object) {
                return LibraryUIImages.IMG_METHOD_PLUGIN;
            }

            public String getText(Object object) {
                if (object instanceof MethodConfiguration) {
                    return ((MethodConfiguration)object).getName();
                }
                return object.toString();
            }
        };
        this.ctrl_tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.ctrl_tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (methodConfigurationArray != null) {
            this.ctrl_tableViewer.setInput((Object)methodConfigurationArray);
        }
        ExportConfigSelectConfigPage.createLabel((Composite)composite2, (String)AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        this.ctrl_briefDesc = ExportConfigSelectConfigPage.createMultiLineText((Composite)composite2, (String)"", (int)360, (int)80, (int)3);
        if (methodConfigurationArray != null && methodConfigurationArray.length > 0) {
            this.table.select(0);
            this.setDisplayAttributes(methodConfigurationArray[0]);
        }
        this.addListeners();
        this.setControl((Control)composite2);
        this.setPageComplete(true);
    }

    private void addListeners() {
        this.ctrl_tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
        if (!structuredSelection.isEmpty()) {
            Object[] objectArray = structuredSelection.toArray();
            this.setDisplayAttributes((MethodConfiguration)objectArray[0]);
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    private void setDisplayAttributes(MethodConfiguration methodConfiguration) {
        this.ctrl_briefDesc.setText(methodConfiguration.getBriefDescription());
    }

    protected void saveDataToModel() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.ctrl_tableViewer.getSelection();
        Object[] objectArray = iStructuredSelection.toArray();
        MethodConfiguration methodConfiguration = (MethodConfiguration)objectArray[0];
        ArrayList<MethodConfiguration> arrayList = new ArrayList<MethodConfiguration>();
        arrayList.add(methodConfiguration);
        this.data.selectedConfigs = arrayList;
    }

    public IWizardPage getNextPage() {
        this.saveDataToModel();
        ExportConfigCheckingPage exportConfigCheckingPage = ((ExportConfigurationWizard)this.getWizard()).configCheckingPage;
        exportConfigCheckingPage.onEnterPage(null);
        return exportConfigCheckingPage;
    }

    public boolean isPageComplete() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.ctrl_tableViewer.getSelection();
        if (iStructuredSelection == null || iStructuredSelection.isEmpty()) {
            return false;
        }
        return super.isPageComplete();
    }
}

