/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.authoring.ui.wizards.SaveAllEditorsPage;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.PluginExportData;
import org.eclipse.epf.export.services.PluginExportService;
import org.eclipse.epf.export.wizards.ExportPluginSummaryPage;
import org.eclipse.epf.export.wizards.ExportUIPreferences;
import org.eclipse.epf.export.wizards.PluginInfoPage;
import org.eclipse.epf.export.wizards.SavePluginPage;
import org.eclipse.epf.export.wizards.SelectPluginPage;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.ui.wizards.DirectoryValidator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportPluginWizard
extends Wizard
implements IImportWizard {
    protected SelectPluginPage page1;
    protected PluginInfoPage page2;
    protected ExportPluginSummaryPage page3;
    protected SavePluginPage page4;
    protected boolean okToComplete = false;
    protected PluginExportData data = new PluginExportData();

    public ExportPluginWizard() {
        this.setWindowTitle(ExportResources.exportPluginsWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void addPages() {
        SaveAllEditorsPage.addPageIfNeeded((Wizard)this, (boolean)false, null, null, (ImageDescriptor)ExportPlugin.getDefault().getImageDescriptor("full/wizban/ExportMethodPlugins.gif"));
        this.page1 = new SelectPluginPage(this.data);
        this.addPage((IWizardPage)this.page1);
        this.page2 = new PluginInfoPage(this.data);
        this.addPage((IWizardPage)this.page2);
        this.page3 = new ExportPluginSummaryPage(this.data);
        this.addPage((IWizardPage)this.page3);
        this.page4 = new SavePluginPage(this.data);
        this.addPage((IWizardPage)this.page4);
    }

    public void createPageControls(Composite composite) {
        super.createPageControls(composite);
        composite.getShell().setImage(LibraryUIImages.IMG_METHOD_PLUGIN);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() != this.page4) {
            return false;
        }
        return this.okToComplete;
    }

    public boolean performFinish() {
        String string = this.data.llData.getParentFolder();
        if (!this.checkAndCreateDir(string)) {
            return false;
        }
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    try {
                        iProgressMonitor.beginTask(ExportResources.ExportPluginWizard_MSG1, -1);
                        if (ExportPluginWizard.this.data.validate()) {
                            new PluginExportService(ExportPluginWizard.this.data).run(iProgressMonitor);
                        }
                    }
                    catch (Exception exception) {
                        throw new InvocationTargetException(exception);
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            ExportPlugin.getDefault().getMsgDialog().displayError(ExportResources.ExportPluginWizard_error, throwable.getMessage());
            return false;
        }
        ExportUIPreferences.addExportPluginDir(string);
        return true;
    }

    private boolean checkAndCreateDir(String string) {
        return DirectoryValidator.checkAndCreateDir((String)string, (String)ExportResources.ExportPluginWizard_title, (String)ExportResources.ExportPluginError_msg, (boolean)false);
    }
}

