/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodUnit;

public class ElementDiffTree {
    public static final int DIFF_STATE_SAME = 0;
    public static final int DIFF_STATE_NEW = 1;
    public static final int DIFF_STATE_CHANGED = 4;
    public static final int DIFF_STATE_OLD_ONLY = 5;
    private MethodElement e1;
    private MethodElement e2;
    private MethodElement e1_parent;
    private ElementDiffTree parent = null;
    private int diffState = 0;
    private List children = new ArrayList();
    private boolean hasDirtyChild = false;

    public ElementDiffTree(MethodElement methodElement, MethodElement methodElement2) {
        this(methodElement, methodElement2, null);
    }

    public ElementDiffTree(MethodElement methodElement, MethodElement methodElement2, MethodElement methodElement3) {
        this.e1_parent = methodElement3;
        this.e1 = methodElement;
        this.e2 = methodElement2;
        this.resolveDiffState();
    }

    public MethodElement getBaseElement() {
        return this.e1;
    }

    public MethodElement getBaseParentElement() {
        return this.e1_parent;
    }

    public MethodElement getImportElement() {
        return this.e2;
    }

    public boolean isNew() {
        return this.e1 == null && this.e2 != null;
    }

    public boolean isOldOnly() {
        return this.e1 != null && this.e2 == null;
    }

    public boolean isBoth() {
        return this.e1 != null && this.e2 != null;
    }

    public void addChild(ElementDiffTree elementDiffTree) {
        this.children.add(elementDiffTree);
        elementDiffTree.setParent(this);
    }

    public boolean hasDirtyChild() {
        return this.hasDirtyChild;
    }

    public void setDirtyChild(boolean bl) {
        boolean bl2 = this.hasDirtyChild = this.hasDirtyChild || bl;
        if (this.hasDirtyChild && this.parent != null) {
            this.parent.setDirtyChild(this.hasDirtyChild);
        }
    }

    private void setParent(ElementDiffTree elementDiffTree) {
        this.parent = elementDiffTree;
        if (this.diffState != 0 && elementDiffTree != null) {
            elementDiffTree.setDirtyChild(true);
        }
    }

    public ElementDiffTree getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public List getChildren() {
        return this.children;
    }

    public int getDiffState() {
        return this.diffState;
    }

    public String getDiffMessage() {
        return "[" + this.getVersion(this.e1) + "] : [" + this.getVersion(this.e2) + "]";
    }

    private void resolveDiffState() {
        this.diffState = this.e1 == null ? 1 : (this.e2 == null ? 5 : (this.e1 instanceof MethodLibrary ? 0 : 4));
    }

    private String getVersion(MethodElement methodElement) {
        if (methodElement == null) {
            return "";
        }
        return this.getPackage(methodElement).getVersion();
    }

    private MethodUnit getPackage(MethodElement methodElement) {
        if (methodElement instanceof MethodUnit) {
            return (MethodUnit)methodElement;
        }
        return this.getPackage((MethodElement)methodElement.eContainer());
    }

    public String getName() {
        if (this.e1 != null) {
            return this.e1.getName();
        }
        if (this.e2 != null) {
            return this.e2.getName();
        }
        return "";
    }

    public String getContentType() {
        MethodElement methodElement = this.e1;
        if (methodElement == null) {
            methodElement = this.e2;
        }
        if (methodElement != null) {
            return methodElement.getType().getName();
        }
        return "";
    }

    public void debugDump() {
        this.debugDump(0, "");
    }

    private void debugDump(int n, String string) {
        String string2 = null;
        string2 = this.e1 == null ? "null" : String.valueOf(this.e1.getGuid()) + ", " + this.e1.getName() + ", " + this.e1.eClass().getName();
        this.outLn(n, string, string2);
        string2 = this.e2 == null ? "null" : String.valueOf(this.e2.getGuid()) + ", " + this.e2.getName() + ", " + this.e2.eClass().getName();
        this.outLn(n, string, string2);
        System.out.println("");
        int n2 = 0;
        while (n2 < this.children.size()) {
            ElementDiffTree elementDiffTree = (ElementDiffTree)this.children.get(n2);
            elementDiffTree.debugDump(n + 1, String.valueOf(string) + "   ");
            ++n2;
        }
    }

    private void outLn(int n, String string, String string2) {
        String string3 = String.valueOf(string) + n + ": " + string2;
        System.out.println(string3);
    }
}

