/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.migration.diagram.ad.services;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.epf.diagram.ad.part.ActivityDiagramEditorPlugin;
import org.eclipse.epf.diagram.add.part.ActivityDetailDiagramEditorPlugin;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.ActivityDiagram;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.diagram.model.WorkProductDependencyDiagram;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.model.util.GraphicalDataManager;
import org.eclipse.epf.diagram.wpdd.part.WPDDiagramEditorPlugin;
import org.eclipse.epf.library.configuration.ProcessAuthoringConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.util.DiagramOptions;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.migration.diagram.DiagramMigrationPlugin;
import org.eclipse.epf.migration.diagram.MigrationExportException;
import org.eclipse.epf.migration.diagram.ad.map.IMapConstants;
import org.eclipse.epf.migration.diagram.ad.map.MapFactory;
import org.eclipse.epf.migration.diagram.ad.map.MapNode;
import org.eclipse.epf.migration.diagram.ad.map.MapUtil;
import org.eclipse.epf.migration.diagram.addwpd.map.ConnectionFactory;
import org.eclipse.epf.migration.diagram.util.MigrationUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class WorkflowExportService {
    public static final String DEFAULT_XMI_EXTENSION = ".xmi";
    protected boolean debug;
    public static WorkflowExportService singleton = null;

    public static WorkflowExportService getInstance() {
        if (singleton == null) {
            singleton = new WorkflowExportService();
        }
        return singleton;
    }

    public boolean export(Process process, org.eclipse.epf.uma.Activity activity, String string, File file) throws MigrationExportException {
        this.debug = DiagramMigrationPlugin.getDefault().isDebugging();
        Path path = new Path(file.getAbsolutePath());
        boolean bl = string.toLowerCase().endsWith(DEFAULT_XMI_EXTENSION);
        String string2 = path.append(bl ? string : String.valueOf(string) + DEFAULT_XMI_EXTENSION).toOSString();
        URI.createFileURI((String)string2);
        DiagramManager diagramManager = DiagramManager.getInstance((Process)process, (Object)this);
        try {
            try {
                Map map;
                InternalTransaction internalTransaction = diagramManager.getEditingDomain().startTransaction(false, Collections.EMPTY_MAP);
                Resource resource = diagramManager.getResource();
                internalTransaction.commit();
                IMapConstants.graphUMLNodeMap.clear();
                if (process == activity) {
                    map = MigrationUtil.getActivities(process, true);
                    for (org.eclipse.epf.uma.Activity activity2 : map.values()) {
                        this.addAD(resource, process, activity2, diagramManager);
                        this.addADD(resource, process, activity2, diagramManager);
                        this.addWPD(resource, process, activity2, diagramManager);
                    }
                } else {
                    this.addAD(resource, process, activity, diagramManager);
                    this.addADD(resource, process, activity, diagramManager);
                    this.addWPD(resource, process, activity, diagramManager);
                }
                map = resource.getContents();
                if (map != null && !map.isEmpty()) {
                    resource.save(null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new MigrationExportException(exception);
            }
        }
        finally {
            if (diagramManager != null) {
                diagramManager.removeConsumer((Object)this);
            }
        }
        return true;
    }

    private void addDataToResource_WPD(Resource resource, Process process, org.eclipse.epf.uma.Activity activity) {
        org.eclipse.epf.uma.Diagram diagram = GraphicalDataManager.getInstance().getUMADiagram(activity, 1, false);
        if (diagram != null) {
            if (this.debug) {
                System.out.println("WPDD->" + process.getName() + "::" + activity.getName());
            }
            WorkProductDependencyDiagram workProductDependencyDiagram = ModelFactory.eINSTANCE.createWorkProductDependencyDiagram();
            this.addDataToResource_ADDorWPD(process, activity, resource, (org.eclipse.epf.diagram.model.Diagram)workProductDependencyDiagram);
        }
    }

    private void addDataToResource_ADD(Resource resource, Process process, org.eclipse.epf.uma.Activity activity) {
        org.eclipse.epf.uma.Diagram diagram = GraphicalDataManager.getInstance().getUMADiagram(activity, 2, false);
        if (diagram != null) {
            if (this.debug) {
                System.out.println("ADD->" + process.getName() + ":" + activity.getName());
            }
            ActivityDetailDiagram activityDetailDiagram = ModelFactory.eINSTANCE.createActivityDetailDiagram();
            this.addDataToResource_ADDorWPD(process, activity, resource, (org.eclipse.epf.diagram.model.Diagram)activityDetailDiagram);
        }
    }

    private void addDataToResource_ADDorWPD(Process process, org.eclipse.epf.uma.Activity activity, Resource resource, org.eclipse.epf.diagram.model.Diagram diagram) {
        Suppression suppression = new Suppression(process);
        diagram.setSuppression(suppression);
        String string = null;
        PreferencesHint preferencesHint = null;
        if (diagram instanceof ActivityDetailDiagram) {
            diagram.setFilter((IFilter)ProcessAuthoringConfigurator.INSTANCE);
            string = "ADD";
            preferencesHint = ActivityDetailDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
        } else if (diagram instanceof WorkProductDependencyDiagram) {
            string = "WPDD";
            preferencesHint = WPDDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
        } else {
            throw new UnsupportedOperationException();
        }
        diagram.setObject((Object)activity);
        diagram.setLinkedElement((MethodElement)activity);
        org.eclipse.epf.uma.Diagram diagram2 = diagram.getUMADiagram();
        if (diagram2 != null && diagram2.getSuppressed().booleanValue()) {
            if (diagram instanceof ActivityDetailDiagram) {
                DiagramOptions.setPublishADD((org.eclipse.epf.uma.Activity)activity, (boolean)false);
            } else if (diagram instanceof WorkProductDependencyDiagram) {
                DiagramOptions.setPublishWPDD((org.eclipse.epf.uma.Activity)activity, (boolean)false);
            }
        }
        if (diagram instanceof ActivityDetailDiagram) {
            boolean bl = GraphicalDataHelper.isAutoLayout((ActivityDetailDiagram)((ActivityDetailDiagram)diagram));
            ((ActivityDetailDiagram)diagram).setAutoLayout(bl);
        }
        Diagram diagram3 = ViewService.createDiagram((EObject)diagram, (String)string, (PreferencesHint)preferencesHint);
        diagram3.setElement((EObject)diagram);
        diagram3.setName(activity.getName());
        resource.getContents().add((Object)diagram);
        resource.getContents().add((Object)diagram3);
        ArrayList<org.eclipse.epf.diagram.model.Node> arrayList = new ArrayList<org.eclipse.epf.diagram.model.Node>();
        HashMap<org.eclipse.epf.diagram.model.Node, Node> hashMap = new HashMap<org.eclipse.epf.diagram.model.Node, Node>();
        EList eList = diagram.getNodes();
        for (Object object : eList) {
            Node node;
            if (!(object instanceof org.eclipse.epf.diagram.model.Node)) continue;
            Object object2 = (org.eclipse.epf.diagram.model.Node)object;
            if (object instanceof TypedNode && ((TypedNode)object).getType() == 6) {
                node = MapUtil.createText(diagram3, (org.eclipse.epf.diagram.model.Node)object);
                diagram3.insertChild((View)node);
                continue;
            }
            node = MapUtil.createNotationNode_ADDorWPD(diagram3, object2);
            if (node == null) continue;
            diagram3.insertChild((View)node);
            Bounds bounds = NotationFactory.eINSTANCE.createBounds();
            bounds.setHeight(object2.getHeight());
            bounds.setWidth(object2.getWidth());
            bounds.setX(object2.getLocation().x);
            bounds.setY(object2.getLocation().y);
            node.setLayoutConstraint((LayoutConstraint)bounds);
            node.setElement((EObject)object2);
            arrayList.add((org.eclipse.epf.diagram.model.Node)object2);
            hashMap.put((org.eclipse.epf.diagram.model.Node)object2, node);
        }
        ConnectionFactory connectionFactory = new ConnectionFactory(diagram3, hashMap, string);
        for (Object object2 : arrayList) {
            if (!(object2 instanceof org.eclipse.epf.diagram.model.Node)) continue;
            connectionFactory.outgoingConnections((org.eclipse.epf.diagram.model.Node)object2);
        }
        for (Object object2 : arrayList) {
            if (!(object2 instanceof org.eclipse.epf.diagram.model.Node)) continue;
            connectionFactory.incomingConnections((org.eclipse.epf.diagram.model.Node)object2);
        }
    }

    private void addDataToResource_AD(Resource resource, Process process, org.eclipse.epf.uma.Activity activity) {
        EList eList;
        EObject eObject;
        org.eclipse.epf.uma.Diagram diagram = GraphicalDataManager.getInstance().getUMADiagram(activity, 0, false);
        if (diagram == null) {
            return;
        }
        if (this.debug) {
            System.out.println("AD->" + process.getName() + ":" + activity.getName());
        }
        if ((eObject = UMLFactory.eINSTANCE.create(UMLPackage.eINSTANCE.getActivity())) instanceof Activity) {
            ((Activity)eObject).setName(activity.getName());
        }
        if (eObject instanceof EModelElement) {
            BridgeHelper.associate((EModelElement)((EModelElement)eObject), (MethodElement)activity);
        }
        Diagram diagram2 = ViewService.createDiagram((EObject)eObject, (String)"AD", (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        diagram2.setElement(eObject);
        if (eObject instanceof Activity) {
            diagram2.setName(activity.getName());
        }
        Suppression suppression = new Suppression(process);
        ActivityDiagram activityDiagram = ModelFactory.eINSTANCE.createActivityDiagram();
        activityDiagram.setSuppression(suppression);
        activityDiagram.setObject((Object)activity);
        if (activityDiagram.isNew()) {
            return;
        }
        org.eclipse.epf.uma.Diagram diagram3 = activityDiagram.getUMADiagram();
        if (diagram3 != null && diagram3.getSuppressed().booleanValue()) {
            DiagramOptions.setPublishAD((org.eclipse.epf.uma.Activity)activity, (boolean)false);
        }
        if ((eList = activityDiagram.getNodes()) == null) {
            return;
        }
        resource.getContents().add((Object)eObject);
        resource.getContents().add((Object)diagram2);
        ArrayList<MapNode> arrayList = new ArrayList<MapNode>();
        HashMap<MapNode, org.eclipse.epf.diagram.model.Node> hashMap = new HashMap<MapNode, org.eclipse.epf.diagram.model.Node>();
        for (Object e : eList) {
            if (!(e instanceof org.eclipse.epf.diagram.model.Node)) continue;
            if (e instanceof TypedNode && ((TypedNode)e).getType() == 6) {
                MapUtil.createText(diagram2, (org.eclipse.epf.diagram.model.Node)e);
                continue;
            }
            MapNode mapNode = MapFactory.getInstance().create((org.eclipse.epf.diagram.model.Node)e);
            mapNode.setActivity((Activity)eObject);
            mapNode.setDiagram(diagram2);
            mapNode.updateResource();
            arrayList.add(mapNode);
            hashMap.put(mapNode, (org.eclipse.epf.diagram.model.Node)e);
        }
        for (Object e : arrayList) {
            if (!(e instanceof MapNode)) continue;
            ((MapNode)e).outgoingConnections((org.eclipse.epf.diagram.model.Node)hashMap.get((MapNode)e));
        }
        for (Object e : arrayList) {
            if (!(e instanceof MapNode)) continue;
            ((MapNode)e).incomingConnections((org.eclipse.epf.diagram.model.Node)hashMap.get((MapNode)e));
        }
    }

    private List getActivityDiagramData(Suppression suppression, org.eclipse.epf.uma.Activity activity) {
        ActivityDiagram activityDiagram = ModelFactory.eINSTANCE.createActivityDiagram();
        activityDiagram.setSuppression(suppression);
        activityDiagram.setObject((Object)activity);
        if (activityDiagram.isNew()) {
            return null;
        }
        return activityDiagram.getNodes();
    }

    private void addAD(Resource resource, Process process, org.eclipse.epf.uma.Activity activity, DiagramManager diagramManager) {
        this.addToResource(resource, process, activity, diagramManager, 0);
    }

    private void addADD(Resource resource, Process process, org.eclipse.epf.uma.Activity activity, DiagramManager diagramManager) {
        this.addToResource(resource, process, activity, diagramManager, 1);
    }

    private void addWPD(Resource resource, Process process, org.eclipse.epf.uma.Activity activity, DiagramManager diagramManager) {
        this.addToResource(resource, process, activity, diagramManager, 2);
    }

    private void addToResource(final Resource resource, final Process process, final org.eclipse.epf.uma.Activity activity, final DiagramManager diagramManager, final int n) {
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                try {
                    InternalTransaction internalTransaction = diagramManager.getEditingDomain().startTransaction(false, Collections.EMPTY_MAP);
                    if (n == 0) {
                        WorkflowExportService.this.addDataToResource_AD(resource, process, activity);
                    } else if (n == 1) {
                        WorkflowExportService.this.addDataToResource_ADD(resource, process, activity);
                    } else if (n == 2) {
                        WorkflowExportService.this.addDataToResource_WPD(resource, process, activity);
                    } else if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    internalTransaction.commit();
                }
                catch (Exception exception) {}
            }
        });
    }
}

