/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.gef.commands.ChangeBoundsCommand;
import org.eclipse.epf.authoring.gef.edit.LinkEditPart;
import org.eclipse.epf.authoring.gef.edit.NodeContainerEditPart;
import org.eclipse.epf.authoring.gef.edit.policies.DiagramLayoutEditPolicy;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;

public class DiagramEditPart
extends NodeContainerEditPart {
    Point cachedPoint = new Point(-1, -1);
    protected boolean debug = AuthoringUIPlugin.getDefault().isDebugging();
    private boolean markDirty = false;
    static int cachedWidth = 10;
    static int cachedHeight = 10;

    public DiagramEditPart(Diagram diagram) {
        super((NodeContainer)diagram);
    }

    protected IFigure createFigure() {
        FreeformLayer freeformLayer = new FreeformLayer(){

            protected void layout() {
                if (DiagramEditPart.this.hasMisplacedChildren()) {
                    DiagramEditPart.this.resetChildrenLocations();
                }
                super.layout();
            }
        };
        freeformLayer.setBorder((Border)new MarginBorder(20));
        freeformLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        return freeformLayer;
    }

    protected void resetChildrenLocations() {
        int n = 10;
        int n2 = 0;
        int n3 = 0;
        int n4 = 10;
        boolean bl = TngUtil.isLocked((EObject)((EObject)((Diagram)this.getModel()).getObject()));
        for (Object e : this.getChildren()) {
            Node node;
            Point point;
            if (!(e instanceof GraphicalEditPart)) continue;
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)e;
            int n5 = graphicalEditPart.getRoot().getViewer().getControl().getBounds().width;
            if (!(graphicalEditPart.getModel() instanceof Node) || (point = (node = (Node)graphicalEditPart.getModel()).getLocation().getCopy()) != null && point.x != -1) continue;
            if (n4 + graphicalEditPart.getFigure().getPreferredSize().width > n5) {
                n = this.cachedPoint.y + cachedHeight + 40;
                n3 = 0;
                n4 = 10;
                this.cachedPoint.x = -1;
                n2 = 0;
            }
            if (this.cachedPoint.x != -1) {
                n4 = this.cachedPoint.x + cachedWidth + 40;
            }
            ++n3;
            if (point == null) {
                point = new Point(-1, -1);
            }
            point.x = n4;
            point.y = n;
            if (!bl && ((Diagram)this.getModel()).isNew() && !((Diagram)this.getModel()).isReadOnly() && this.markDirty) {
                ChangeBoundsCommand changeBoundsCommand = new ChangeBoundsCommand(node, point, graphicalEditPart.getFigure().getPreferredSize().width);
                this.getViewer().getEditDomain().getCommandStack().execute((Command)changeBoundsCommand);
            } else {
                node.setLocation(point);
            }
            this.cachedPoint = point;
            cachedWidth = graphicalEditPart.getFigure().getPreferredSize().width;
            cachedHeight = graphicalEditPart.getFigure().getPreferredSize().height;
            if (this.debug) {
                System.out.println("Point : " + new Point(n4, n).toString());
                System.out.println("Cached : width: " + cachedWidth + " Height : " + cachedHeight);
            }
            n2 += n4;
        }
    }

    protected boolean hasMisplacedChildren() {
        for (Object e : this.getChildren()) {
            Node node;
            Point point;
            Object object;
            if (!(e instanceof EditPart) || !((object = ((EditPart)e).getModel()) instanceof Node) || (point = (node = (Node)object).getLocation()) != null && point.x != -1) continue;
            return true;
        }
        return false;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new DiagramLayoutEditPolicy());
    }

    protected void addPartToEdit(Collection collection, Object object) {
        if (object instanceof NodeContainer) {
            NodeContainerEditPart nodeContainerEditPart = (NodeContainerEditPart)this.findChildByModel(object);
            Iterator iterator = ((NodeContainer)object).getNodes().iterator();
            while (iterator.hasNext()) {
                nodeContainerEditPart.addPartToEdit(collection, iterator.next());
            }
        } else {
            super.addPartToEdit(collection, object);
        }
    }

    public void moveFigure(int n, int n2) {
        for (Object e : this.getChildren()) {
            if (!(e instanceof GraphicalEditPart)) continue;
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)e;
            Rectangle rectangle = graphicalEditPart.getFigure().getBounds();
            Rectangle rectangle2 = new Rectangle(new Point(rectangle.x + n, rectangle.y + n2), rectangle.getSize());
            List list = graphicalEditPart.getSourceConnections();
            for (LinkEditPart linkEditPart : list) {
                Link link = (Link)linkEditPart.getModel();
                if (link.getBendpoints().size() <= 0) continue;
                PointList pointList = ((PolylineConnection)linkEditPart.getFigure()).getPoints();
                ArrayList<AbsoluteBendpoint> arrayList = new ArrayList<AbsoluteBendpoint>();
                int n3 = 1;
                while (n3 < pointList.size() - 1) {
                    Point point = pointList.getPoint(n3);
                    point = point.translate(new Point(n, n2));
                    AbsoluteBendpoint absoluteBendpoint = new AbsoluteBendpoint(point);
                    arrayList.add(absoluteBendpoint);
                    ++n3;
                }
                linkEditPart.getConnectionFigure().setRoutingConstraint(arrayList);
            }
            this.setLayoutConstraint((EditPart)graphicalEditPart, graphicalEditPart.getFigure(), rectangle2);
        }
    }

    public void markDirty(boolean bl) {
        this.markDirty = bl;
    }
}

