/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.gef.commands.DeleteCommand;
import org.eclipse.epf.authoring.gef.edit.ActivityDetailDiagramEditPart;
import org.eclipse.epf.authoring.gef.edit.BaseEditPart;
import org.eclipse.epf.authoring.gef.edit.DiagramActionService;
import org.eclipse.epf.authoring.gef.edit.DiagramUpdateService;
import org.eclipse.epf.authoring.gef.edit.ValidatingDirectEditManager;
import org.eclipse.epf.authoring.gef.edit.policies.NodeContainerEditPolicy;
import org.eclipse.epf.authoring.gef.edit.policies.NodeContainerFlowLayoutEditPolicy;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gef.ui.actions.ActionRegistry;

public abstract class NodeContainerEditPart
extends AbstractGraphicalEditPart
implements LayerConstants {
    private BendpointConnectionRouter cRouter;
    protected Adapter modelListener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            NodeContainerEditPart.this.handlePropertyChanged(notification);
        }
    };

    public NodeContainerEditPart(NodeContainer nodeContainer) {
        this.setModel(nodeContainer);
    }

    public void activate() {
        super.activate();
        NodeContainer nodeContainer = (NodeContainer)((EObject)this.getModel());
        nodeContainer.eAdapters().add((Object)this.modelListener);
        nodeContainer.addConsumer((Object)this);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command createDeleteCommand(GroupRequest groupRequest) {
                Boolean bl = (Boolean)groupRequest.getExtendedData().get("gef.ediagram.$perm");
                boolean bl2 = bl == null ? false : bl;
                DeleteCommand deleteCommand = new DeleteCommand(bl2);
                deleteCommand.setPartToBeDeleted(this.getHost().getModel());
                return deleteCommand;
            }
        });
        this.installEditPolicy("Selection Feedback", null);
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new NodeContainerEditPolicy());
        this.installEditPolicy("NodeEditPolicy", null);
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new NodeContainerFlowLayoutEditPolicy());
    }

    public void deactivate() {
        NodeContainer nodeContainer = (NodeContainer)((EObject)this.getModel());
        nodeContainer.eAdapters().remove((Object)this.modelListener);
        nodeContainer.removeConsumer((Object)this);
        super.deactivate();
    }

    protected EditPart findChildByModel(Object object) {
        for (EditPart editPart : this.getChildren()) {
            if (editPart.getModel() != object) continue;
            return editPart;
        }
        return null;
    }

    protected void addPartToEdit(Collection collection, Object object) {
        DirectEditManager directEditManager;
        EditPart editPart;
        if (object instanceof NamedNode && (editPart = this.findChildByModel(object)) instanceof BaseEditPart && (directEditManager = ((BaseEditPart)editPart).getDirectEditManager()) instanceof ValidatingDirectEditManager && ((ValidatingDirectEditManager)directEditManager).validate(((NamedNode)object).getName()) != null) {
            collection.add(editPart);
        }
    }

    protected void handlePropertyChanged(Notification notification) {
        switch (notification.getFeatureID(NodeContainer.class)) {
            case 1: 
            case 2: {
                this.refreshVisuals();
                break;
            }
            case 5: {
                this.refreshSourceConnections();
                break;
            }
            case 4: {
                this.refreshTargetConnections();
                break;
            }
            case 7: {
                this.refreshChildren();
                ArrayList arrayList = new ArrayList();
                switch (notification.getEventType()) {
                    case 3: {
                        this.addPartToEdit(arrayList, notification.getNewValue());
                        break;
                    }
                    case 5: {
                        Iterator iterator = ((Collection)notification.getNewValue()).iterator();
                        while (iterator.hasNext()) {
                            this.addPartToEdit(arrayList, iterator.next());
                        }
                        break;
                    }
                }
                if (!this.getViewer().getControl().isFocusControl()) break;
                for (BaseEditPart baseEditPart : arrayList) {
                    baseEditPart.performDirectEdit();
                }
                break;
            }
        }
    }

    protected void refreshVisuals() {
        Point point;
        Node node = (Node)this.getModel();
        Dimension dimension = new Dimension(node.getWidth(), node.getHeight());
        if (dimension == null) {
            dimension = new Dimension(60, 100);
        }
        if ((point = node.getLocation()) == null) {
            point = new Point(10, 10);
        }
        Rectangle rectangle = new Rectangle(point, dimension);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)rectangle);
        if (this.cRouter == null) {
            ConnectionLayer connectionLayer = (ConnectionLayer)this.getLayer("Connection Layer");
            FanRouter fanRouter = new FanRouter();
            fanRouter.setSeparation(30);
            this.cRouter = new BendpointConnectionRouter();
            fanRouter.setNextRouter((ConnectionRouter)this.cRouter);
            connectionLayer.setConnectionRouter((ConnectionRouter)fanRouter);
        }
    }

    protected List getModelChildren() {
        return ((NodeContainer)this.getModel()).getNodes();
    }

    protected void cleanUpDiagram(EditPart editPart) {
        ActivityDetailDiagramEditPart activityDetailDiagramEditPart;
        EditPart editPart2 = editPart.getParent();
        if (editPart2 instanceof ActivityDetailDiagramEditPart && !((Diagram)(activityDetailDiagramEditPart = (ActivityDetailDiagramEditPart)editPart2).getModel()).isReadOnly()) {
            activityDetailDiagramEditPart.getRecentlyAddedParts().addAll(editPart2.getChildren());
            DefaultEditDomain defaultEditDomain = new DefaultEditDomain(null);
            ActionRegistry actionRegistry = new ActionRegistry();
            DiagramActionService diagramActionService = new DiagramActionService((GraphicalViewer)this.getParent().getViewer(), defaultEditDomain, actionRegistry);
            diagramActionService.registerVerticalAlignFirstSelectedAction();
            DiagramUpdateService diagramUpdateService = new DiagramUpdateService((GraphicalViewer)this.getParent().getViewer(), defaultEditDomain, actionRegistry);
            diagramUpdateService.cleanUpDiagram();
        }
    }
}

