/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.epf.authoring.gef.figures.TextFigure;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;

public class TextFigureCellEditorLocator
implements CellEditorLocator {
    private TextFigure figure;

    public TextFigureCellEditorLocator(TextFigure textFigure) {
        this.setFigure(textFigure);
    }

    public void relocate(CellEditor cellEditor) {
        TextFigureCellEditorLocator.doLocate(cellEditor, this.figure);
    }

    public static void doLocate(CellEditor cellEditor, TextFigure textFigure) {
        Text text = (Text)cellEditor.getControl();
        String string = (String)cellEditor.getValue();
        GC gC = new GC((Drawable)text);
        Point point = gC.textExtent(string);
        gC.dispose();
        if (point.x != 0) {
            point = text.computeSize(point.x, -1);
        }
        text.setSize(point.x, point.y);
        Rectangle rectangle = new Rectangle(text.getClientArea().x, text.getClientArea().y, text.getClientArea().width, text.getClientArea().height);
        Rectangle rectangle2 = textFigure.getClientArea();
        textFigure.translateToAbsolute((Translatable)rectangle2);
        int n = (rectangle2.width - rectangle.width) / 2;
        int n2 = textFigure.getTextFlowPage().getLocation().y;
        text.setLocation(rectangle2.x + n, n2);
    }

    public TextFigure getFigure() {
        return this.figure;
    }

    public void setFigure(TextFigure textFigure) {
        this.figure = textFigure;
    }
}

