/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.epf.authoring.gef.edit.NamedNodeEditPart;
import org.eclipse.epf.authoring.gef.util.DiagramUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.WorkBreakdownElementNode;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class ValidatingDirectEditManager
extends DirectEditManager {
    Font scaledFont;
    protected VerifyListener verifyListener;
    protected Label activityLabel;

    public ValidatingDirectEditManager(GraphicalEditPart graphicalEditPart, Class clazz, CellEditorLocator cellEditorLocator, Label label) {
        super(graphicalEditPart, clazz, cellEditorLocator);
        this.activityLabel = label;
    }

    protected void bringDown() {
        this.bringDown(true);
    }

    protected void bringDown(boolean bl) {
        Font font = this.scaledFont;
        this.scaledFont = null;
        super.bringDown();
        if (font != null) {
            font.dispose();
        }
        if (bl) {
            Object object;
            NamedNode namedNode = (NamedNode)this.getEditPart().getModel();
            String string = namedNode.getName();
            if (namedNode instanceof WorkBreakdownElementNode && (object = namedNode.getObject()) instanceof Activity && ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)((BreakdownElement)object))) {
                string = ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)object));
            }
            if (string == null || string.trim().length() == 0) {
                Display.getCurrent().asyncExec((Runnable)new PromptEdit((NamedNodeEditPart)this.getEditPart(), DiagramUIResources.err_name_empty));
            }
        }
    }

    protected void initCellEditor() {
        Text text = (Text)this.getCellEditor().getControl();
        this.verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                Text text = (Text)ValidatingDirectEditManager.this.getCellEditor().getControl();
                String string = text.getText();
                String string2 = string.substring(0, verifyEvent.start);
                String string3 = string.substring(verifyEvent.end, string.length());
                GC gC = new GC((Drawable)text);
                Point point = gC.textExtent(String.valueOf(string2) + verifyEvent.text + string3);
                gC.dispose();
                if (point.x != 0) {
                    point = text.computeSize(point.x, -1);
                }
                ValidatingDirectEditManager.this.getCellEditor().getControl().setSize(point.x, point.y);
            }
        };
        text.addVerifyListener(this.verifyListener);
        String string = this.activityLabel.getText();
        this.getCellEditor().setValue((Object)string);
        IFigure iFigure = this.getEditPart().getFigure();
        this.scaledFont = iFigure.getFont();
        FontData fontData = this.scaledFont.getFontData()[0];
        Dimension dimension = new Dimension(0, fontData.getHeight());
        this.activityLabel.translateToAbsolute((Translatable)dimension);
        fontData.setHeight(dimension.height);
        this.scaledFont = new Font(null, fontData);
        text.setFont(this.scaledFont);
        text.selectAll();
    }

    protected void unhookListeners() {
        super.unhookListeners();
        if (this.getCellEditor() != null) {
            Text text = (Text)this.getCellEditor().getControl();
            text.removeVerifyListener(this.verifyListener);
            this.verifyListener = null;
        }
    }

    protected String validate(String string) {
        return null;
    }

    protected void commit() {
        String string = this.validate((String)this.getCellEditor().getValue());
        if (string != null) {
            this.bringDown(false);
            Display.getCurrent().asyncExec((Runnable)new PromptEdit((NamedNodeEditPart)this.getEditPart(), string));
            return;
        }
        super.commit();
    }

    static class PromptEdit
    implements Runnable {
        private NamedNodeEditPart part;
        private String msg;

        PromptEdit(NamedNodeEditPart namedNodeEditPart, String string) {
            this.part = namedNodeEditPart;
            this.msg = string;
        }

        public void run() {
            String string = DiagramUIResources.diagram_errorDialog_title_text0;
            MsgDialog msgDialog = AuthoringUIPlugin.getDefault().getMsgDialog();
            msgDialog.displayError(string, this.msg);
            this.part.performDirectEdit();
        }
    }
}

