/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.ConfigurationViewEditAction;
import org.eclipse.epf.authoring.ui.actions.ILibraryActionBarContributor;
import org.eclipse.epf.authoring.ui.actions.LibraryValidateAction;
import org.eclipse.epf.authoring.ui.actions.LibraryViewEditAction;
import org.eclipse.epf.authoring.ui.actions.MethodCreateChildAction;
import org.eclipse.epf.authoring.ui.actions.MethodCreateSiblingAction;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class LibraryActionBarContributor
extends EditingDomainActionBarContributor
implements ILibraryActionBarContributor,
ISelectionChangedListener {
    protected IViewPart activeViewPart;
    protected ISelectionProvider selectionProvider;
    protected IActionBars viewActionBars;
    protected LibraryViewEditAction libraryViewEditAction;
    protected ConfigurationViewEditAction configViewEditAction;
    private EditingDomain editingDomain;
    protected IAction showPropertiesViewAction = new Action(AuthoringUIResources._UI_ShowPropertiesView_menu_item){

        public void run() {
            try {
                try {
                    LibraryActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
                }
                catch (PartInitException partInitException) {
                    partInitException.printStackTrace();
                }
            }
            catch (RuntimeException runtimeException) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)runtimeException);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(AuthoringUIResources._UI_RefreshViewer_menu_item){

        public boolean isEnabled() {
            return LibraryActionBarContributor.this.activeViewPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (LibraryActionBarContributor.this.activeViewPart instanceof IViewerProvider && (viewer = ((IViewerProvider)LibraryActionBarContributor.this.activeViewPart).getViewer()) != null) {
                LibraryActionBarContributor.this.refreshViewer(viewer);
            }
        }
    };
    protected Collection createChildActions;
    protected IMenuManager createChildMenuManager;
    protected Collection createSiblingActions;
    protected IMenuManager createSiblingMenuManager;

    public LibraryActionBarContributor(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
        this.validateAction = new LibraryValidateAction();
        ((LibraryValidateAction)this.validateAction).putContextData("CTX_ADAPTER_FACTORY_PROVIDER", ProcessEditor.adapterFactoryProvider);
    }

    protected void refreshViewer(Viewer viewer) {
        viewer.refresh();
    }

    public void contributeToToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IContributionItem)new Separator("method-settings"));
        iToolBarManager.add((IContributionItem)new Separator("method-additions"));
    }

    public void contributeToMenu(IMenuManager iMenuManager) {
        super.contributeToMenu(iMenuManager);
        MenuManager menuManager = new MenuManager(AuthoringUIResources._UI_MethodEditor_menu, "com.ibm.methodMenuID");
        iMenuManager.insertAfter("additions", (IContributionItem)menuManager);
        menuManager.add((IContributionItem)new Separator("settings"));
        menuManager.add((IContributionItem)new Separator("actions"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(AuthoringUIResources._UI_CreateChild_menu_item);
        menuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(AuthoringUIResources._UI_CreateSibling_menu_item);
        menuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                iMenuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)menuManager);
    }

    public IViewPart getActiveView() {
        return this.activeViewPart;
    }

    public void setActiveView(IViewPart iViewPart) {
        if (iViewPart != null) {
            super.setActiveView(iViewPart);
        }
        if (iViewPart == this.activeViewPart) {
            return;
        }
        if (this.activeViewPart != null) {
            this.deactivate();
        }
        if (iViewPart == null) {
            this.selectionProvider = null;
        }
        if (!(iViewPart instanceof IEditingDomainProvider)) {
            return;
        }
        this.activeViewPart = iViewPart;
        this.editingDomain = ((IEditingDomainProvider)iViewPart).getEditingDomain();
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            this.selectionProvider = iViewPart.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
        this.activate();
    }

    public void deactivate() {
        this.activeViewPart.removePropertyListener((IPropertyListener)this);
        this.deleteAction.setEditingDomain(null);
        this.cutAction.setEditingDomain(null);
        this.copyAction.setEditingDomain(null);
        this.pasteAction.setEditingDomain(null);
        this.undoAction.setEditingDomain(null);
        this.redoAction.setEditingDomain(null);
        if (this.loadResourceAction != null) {
            this.loadResourceAction.setEditingDomain(null);
        }
        ISelectionProvider iSelectionProvider = this.activeViewPart instanceof ISelectionProvider ? (ISelectionProvider)this.activeViewPart : this.activeViewPart.getSite().getSelectionProvider();
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.libraryViewEditAction);
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.cutAction);
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.copyAction);
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
    }

    public void disableGlobalEditMenu() {
        this.deleteAction.setEnabled(false);
        if (this.libraryViewEditAction != null) {
            this.libraryViewEditAction.setEnabled(false);
        }
        if (this.configViewEditAction != null) {
            this.configViewEditAction.setEnabled(false);
        }
        this.cutAction.setEnabled(false);
        this.copyAction.setEnabled(false);
        this.pasteAction.setEnabled(false);
        this.undoAction.setEnabled(false);
        this.redoAction.setEnabled(false);
    }

    public void enableGlobalEditMenu() {
        this.deleteAction.setEnabled(true);
        if (this.libraryViewEditAction != null) {
            this.libraryViewEditAction.setEnabled(true);
        }
        if (this.configViewEditAction != null) {
            this.configViewEditAction.setEnabled(true);
        }
        this.cutAction.setEnabled(true);
        this.copyAction.setEnabled(true);
        this.pasteAction.setEnabled(true);
        this.undoAction.setEnabled(true);
        this.redoAction.setEnabled(true);
    }

    public void activate() {
        this.activeViewPart.addPropertyListener((IPropertyListener)this);
        this.deleteAction.setEditingDomain(this.editingDomain);
        this.cutAction.setEditingDomain(this.editingDomain);
        this.copyAction.setEditingDomain(this.editingDomain);
        this.pasteAction.setEditingDomain(this.editingDomain);
        this.undoAction.setEditingDomain(this.editingDomain);
        this.redoAction.setEditingDomain(this.editingDomain);
        if (this.loadResourceAction != null) {
            this.loadResourceAction.setEditingDomain(this.editingDomain);
        }
        ISelectionProvider iSelectionProvider = this.activeViewPart instanceof ISelectionProvider ? (ISelectionProvider)this.activeViewPart : this.activeViewPart.getSite().getSelectionProvider();
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.libraryViewEditAction);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.cutAction);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.copyAction);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
        if (this.validateAction != null) {
            iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.validateAction);
        }
        if (this.controlAction != null) {
            iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.controlAction);
        }
        this.update();
    }

    public void update() {
        if (this.activeViewPart == null) {
            return;
        }
        ISelectionProvider iSelectionProvider = this.activeViewPart instanceof ISelectionProvider ? (ISelectionProvider)this.activeViewPart : this.activeViewPart.getSite().getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        StructuredSelection structuredSelection = iSelection instanceof IStructuredSelection ? (IStructuredSelection)iSelection : StructuredSelection.EMPTY;
        this.deleteAction.updateSelection((IStructuredSelection)structuredSelection);
        this.libraryViewEditAction.updateSelection((IStructuredSelection)structuredSelection);
        this.cutAction.updateSelection((IStructuredSelection)structuredSelection);
        this.copyAction.updateSelection((IStructuredSelection)structuredSelection);
        this.pasteAction.updateSelection((IStructuredSelection)structuredSelection);
        this.undoAction.update();
        this.redoAction.update();
        if (this.loadResourceAction != null) {
            this.loadResourceAction.update();
        }
        if (this.validateAction != null) {
            this.validateAction.updateSelection((IStructuredSelection)structuredSelection);
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection collection = null;
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection instanceof IStructuredSelection && ((IStructuredSelection)iSelection).size() == 1) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            EditingDomain editingDomain = ((IEditingDomainProvider)this.activeViewPart).getEditingDomain();
            collection = editingDomain.getNewChildDescriptors(object, null);
        }
        this.createChildActions = this.generateCreateChildActions(collection, iSelection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
    }

    protected Collection generateCreateChildActions(Collection collection, ISelection iSelection) {
        ArrayList<MethodCreateChildAction> arrayList = new ArrayList<MethodCreateChildAction>();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new MethodCreateChildAction(this.editingDomain, iSelection, iterator.next()));
            }
        }
        return arrayList;
    }

    protected Collection generateCreateSiblingActions(Collection collection, ISelection iSelection) {
        ArrayList<MethodCreateSiblingAction> arrayList = new ArrayList<MethodCreateSiblingAction>();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new MethodCreateSiblingAction(this.activeViewPart, iSelection, iterator.next()));
            }
        }
        return arrayList;
    }

    protected void populateManager(IContributionManager iContributionManager, Collection collection, String string) {
        if (collection != null) {
            for (IAction iAction : collection) {
                if (string != null) {
                    iContributionManager.insertBefore(string, iAction);
                    continue;
                }
                iContributionManager.add(iAction);
            }
        }
    }

    protected void depopulateManager(IContributionManager iContributionManager, Collection collection) {
        if (collection != null) {
            IContributionItem[] iContributionItemArray = iContributionManager.getItems();
            int n = 0;
            while (n < iContributionItemArray.length) {
                IAction iAction;
                IContributionItem iContributionItem = iContributionItemArray[n];
                while (iContributionItem instanceof SubContributionItem) {
                    iContributionItem = ((SubContributionItem)iContributionItem).getInnerItem();
                }
                if (iContributionItem instanceof ActionContributionItem && collection.contains(iAction = ((ActionContributionItem)iContributionItem).getAction())) {
                    iContributionManager.remove(iContributionItem);
                }
                ++n;
            }
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        super.menuAboutToShow(iMenuManager);
        MenuManager menuManager = null;
        menuManager = new MenuManager(AuthoringUIResources._UI_CreateChild_menu_item);
        this.populateManager((IContributionManager)menuManager, this.createChildActions, null);
        iMenuManager.insertBefore("additions", (IContributionItem)menuManager);
    }

    protected void addGlobalActions(IMenuManager iMenuManager) {
        String string;
        iMenuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        iMenuManager.insertAfter("ui-actions", this.refreshViewerAction);
        iMenuManager.insertBefore("additions-end", (IContributionItem)new Separator());
        String string2 = string = (this.style & 1) == 0 ? "additions-end" : "additions";
        if (this.validateAction != null) {
            iMenuManager.insertBefore(string, (IContributionItem)new ActionContributionItem((IAction)this.validateAction));
        }
    }

    public void init(IActionBars iActionBars, IWorkbenchPage iWorkbenchPage) {
        super.init(iActionBars, iWorkbenchPage);
    }

    public void init(IActionBars iActionBars) {
        this.viewActionBars = iActionBars;
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.libraryViewEditAction = new LibraryViewEditAction(AuthoringUIResources.actionLabel_edit);
        iActionBars.setGlobalActionHandler(LibraryViewEditAction.ACTION_ID, (IAction)this.libraryViewEditAction);
        this.cutAction = this.createCutAction();
        this.cutAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        iActionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        this.copyAction = this.createCopyAction();
        this.copyAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        iActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        this.pasteAction = this.createPasteAction();
        this.pasteAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        iActionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        this.deleteAction = this.createDeleteAction();
        this.deleteAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        iActionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        this.undoAction = new UndoAction();
        this.undoAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        iActionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.redoAction = new RedoAction();
        this.redoAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        iActionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        this.libraryViewEditAction.setEnabled(false);
        this.contributeToToolBar(iActionBars.getToolBarManager());
    }

    protected CutAction createCutAction() {
        return new CutAction();
    }

    protected PasteAction createPasteAction() {
        return new PasteAction();
    }

    protected CopyAction createCopyAction() {
        return new CopyAction();
    }

    protected DeleteAction createDeleteAction() {
        return new DeleteAction();
    }

    public IActionBars getActionBars() {
        return this.viewActionBars;
    }
}

