/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.authoring.ui.actions.IWorkbenchPartAction;
import org.eclipse.epf.authoring.ui.actions.ProcessAutoSynchronizeAction;
import org.eclipse.epf.authoring.ui.wizards.SynchronizationChoices;
import org.eclipse.epf.authoring.ui.wizards.SynchronizationWizard;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.process.command.SynchronizeCommand;
import org.eclipse.epf.library.ui.actions.LibraryLockingOperationRunner;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public class SynchronizationAction
extends ProcessAutoSynchronizeAction
implements IWorkbenchPartAction {
    private Process selectedProcess;

    public SynchronizationAction() {
        super(LibraryEditResources.ManualSynchronizeCommand_label);
    }

    public void setProcess(Process process) {
        this.selectedProcess = process;
    }

    private void superRun() {
        super.run();
    }

    public void run() {
        LibraryLockingOperationRunner libraryLockingOperationRunner = new LibraryLockingOperationRunner();
        libraryLockingOperationRunner.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                SynchronizationChoices synchronizationChoices = new SynchronizationChoices();
                synchronizationChoices.setSelectedProcess(SynchronizationAction.this.selectedProcess);
                SynchronizationWizard synchronizationWizard = new SynchronizationWizard(synchronizationChoices);
                WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)synchronizationWizard);
                wizardDialog.create();
                wizardDialog.open();
                if (!synchronizationChoices.isFinishPressed()) {
                    return;
                }
                HashSet hashSet = new HashSet();
                SynchronizationAction.this.addChoicesToSet(hashSet, synchronizationChoices);
                SynchronizeCommand synchronizeCommand = (SynchronizeCommand)SynchronizationAction.this.command;
                synchronizeCommand.setMethodConfiguration(synchronizationChoices.getSelectedConfig());
                synchronizeCommand.setSynchronizationFeatures(hashSet);
                SynchronizationAction.this.superRun();
            }
        });
    }

    private void addChoicesToSet(HashSet hashSet, SynchronizationChoices synchronizationChoices) {
        if (synchronizationChoices.getSyncName() == SynchronizationChoices.SYNC_FROM_CONETNT) {
            hashSet.add(UmaPackage.eINSTANCE.getNamedElement_Name());
        }
        if (synchronizationChoices.getSyncPresName() == SynchronizationChoices.SYNC_FROM_CONETNT) {
            hashSet.add(UmaPackage.eINSTANCE.getDescribableElement_PresentationName());
        }
        if (synchronizationChoices.getSyncBriefDesc() == SynchronizationChoices.SYNC_FROM_CONETNT) {
            hashSet.add(UmaPackage.eINSTANCE.getMethodElement_BriefDescription());
        }
        if (synchronizationChoices.getSyncOptInput() == SynchronizationChoices.SYNC_FROM_CONETNT) {
            hashSet.add(UmaPackage.eINSTANCE.getTask_OptionalInput());
        }
        if (synchronizationChoices.getSyncManInput() == SynchronizationChoices.SYNC_FROM_CONETNT) {
            hashSet.add(UmaPackage.eINSTANCE.getTask_MandatoryInput());
        }
        if (synchronizationChoices.getSyncOutput() == SynchronizationChoices.SYNC_FROM_CONETNT) {
            hashSet.add(UmaPackage.eINSTANCE.getTask_Output());
        }
        if (synchronizationChoices.getSyncPrimPerformer() == SynchronizationChoices.SYNC_FROM_CONETNT) {
            hashSet.add(UmaPackage.eINSTANCE.getTask_PerformedBy());
        }
        if (synchronizationChoices.getSyncAddnPerformer() == SynchronizationChoices.SYNC_FROM_CONETNT) {
            hashSet.add(UmaPackage.eINSTANCE.getTask_AdditionallyPerformedBy());
        }
        if (synchronizationChoices.getSyncRespRole() == SynchronizationChoices.SYNC_FROM_CONETNT) {
            hashSet.add(UmaPackage.eINSTANCE.getRole_ResponsibleFor());
        }
        if (synchronizationChoices.getSyncContArtifact() == SynchronizationChoices.SYNC_FROM_CONETNT) {
            hashSet.add(UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts());
        }
        if (synchronizationChoices.getSyncDelivPart() == SynchronizationChoices.SYNC_FROM_CONETNT) {
            hashSet.add(UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts());
        }
        if (synchronizationChoices.getSyncSelStep() == SynchronizationChoices.SYNC_FROM_CONETNT) {
            hashSet.add(UmaPackage.eINSTANCE.getTask_Steps());
        }
    }
}

