/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.TransientGroupItemProvider;
import org.eclipse.epf.library.edit.category.StandardCategoriesItemProvider;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MoveDialog
extends Dialog
implements ISelectionChangedListener {
    private TreeViewer treeViewer;
    private Collection elements;
    private boolean lockedUI = false;
    private ProgressMonitorPart progressMonitorPart;
    private EditingDomain editingDomain;
    private Object destination;
    private Cursor waitCursor;
    private boolean moving;

    public MoveDialog(Shell shell, Collection collection, EditingDomain editingDomain) {
        super(shell);
        this.editingDomain = editingDomain;
        this.elements = new ArrayList();
        for (Object e : collection) {
            Object object = TngUtil.unwrap(e);
            if (object instanceof MethodElement && TngUtil.isPredefined((MethodElement)((MethodElement)object))) continue;
            this.elements.add(e);
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        Label label = new Label(composite2, 0);
        label.setText(AuthoringUIResources.MoveDialog_destination_text);
        GridData gridData = new GridData(1);
        label.setLayoutData((Object)gridData);
        this.treeViewer = new TreeViewer(composite2, 2820);
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)composedAdapterFactory));
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)composedAdapterFactory));
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        GridData gridData2 = new GridData(1808);
        gridData2.widthHint = 300;
        gridData2.heightHint = 300;
        this.treeViewer.getControl().setLayoutData((Object)gridData2);
        this.treeViewer.setInput((Object)LibraryService.getInstance().getCurrentMethodLibrary());
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        this.progressMonitorPart = this.createProgressMonitorPart(composite2, gridLayout2);
        this.progressMonitorPart.setLayoutData((Object)new GridData(768));
        this.progressMonitorPart.setVisible(false);
        this.waitCursor = composite.getShell().getDisplay().getSystemCursor(1);
        return composite2;
    }

    protected ProgressMonitorPart createProgressMonitorPart(Composite composite, GridLayout gridLayout) {
        return new ProgressMonitorPart(composite, (Layout)gridLayout, -1){
            String currentTask;
            {
                this.currentTask = null;
            }

            public void setBlocked(IStatus iStatus) {
                super.setBlocked(iStatus);
                if (!MoveDialog.this.lockedUI) {
                    MoveDialog.getBlockedHandler().showBlocked(this.getShell(), (IProgressMonitor)this, iStatus, this.currentTask);
                }
            }

            public void clearBlocked() {
                super.clearBlocked();
                if (!MoveDialog.this.lockedUI) {
                    MoveDialog.getBlockedHandler().clearBlocked();
                }
            }

            public void beginTask(String string, int n) {
                super.beginTask(string, n);
                this.currentTask = string;
            }

            public void setTaskName(String string) {
                super.setTaskName(string);
                this.currentTask = string;
            }

            public void subTask(String string) {
                super.subTask(string);
                if (this.currentTask == null) {
                    this.currentTask = string;
                }
            }
        };
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(AuthoringUIResources.MoveDialog_move_text);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.destination = TngUtil.unwrap((Object)((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement());
    }

    protected void okPressed() {
        if (this.doMove()) {
            super.okPressed();
        }
    }

    private boolean isValidDestination() {
        boolean bl;
        if (this.destination instanceof ContentCategory) {
            return false;
        }
        if (this.destination instanceof StandardCategoriesItemProvider) {
            return false;
        }
        if (ViewHelper.isExtendedLocked(this.destination)) {
            return false;
        }
        if (DependencyChecker.newCheck) {
            if (this.destination instanceof VariabilityElement && !DependencyChecker.checkCircularForMovingVariabilityElement((VariabilityElement)((VariabilityElement)this.destination), (Collection)this.elements)) {
                return false;
            }
        } else if (this.destination instanceof Artifact) {
            return DependencyChecker.checkCircularForArtifacts((Artifact)((Artifact)this.destination), (Collection)this.elements);
        }
        Command command = AddCommand.create((EditingDomain)this.editingDomain, (Object)this.destination, null, (Collection)this.elements);
        try {
            bl = command.canExecute();
        }
        finally {
            command.dispose();
        }
        if (!bl) {
            return false;
        }
        if (this.destination instanceof TransientGroupItemProvider) {
            this.destination = ((TransientGroupItemProvider)this.destination).getTarget();
        }
        return true;
    }

    private boolean doMove() {
        Command command;
        if (this.destination == null) {
            String string = AuthoringUIResources.errorDialog_title;
            String string2 = AuthoringUIResources.MoveDialog_nomove_destination_problem_msg;
            String string3 = AuthoringUIResources.MoveDialog_selectdestination_text;
            MsgDialog msgDialog = AuthoringUIPlugin.getDefault().getMsgDialog();
            msgDialog.displayError(string, string2, string3);
            return false;
        }
        if (!this.isValidDestination()) {
            String string = AuthoringUIResources.errorDialog_title;
            String string4 = AuthoringUIResources.MoveDialog_invalid_move_destination_problem_msg;
            String string5 = AuthoringUIResources.MoveDialog_validdestination_text;
            MsgDialog msgDialog = AuthoringUIPlugin.getDefault().getMsgDialog();
            msgDialog.displayError(string, string4, string5);
            return false;
        }
        IStatus iStatus = UserInteractionHelper.checkModify((EObject)((EObject)this.destination), (Shell)this.getShell());
        if (!iStatus.isOK()) {
            String string = AuthoringUIResources.errorDialog_title;
            String string6 = AuthoringUIResources.MoveDialog_cannotModifyDestination;
            MsgDialog msgDialog = AuthoringUIPlugin.getDefault().getMsgDialog();
            msgDialog.displayError(string, string6, iStatus);
            return false;
        }
        this.moving = true;
        iStatus = this.getShell();
        iStatus.setCursor(this.waitCursor);
        this.getButton(0).setEnabled(false);
        this.getButton(1).setEnabled(false);
        this.treeViewer.getControl().setEnabled(false);
        this.progressMonitorPart.setVisible(true);
        this.progressMonitorPart.beginTask(AuthoringUIResources.MoveDialog_moving_text, -1);
        MethodElementAddCommand.MoveOperation moveOperation = null;
        try {
            command = AddCommand.create((EditingDomain)this.editingDomain, (Object)this.destination, null, (Collection)this.elements);
            moveOperation = new MethodElementAddCommand.MoveOperation(command, (IProgressMonitor)this.progressMonitorPart, (Shell)iStatus);
            moveOperation.run();
        }
        finally {
            this.moving = false;
            this.progressMonitorPart.done();
            if (iStatus != null && !iStatus.isDisposed()) {
                iStatus.setCursor(null);
            }
        }
        if (moveOperation != null && !(command = moveOperation.getStatus()).isOK()) {
            String string = AuthoringUIResources.dialogs_MoveDialog_errorTitle;
            String string7 = AuthoringUIResources.dialogs_MoveDialog_errorMessage;
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(string, string7, (IStatus)command);
            if (moveOperation.reloadNeeded()) {
                ViewHelper.reloadCurrentLibrary((Shell)iStatus, null);
            }
        }
        return true;
    }

    public boolean close() {
        if (this.moving) {
            return false;
        }
        return super.close();
    }
}

