/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.forms.MethodFormToolkit;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichTextEditor;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseFormPage
extends FormPage {
    public static final int ADD_BUTTON = 0;
    public static final int REMOVE_BUTTON = 1;
    public static final int UP_BUTTON = 2;
    public static final int DOWN_BUTTON = 3;
    protected static final int ORDER_BUTTON = 4;
    protected static final int SELECT_BUTTON = 5;
    protected static final int CLEAR_BUTTON = 6;
    protected static final int ATTACH_BUTTON = 7;
    protected static final int DETACH_BUTTON = 8;
    protected static final int ATTACH_URL_BUTTON = 9;
    public static final int SMALL_SIZE = 0;
    public static final int MEDIUM_SIZE = 1;
    public static final int LARGE_SIZE = 2;
    public static final int SINGLE_ROW = 3;
    protected boolean debug = AuthoringUIPlugin.getDefault().isDebugging();
    protected ScrolledForm form;
    protected FormToolkit toolkit;
    protected String editorTabName;
    protected String editorName;
    protected MethodElement methodElement;
    protected ContentElement contentElement = null;
    protected String contentElementPath;
    private int SECTION_ID;
    public static String LABEL_DECORATOR_KEY = "labelControlDecoration";

    public BaseFormPage(FormEditor formEditor, String string, String string2) {
        super(formEditor, string, string2);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        MethodElementEditorInput methodElementEditorInput = (MethodElementEditorInput)iEditorInput;
        this.methodElement = methodElementEditorInput.getMethodElement();
        MethodElement methodElement = this.methodElement instanceof ProcessComponent ? ((ProcessComponent)this.methodElement).getProcess() : this.methodElement;
        this.contentElementPath = ResourceHelper.getFolderAbsolutePath((MethodElement)methodElement);
        if (this.methodElement instanceof ContentElement) {
            this.contentElement = (ContentElement)this.methodElement;
        }
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        this.form = iManagedForm.getForm();
        this.toolkit = iManagedForm.getToolkit();
        this.form.getBody().setLayout((Layout)new TableWrapLayout());
    }

    protected void toggle(HyperlinkEvent hyperlinkEvent) {
    }

    protected void toggle(HyperlinkEvent hyperlinkEvent, int n) {
    }

    public void setEditorName(String string) {
        this.editorName = string;
    }

    public List<?> retrieveTableViewerContents(TableViewer tableViewer) {
        Object[] objectArray = ((IStructuredContentProvider)tableViewer.getContentProvider()).getElements(tableViewer.getInput());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            arrayList.add(objectArray[n]);
            ++n;
        }
        return arrayList;
    }

    protected Section createSection(FormToolkit formToolkit, Composite composite, String string, String string2) {
        Section section = formToolkit.createSection(composite, 450);
        TableWrapData tableWrapData = new TableWrapData(256);
        section.setLayoutData((Object)tableWrapData);
        section.setText(string);
        section.setDescription(string2);
        section.setLayout((Layout)new GridLayout());
        return section;
    }

    protected static Label createLabel(FormToolkit formToolkit, Composite composite, String string, int n, int n2) {
        Label label = formToolkit.createLabel(composite, string, 0x2000040);
        GridData gridData = new GridData(n);
        gridData.horizontalSpan = n2;
        gridData.verticalAlignment = 128;
        gridData.widthHint = n2 == 2 ? 115 : 100;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public static Label createLabelWithNoWrap(FormToolkit formToolkit, Composite composite, String string, int n, int n2) {
        Label label = formToolkit.createLabel(composite, string, 0x2000000);
        GridData gridData = new GridData(n);
        gridData.horizontalSpan = n2;
        gridData.verticalAlignment = 128;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected static Label createLabel(FormToolkit formToolkit, Composite composite, String string) {
        return BaseFormPage.createLabel(formToolkit, composite, string, 1, 1);
    }

    protected static Label createLabel(FormToolkit formToolkit, Composite composite, String string, int n) {
        return BaseFormPage.createLabel(formToolkit, composite, string, 1, n);
    }

    protected static Label createBlankLabel(FormToolkit formToolkit, Composite composite, int n) {
        return BaseFormPage.createLabel(formToolkit, composite, "", 768, n);
    }

    protected static Text createTextEdit(FormToolkit formToolkit, Composite composite, int n, int n2, int n3, int n4, int n5) {
        Text text = formToolkit.createText(composite, "", n);
        GridData gridData = new GridData(n2);
        gridData.heightHint = n3;
        gridData.widthHint = n4;
        gridData.horizontalSpan = n5;
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected static Text createTextEdit(FormToolkit formToolkit, Composite composite) {
        return BaseFormPage.createTextEdit(formToolkit, composite, 68, 768, -1, 100, 1);
    }

    protected static Text createTextEditWithLabel(FormToolkit formToolkit, Composite composite, int n, int n2, int n3, int n4, int n5, String string) {
        BaseFormPage.createLabel(formToolkit, composite, string);
        return BaseFormPage.createTextEdit(formToolkit, composite, n, n2, n3, n4, n5);
    }

    protected static Text createTextEditWithLabel(FormToolkit formToolkit, Composite composite, String string) {
        BaseFormPage.createLabel(formToolkit, composite, string, 2);
        return BaseFormPage.createTextEdit(formToolkit, composite);
    }

    protected static Text createTextEditWithLabel2(FormToolkit formToolkit, Composite composite, String string) {
        BaseFormPage.createLabel(formToolkit, composite, string, 2);
        return BaseFormPage.createTextEdit(formToolkit, composite, 578, 768, 40, 300, 1);
    }

    protected static Text createTextEditWithLabel3(FormToolkit formToolkit, Composite composite, String string, int n, int n2) {
        BaseFormPage.createLabel(formToolkit, composite, string, 2);
        return BaseFormPage.createTextEdit(formToolkit, composite, n2 | 0x40 | 0x200 | 0x10, 768, n, 300, 2);
    }

    protected static Text createTextEditWithLabel4(FormToolkit formToolkit, Composite composite, String string, int n, int n2, String string2) {
        BaseFormPage.createLabel(formToolkit, composite, string, 2);
        int n3 = BaseFormPage.calculateSpan(string2);
        if (n3 == 1) {
            Text text = BaseFormPage.createTextEdit(formToolkit, composite, n2 | 0x40 | 0x200 | 0x10, 768, n, 200, 1);
            Text text2 = BaseFormPage.createTextEdit(formToolkit, composite, n2 | 0x40 | 0x200, 768, n, 100, 1);
            text2.setVisible(false);
            BaseFormPage.createLabel(formToolkit, composite, "", 1);
            return text;
        }
        return BaseFormPage.createTextEdit(formToolkit, composite, n2 | 0x40 | 0x200 | 0x10, 768, n, 300, 3);
    }

    protected static Text createTextEditWithLabel5(FormToolkit formToolkit, Composite composite, String string) {
        BaseFormPage.createLabel(formToolkit, composite, string, 2);
        return BaseFormPage.createTextEdit(formToolkit, composite, 578, 768, 40, 300, 2);
    }

    protected static Text createTextEditWithLabel5(FormToolkit formToolkit, Composite composite, String string, int n, int n2) {
        BaseFormPage.createLabel(formToolkit, composite, string, 2);
        return BaseFormPage.createTextEdit(formToolkit, composite, n2 | 0x40 | 0x200 | 0x10, 768, n, 300, 3);
    }

    protected Combo createComboWithLabel3(FormToolkit formToolkit, Composite composite, String string) {
        BaseFormPage.createLabel(formToolkit, composite, string, 2);
        return this.createCombo(composite, 8388636, 768);
    }

    protected static int calculateSpan(String string) {
        int n = string.length();
        if (n < 60) {
            return 1;
        }
        return 2;
    }

    protected static Text createTextEditWithLabelLarge(FormToolkit formToolkit, Composite composite, String string) {
        Label label = BaseFormPage.createLabel(formToolkit, composite, string);
        ((GridData)label.getLayoutData()).widthHint = -1;
        return BaseFormPage.createTextEdit(formToolkit, composite, 578, 768, 80, -1, 3);
    }

    protected ImageHyperlink createImageHyperlink(FormToolkit formToolkit, Composite composite, String string, Image image) {
        ImageHyperlink imageHyperlink = formToolkit.createImageHyperlink(composite, 16512);
        GridData gridData = new GridData(1);
        gridData.verticalAlignment = 128;
        imageHyperlink.setLayoutData((Object)gridData);
        imageHyperlink.setImage(image);
        if (string != null) {
            imageHyperlink.setText(string);
        }
        return imageHyperlink;
    }

    protected ImageHyperlink createHyperLink(FormToolkit formToolkit, Composite composite, int n) {
        this.SECTION_ID = n;
        ImageHyperlink imageHyperlink = formToolkit.createImageHyperlink(composite, 0);
        imageHyperlink.setImage(AuthoringUIImages.IMG_EXPANDED);
        imageHyperlink.setUnderlined(false);
        imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                BaseFormPage.this.toggle(hyperlinkEvent, BaseFormPage.this.SECTION_ID);
            }
        });
        return imageHyperlink;
    }

    protected IMethodRichText createRichTextEdit(FormToolkit formToolkit, Composite composite, int n, int n2, int n3, int n4, int n5, Label label) {
        IMethodRichText iMethodRichText = MethodFormToolkit.createRichText(formToolkit, composite, "", n, this.contentElementPath, this.methodElement, label);
        GridData gridData = new GridData(n2);
        gridData.heightHint = n3;
        gridData.widthHint = n4;
        gridData.horizontalSpan = n5;
        iMethodRichText.setLayoutData(gridData);
        return iMethodRichText;
    }

    protected IMethodRichText createRichTextEdit(FormToolkit formToolkit, Composite composite) {
        return this.createRichTextEdit(formToolkit, composite, 578, 768, -1, -1, 1, null);
    }

    public static Label createDecoratedLabel(FormToolkit formToolkit, Composite composite, String string) {
        int n;
        Label label = BaseFormPage.createLabel(formToolkit, composite, string);
        ((GridData)label.getLayoutData()).horizontalIndent = n = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        ControlDecoration controlDecoration = new ControlDecoration((Control)label, 17408);
        label.setData(LABEL_DECORATOR_KEY, (Object)controlDecoration);
        return label;
    }

    protected IMethodRichText createRichTextEditWithLink(FormToolkit formToolkit, Composite composite, String string, int n, int n2, int n3) {
        ImageHyperlink imageHyperlink = this.createImageHyperlink(formToolkit, composite, null, AuthoringUIImages.IMG_COLLAPSED);
        imageHyperlink.setToolTipText(AuthoringUIResources.openRTE);
        Label label = BaseFormPage.createDecoratedLabel(formToolkit, composite, string);
        IMethodRichText iMethodRichText = this.createRichTextEdit(formToolkit, composite, 578, 768, n, n2, n3, label);
        imageHyperlink.setHref((Object)iMethodRichText);
        imageHyperlink.setData("Title", (Object)string);
        imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                BaseFormPage.this.toggle(hyperlinkEvent);
            }
        });
        return iMethodRichText;
    }

    protected IMethodRichText createRichTextEditWithLinkForSection(FormToolkit formToolkit, Composite composite, String string, int n, int n2, int n3) {
        final int n4 = n3;
        ImageHyperlink imageHyperlink = this.createImageHyperlink(formToolkit, composite, null, AuthoringUIImages.IMG_COLLAPSED);
        imageHyperlink.setToolTipText(AuthoringUIResources.openRTE);
        Label label = BaseFormPage.createDecoratedLabel(formToolkit, composite, string);
        IMethodRichText iMethodRichText = this.createRichTextEdit(formToolkit, composite, 578, 768, n, n2, 1, label);
        imageHyperlink.setHref((Object)iMethodRichText);
        imageHyperlink.setData("Title", (Object)string);
        imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                BaseFormPage.this.toggle(hyperlinkEvent, n4);
            }
        });
        return iMethodRichText;
    }

    protected IMethodRichTextEditor createRichTextEditor(FormToolkit formToolkit, Composite composite, int n, int n2, int n3, int n4, int n5, Label label) {
        IMethodRichTextEditor iMethodRichTextEditor = MethodFormToolkit.createRichTextEditor(formToolkit, composite, "", n, this.contentElementPath, this.methodElement, label, this.getEditor().getEditorSite());
        GridData gridData = new GridData(n2);
        gridData.heightHint = n3;
        gridData.widthHint = n4;
        gridData.horizontalSpan = n5;
        iMethodRichTextEditor.setLayoutData(gridData);
        return iMethodRichTextEditor;
    }

    protected Combo createCombo(Composite composite, int n, int n2) {
        Combo combo = new Combo(composite, n);
        return combo;
    }

    protected Combo createCombo(Composite composite) {
        return this.createCombo(composite, 0x80000C, 768);
    }

    protected Combo createCComboWithLabel(FormToolkit formToolkit, Composite composite, String string, int n, int n2) {
        BaseFormPage.createLabel(formToolkit, composite, string);
        return this.createCombo(composite, n, n2);
    }

    protected Combo createComboWithLabel(FormToolkit formToolkit, Composite composite, String string) {
        BaseFormPage.createLabel(formToolkit, composite, string);
        return this.createCombo(composite, 0x80000C, 768);
    }

    protected Composite createComposite(FormToolkit formToolkit, Section section) {
        Composite composite = formToolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(3, false));
        section.setClient((Control)composite);
        return composite;
    }

    protected static Composite createComposite(FormToolkit formToolkit, Composite composite, int n, int n2, int n3, int n4) {
        Composite composite2 = formToolkit.createComposite(composite, 0);
        GridData gridData = new GridData(n);
        gridData.verticalSpan = n2;
        gridData.horizontalSpan = n3;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)new GridLayout(n4, false));
        return composite2;
    }

    protected static Composite createComposite(FormToolkit formToolkit, Composite composite, int n) {
        return BaseFormPage.createComposite(formToolkit, composite, 1808, n, 1, 1);
    }

    protected static Composite createCompositeForButtons(FormToolkit formToolkit, Composite composite) {
        return BaseFormPage.createComposite(formToolkit, composite, 68, -1, -1, 1);
    }

    protected Composite createExpandedComposite(FormToolkit formToolkit, Composite composite) {
        Composite composite2 = formToolkit.createComposite(composite, 0);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setVisible(false);
        return composite2;
    }

    protected static Table createTable(FormToolkit formToolkit, Composite composite, int n, int n2, int n3, int n4, int n5, int n6) {
        Table table = formToolkit.createTable(composite, n);
        GridData gridData = new GridData(n2);
        gridData.heightHint = n3;
        gridData.widthHint = n4;
        gridData.verticalSpan = n5;
        gridData.horizontalSpan = n6;
        table.setLayoutData((Object)gridData);
        return table;
    }

    protected static Table createTable(FormToolkit formToolkit, Composite composite, int n) {
        switch (n) {
            case 0: {
                return BaseFormPage.createTable(formToolkit, composite, 2, 1808, 56, 200, 1, 1);
            }
            case 1: {
                return BaseFormPage.createTable(formToolkit, composite, 2, 1808, 112, 200, 1, 1);
            }
            case 2: {
                return BaseFormPage.createTable(formToolkit, composite, 2, 1808, 200, 200, 1, 1);
            }
            case 3: {
                return BaseFormPage.createTable(formToolkit, composite, 2, 768, 20, 200, 1, 1);
            }
        }
        throw new IllegalArgumentException();
    }

    protected static Button createButton(FormToolkit formToolkit, Composite composite, int n) {
        Button button;
        switch (n) {
            case 0: {
                button = formToolkit.createButton(composite, AuthoringUIText.ADD_BUTTON_TEXT, 0);
                break;
            }
            case 1: {
                button = formToolkit.createButton(composite, AuthoringUIText.REMOVE_BUTTON_TEXT, 0);
                break;
            }
            case 2: {
                button = formToolkit.createButton(composite, AuthoringUIText.UP_BUTTON_TEXT, 0);
                break;
            }
            case 3: {
                button = formToolkit.createButton(composite, AuthoringUIText.DOWN_BUTTON_TEXT, 0);
                break;
            }
            case 4: {
                button = formToolkit.createButton(composite, AuthoringUIText.ORDER_BUTTON_TEXT, 0);
                break;
            }
            case 5: {
                button = formToolkit.createButton(composite, AuthoringUIText.SELECT_BUTTON_TEXT, 0);
                break;
            }
            case 6: {
                button = formToolkit.createButton(composite, AuthoringUIText.CLEAR_BUTTON_TEXT, 0);
                break;
            }
            case 7: {
                button = formToolkit.createButton(composite, AuthoringUIText.ATTACH_BUTTON_TEXT, 0);
                break;
            }
            case 9: {
                button = formToolkit.createButton(composite, AuthoringUIText.ATTACH_URL_BUTTON_TEXT, 0);
                break;
            }
            case 8: {
                button = formToolkit.createButton(composite, AuthoringUIText.DETACH_BUTTON_TEXT, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        button.setLayoutData((Object)new GridData(768));
        button.setEnabled(false);
        return button;
    }

    public int getRichTextEditorHeight() {
        return this.form.getBounds().height - 96;
    }

    public int getRichTextEditorWidth() {
        return this.form.getBounds().width - 64;
    }
}

