/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.UIActionDispatcher;
import org.eclipse.epf.authoring.ui.actions.ILibraryActionBarContributor;
import org.eclipse.epf.authoring.ui.views.SaveableLibraryViewPart;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.library.ui.LibraryUIUtil;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public abstract class AbstractBaseView
extends SaveableLibraryViewPart
implements IEditingDomainProvider,
ISelectionProvider,
ILibraryServiceListener,
IMenuListener,
IViewerProvider,
IGotoMarker {
    protected AdapterFactoryEditingDomain editingDomain;
    protected PropertySheetPage propertySheetPage;
    protected UIActionDispatcher actionDispatcher = null;
    protected AdapterFactory adapterFactory;
    protected ILibraryActionBarContributor actionBarContributor;
    protected ISelectionChangedListener selectionChangedListener;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart == AbstractBaseView.this) {
                AbstractBaseView.this.handleActivate(iWorkbenchPart);
            }
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }
    };
    private IWindowListener windowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow iWorkbenchWindow) {
        }

        public void windowClosed(IWorkbenchWindow iWorkbenchWindow) {
        }

        public void windowDeactivated(IWorkbenchWindow iWorkbenchWindow) {
        }

        public void windowOpened(IWorkbenchWindow iWorkbenchWindow) {
            iWorkbenchWindow.getWorkbench().removeWindowListener((IWindowListener)this);
            boolean bl = AbstractBaseView.this.getSite().getPage().isPartVisible((IWorkbenchPart)AbstractBaseView.this);
            if (bl) {
                LibraryUIManager.getInstance().startupOpenLibrary();
            } else {
                LibraryUIManager.getInstance().addMethodViewPartListener(AbstractBaseView.this.getViewId());
            }
        }
    };

    protected void handleActivate(IWorkbenchPart iWorkbenchPart) {
        this.editingDomain.setAdapterFactory(this.adapterFactory);
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
    }

    protected boolean handleDirtyConflict() {
        String string = AuthoringUIResources._UI_FileConflict_label;
        String string2 = AuthoringUIResources._WARN_FileConflict;
        return AuthoringUIPlugin.getDefault().getMsgDialog().displayPrompt(string, string2);
    }

    protected void handleChangedResources() {
    }

    public void createPartControl(Composite composite) {
        IWorkbench iWorkbench;
        this.init();
        this.actionDispatcher = new UIActionDispatcher((Object)this);
        this.createViewer(composite);
        try {
            this.actionBarContributor = this.createActionBarContributor();
            this.actionBarContributor.init(this.getViewSite().getActionBars(), this.getSite().getPage());
        }
        catch (Exception exception) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
        Viewer viewer = this.getViewer();
        if (viewer != null) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        AbstractBaseView.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            viewer.addSelectionChangedListener(this.selectionChangedListener);
        }
        LibraryService.getInstance().addListener((ILibraryServiceListener)this);
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        if (methodLibrary != null) {
            this.setInputForViewer(methodLibrary);
            LibraryUIUtil.updateShellTitle();
        }
        if ((iWorkbench = AuthoringUIPlugin.getDefault().getWorkbench()) != null) {
            iWorkbench.addWindowListener(this.windowListener);
        }
    }

    private void init() {
        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
        if (iLibraryManager != null) {
            this.editingDomain = iLibraryManager.getEditingDomain();
            this.adapterFactory = (ComposedAdapterFactory)this.editingDomain.getAdapterFactory();
        }
        IViewSite iViewSite = (IViewSite)this.getSite();
        iViewSite.setSelectionProvider((ISelectionProvider)this);
        iViewSite.getPage().addPartListener(this.partListener);
    }

    public void createContextMenuFor(StructuredViewer structuredViewer) {
        MenuManager menuManager = new MenuManager("#PopUp");
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu menu = menuManager.createContextMenu(structuredViewer.getControl());
        structuredViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)structuredViewer);
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        try {
            this.actionBarContributor.setActiveView((IViewPart)this);
            this.actionBarContributor.menuAboutToShow(iMenuManager);
        }
        catch (RuntimeException runtimeException) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)runtimeException);
            throw runtimeException;
        }
    }

    public void setFocus() {
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.actionDispatcher.addSelectionChangedListener(iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.actionDispatcher.removeSelectionChangedListener(iSelectionChangedListener);
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(clazz);
    }

    public ISelection getSelection() {
        return this.actionDispatcher.getSelection();
    }

    public void setSelection(ISelection iSelection) {
        this.setSelection(this, iSelection);
    }

    private void setSelection(ISelectionProvider iSelectionProvider, ISelection iSelection) {
        this.actionDispatcher.setSelection(iSelectionProvider, iSelection);
        UIActionDispatcher.getInstance().setSelection(iSelectionProvider, iSelection);
    }

    public void libraryCreated(MethodLibrary methodLibrary) {
    }

    public void libraryOpened(MethodLibrary methodLibrary) {
    }

    public void libraryReopened(MethodLibrary methodLibrary) {
    }

    public void libraryClosed(MethodLibrary methodLibrary) {
        this.setInputForViewer(null);
        if (this.adapterFactory instanceof ComposedAdapterFactory) {
            ((ComposedAdapterFactory)this.adapterFactory).dispose();
        }
    }

    public void librarySet(MethodLibrary methodLibrary) {
        this.setInputForViewer(methodLibrary);
        if (methodLibrary != null) {
            this.actionBarContributor.setActiveView((IViewPart)this);
        }
    }

    public void configurationSet(MethodConfiguration methodConfiguration) {
    }

    public void dispose() {
        IWorkbench iWorkbench;
        this.getSite().getPage().removePartListener(this.partListener);
        if (this.adapterFactory instanceof ComposedAdapterFactory) {
            ((ComposedAdapterFactory)this.adapterFactory).dispose();
        }
        if (this.actionBarContributor.getActiveView() == this) {
            this.actionBarContributor.setActiveView(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if ((iWorkbench = AuthoringUIPlugin.getDefault().getWorkbench()) != null) {
            iWorkbench.removeWindowListener(this.windowListener);
        }
        LibraryService.getInstance().removeListener((ILibraryServiceListener)this);
        super.dispose();
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new PropertySheetPage(){

                public void makeContributions(IMenuManager iMenuManager, IToolBarManager iToolBarManager, IStatusLineManager iStatusLineManager) {
                    super.makeContributions(iMenuManager, iToolBarManager, iStatusLineManager);
                }

                public void setActionBars(IActionBars iActionBars) {
                    super.setActionBars(iActionBars);
                    if (AbstractBaseView.this.actionBarContributor != null) {
                        AbstractBaseView.this.actionBarContributor.shareGlobalActions((IPage)this, iActionBars);
                    }
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider(this.adapterFactory));
        }
        return this.propertySheetPage;
    }

    public void gotoMarker(IMarker iMarker) {
        try {
            String string;
            if (iMarker.getType().equals("org.eclipse.emf.ecore.diagnostic") && (string = iMarker.getAttribute("uri", null)) != null) {
                URI uRI = URI.createURI((String)string);
                EObject eObject = this.editingDomain.getResourceSet().getEObject(uRI, true);
                if (eObject != null) {
                    this.setSelectionToViewer(Collections.singleton(this.editingDomain.getWrapper((Object)eObject)));
                }
            }
        }
        catch (CoreException coreException) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)coreException);
        }
    }

    public void setSelectionToViewer(Collection collection) {
        final Collection collection2 = collection;
        if (collection2 != null && !collection2.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    Viewer viewer = AbstractBaseView.this.getViewer();
                    if (viewer != null) {
                        viewer.setSelection((ISelection)new StructuredSelection(collection2.toArray()), true);
                    }
                }
            };
            runnable.run();
        }
    }

    public AdapterFactoryContentProvider getContentProvider() {
        return new AdapterFactoryContentProvider(this.adapterFactory);
    }

    public abstract Viewer getViewer();

    public abstract void createViewer(Composite var1);

    public abstract ILibraryActionBarContributor createActionBarContributor();

    public abstract void setInputForViewer(Object var1);

    public abstract String getViewId();
}

