/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import org.eclipse.epf.authoring.ui.celleditors.AbstractCheckBoxCellEditor;
import org.eclipse.epf.authoring.ui.views.ProcessTreeViewer;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ProcessViewer
extends ProcessTreeViewer {
    private String[] columnProperties;
    private AbstractCheckBoxCellEditor[] checkBoxCellEditors = null;

    public ProcessViewer(Composite composite, int n) {
        super(composite, n);
    }

    public Composite getCellEditorParent() {
        return this.getTree();
    }

    public void setCheckBoxCellEditors(AbstractCheckBoxCellEditor[] abstractCheckBoxCellEditorArray) {
        this.checkBoxCellEditors = abstractCheckBoxCellEditorArray;
        int n = 0;
        while (n < abstractCheckBoxCellEditorArray.length) {
            AbstractCheckBoxCellEditor abstractCheckBoxCellEditor = abstractCheckBoxCellEditorArray[n];
            if (abstractCheckBoxCellEditor != null) {
                abstractCheckBoxCellEditor.setColumnIndex(n);
            }
            ++n;
        }
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        this.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                ProcessViewer.this.modifyItem(mouseEvent);
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 42: {
                        Image image = ProcessViewer.this.getCheckBoxCellEditorImage(event);
                        if (image == null) {
                            return;
                        }
                        TreeColumn treeColumn = ProcessViewer.this.getTree().getColumn(event.index);
                        int n = event.x + treeColumn.getWidth() / 2;
                        Rectangle rectangle = image.getBounds();
                        int n2 = Math.max(0, (event.height - rectangle.height) / 2);
                        event.gc.drawImage(image, n - rectangle.width / 2, event.y + n2);
                    }
                }
            }
        };
        this.getTree().addListener(42, listener);
    }

    protected void doUpdateItem(Item item, Object object) {
        super.doUpdateItem(item, object);
        if (this.checkBoxCellEditors != null && this.columnProperties != null && this.columnProperties.length > 0) {
            int n = 0;
            while (n < this.checkBoxCellEditors.length) {
                AbstractCheckBoxCellEditor abstractCheckBoxCellEditor = this.checkBoxCellEditors[n];
                if (abstractCheckBoxCellEditor != null) {
                    ((TreeItem)item).setText(n, "");
                }
                ++n;
            }
        }
    }

    private Image getCheckBoxCellEditorImage(Event event) {
        return this.getCheckBoxCellEditorImage(event.index, (TreeItem)event.item);
    }

    private Image getCheckBoxCellEditorImage(int n, TreeItem treeItem) {
        if (this.checkBoxCellEditors == null || this.checkBoxCellEditors[n] == null) {
            return null;
        }
        return this.checkBoxCellEditors[n].getImage(treeItem, this.columnProperties[n]);
    }

    public void setCellModifier(ICellModifier iCellModifier) {
        super.setCellModifier(iCellModifier);
        if (this.checkBoxCellEditors != null) {
            int n = 0;
            while (n < this.checkBoxCellEditors.length) {
                AbstractCheckBoxCellEditor abstractCheckBoxCellEditor = this.checkBoxCellEditors[n];
                if (abstractCheckBoxCellEditor != null) {
                    abstractCheckBoxCellEditor.setCellModifier(iCellModifier);
                }
                ++n;
            }
        }
    }

    private void modifyItem(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.x, mouseEvent.y);
        TreeItem treeItem = this.getTree().getItem(point);
        if (treeItem == null) {
            return;
        }
        int n = 0;
        while (n < this.getTree().getColumnCount()) {
            Rectangle rectangle = treeItem.getBounds(n);
            if (rectangle.contains(point)) {
                Image image = this.getCheckBoxCellEditorImage(n, treeItem);
                if (image == null) {
                    return;
                }
                Rectangle rectangle2 = image.getBounds();
                int n2 = rectangle.x + rectangle.width / 2 - rectangle2.width / 2;
                int n3 = Math.max(0, (rectangle.height - rectangle2.height) / 2);
                int n4 = rectangle.y + n3;
                rectangle2 = new Rectangle(n2, n4, rectangle2.width, rectangle2.height);
                if (rectangle2.contains(point)) {
                    this.checkBoxCellEditors[n].modify(treeItem, this.columnProperties[n]);
                    return;
                }
            }
            ++n;
        }
    }

    public void setColumnProperties(String[] stringArray) {
        super.setColumnProperties(stringArray);
        this.columnProperties = stringArray;
    }
}

