/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.wizards.NewConfigurationMainPage;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.ui.actions.LibraryLockingOperationRunner;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.ui.wizards.BaseWizard;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewConfigurationWizard
extends BaseWizard
implements INewWizard {
    public static final String WIZARD_ID = NewConfigurationWizard.class.getName();
    public static final String WIZARD_EXTENSION_POINT_ID = "org.eclipse.epf.authoring.ui.newConfigurationWizard";
    protected NewConfigurationMainPage mainPage;
    protected MethodConfiguration config;

    public String getWizardExtenderExtensionPointId() {
        return WIZARD_EXTENSION_POINT_ID;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super.init(iWorkbench, iStructuredSelection);
        this.setWindowTitle(AuthoringUIResources.newConfigurationWizard_title);
    }

    public void addPages() {
        if (this.wizardExtender == null) {
            this.mainPage = this.createMainPage();
            super.addPage((IWizardPage)this.mainPage);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            IWizardPage iWizardPage = this.wizardExtender.getReplaceWizardPage(NewConfigurationMainPage.PAGE_NAME);
            if (iWizardPage != null) {
                arrayList.add(iWizardPage);
            } else {
                this.mainPage = this.createMainPage();
                arrayList.add((Object)this.mainPage);
            }
            super.getNewWizardPages(arrayList);
            for (IWizardPage iWizardPage2 : arrayList) {
                super.addPage(iWizardPage2);
            }
            this.wizardExtender.initWizardPages(arrayList);
        }
    }

    protected NewConfigurationMainPage createMainPage() {
        return new NewConfigurationMainPage();
    }

    public void createPageControls(Composite composite) {
        super.createPageControls(composite);
        composite.getShell().setImage(AuthoringUIPlugin.getDefault().getSharedImage("full/obj16/MethodConfiguration.gif"));
    }

    public void setMethodConfiguration(MethodConfiguration methodConfiguration) {
        this.config = methodConfiguration;
    }

    public boolean doFinish() {
        boolean bl = this.createMethodConfiguration(this.mainPage.getConfigurationName(), this.mainPage.getBriefDescription(), (WizardPage)this.mainPage);
        if (bl) {
            MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
            ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
            try {
                failSafeMethodLibraryPersister.save(methodLibrary.eResource());
                failSafeMethodLibraryPersister.commit();
            }
            catch (Exception exception) {
                try {
                    failSafeMethodLibraryPersister.rollback();
                }
                catch (Exception exception2) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception2);
                }
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.newConfigurationWizard_title, AuthoringUIResources.internalError_msg, (Throwable)exception);
            }
        }
        return bl;
    }

    public boolean createMethodConfiguration(String string, String string2, WizardPage wizardPage) {
        MethodLibrary methodLibrary;
        block6: {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException();
            }
            methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
            MethodConfiguration methodConfiguration = this.config == null ? UmaFactory.eINSTANCE.createMethodConfiguration() : this.config;
            methodConfiguration.setName(string);
            if (this.nameCheck(string, wizardPage, methodLibrary, methodConfiguration)) break block6;
            return false;
        }
        try {
            if (this.config == null) {
                this.config = LibraryService.getInstance().createMethodConfiguration(string, methodLibrary);
            }
            if (string2 != null) {
                this.config.setBriefDescription(string2);
            }
        }
        catch (Exception exception) {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.newConfigurationWizard_title, AuthoringUIResources.internalError_msg, (Throwable)exception);
        }
        return true;
    }

    private boolean nameCheck(String string, WizardPage wizardPage, MethodLibrary methodLibrary, MethodConfiguration methodConfiguration) {
        String string2 = null;
        if (string.indexOf("&") > -1) {
            string2 = NLS.bind((String)LibraryEditResources.invalidElementNameError4_msg, (Object)string);
        } else {
            IValidator iValidator = IValidatorFactory.INSTANCE.createNameValidator((Object)methodLibrary, (NamedElement)methodConfiguration);
            string2 = iValidator.isValid(string);
        }
        if (string2 != null) {
            wizardPage.setErrorMessage(string2);
            return false;
        }
        return true;
    }

    public MethodConfiguration getMethodConfiguration() {
        return this.config;
    }

    private boolean superPerformFinish() {
        return super.performFinish();
    }

    public boolean performFinish() {
        final boolean[] blArray = new boolean[1];
        LibraryLockingOperationRunner libraryLockingOperationRunner = new LibraryLockingOperationRunner();
        libraryLockingOperationRunner.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                blArray[0] = NewConfigurationWizard.this.superPerformFinish();
            }
        });
        return blArray[0];
    }
}

