/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.xmi.internal.migration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.model.util.GraphicalDataManager;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.LinkInfo;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.library.xmi.XMILibraryPlugin;
import org.eclipse.epf.library.xmi.XMILibraryResources;
import org.eclipse.epf.library.xmi.internal.migration.MigrationUtil;
import org.eclipse.epf.library.xmi.internal.migration.Migrator102_103;
import org.eclipse.epf.library.xmi.internal.migration.SelectionDialog;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.migration.MigrationResourceHandler;
import org.eclipse.epf.persistence.migration.MigratorImpl;
import org.eclipse.epf.persistence.migration.UpgradeCallerInfo;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Diagram;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Property;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.SemanticModelBridge;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UMASemanticModelBridge;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class Migrator102
extends MigratorImpl {
    private static final boolean DEBUG = XMILibraryPlugin.getDefault().isDebugging();
    private Collection proxiesToRemove = new ArrayList();
    private Map proxyToFileMap = new HashMap();
    private HashMap proxyToFileWithLoadErrorMap = new HashMap();
    private ArrayList notFoundProxies = new ArrayList();
    private ArrayList proxiesWithUnnormalizedURI = new ArrayList();
    private MethodLibrary lib;
    private MigrationResourceHandler resourceHandler = new MigrationResourceHandler(){

        protected boolean handleUnknownFeature(EObject eObject, EStructuralFeature eStructuralFeature, Object object) {
            if (eObject instanceof RoleDescriptor && "performsAsOwner".equals(eStructuralFeature.getName()) && object != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer((String)object);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                if (arrayList.size() > 1) {
                    Activity activity = ((RoleDescriptor)eObject).getSuperActivities();
                    Diagram diagram = GraphicalDataManager.getInstance().getUMADiagram(activity, 2, false);
                    if (diagram != null) {
                        Object object2;
                        HashMap<String, GraphNode> hashMap = new HashMap<String, GraphNode>();
                        int n = diagram.getContained().size();
                        int n2 = 0;
                        while (n2 < n) {
                            List list;
                            Property property;
                            MethodElement methodElement;
                            SemanticModelBridge semanticModelBridge;
                            Object e = diagram.getContained().get(n2);
                            if (e instanceof GraphNode && (semanticModelBridge = (object2 = (GraphNode)e).getSemanticModel()) instanceof UMASemanticModelBridge && (methodElement = ((UMASemanticModelBridge)semanticModelBridge).getElement()) instanceof TaskDescriptor && (property = GraphicalDataHelper.getPropertyByKey((List)(list = object2.getList(10)), (String)"wpCompositeType")) == null) {
                                hashMap.put(methodElement.getGuid(), (GraphNode)object2);
                            }
                            ++n2;
                        }
                        ArrayList<GraphNode> arrayList2 = new ArrayList<GraphNode>();
                        int n3 = 0;
                        while (n3 < arrayList.size()) {
                            object2 = hashMap.get(arrayList.get(n3));
                            if (object2 != null) {
                                arrayList2.add((GraphNode)object2);
                            }
                            ++n3;
                        }
                        diagram.getContained().removeAll(arrayList2);
                        diagram.getContained().addAll(arrayList2);
                    }
                }
            }
            return true;
        }
    };
    private static final String FILE_PATH = XMILibraryResources.filePath;

    private static void updateStatus(IProgressMonitor iProgressMonitor, String string) {
        if (iProgressMonitor != null) {
            iProgressMonitor.subTask(string);
            iProgressMonitor.worked(1);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            System.out.println(string);
        }
    }

    public void migrate(String string, IProgressMonitor iProgressMonitor) throws Exception {
        this.migrate(string, iProgressMonitor, null);
    }

    public void migrate(String string, IProgressMonitor iProgressMonitor, UpgradeCallerInfo upgradeCallerInfo) throws Exception {
        this.initMigrate();
        File file = new File(string);
        boolean bl = true;
        if (upgradeCallerInfo != null && upgradeCallerInfo.getIsExportedPluginLib()) {
            bl = false;
        }
        ResourceUtil.open((String)file.getParent(), (IProgressMonitor)iProgressMonitor);
        MultiFileResourceSetImpl multiFileResourceSetImpl = null;
        try {
            Object object;
            Display display;
            this.setOldDefaultValues();
            Migrator102.updateStatus(iProgressMonitor, PersistenceResources.loadLibraryTask_name);
            multiFileResourceSetImpl = bl ? new MultiFileResourceSetImpl(false) : Migrator102.getImportPluginResourceSet();
            multiFileResourceSetImpl.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            multiFileResourceSetImpl.getLoadOptions().put("RESOURCE_HANDLER", this.resourceHandler);
            this.lib = multiFileResourceSetImpl.loadLibrary(string);
            this.removeProcessContributions(iProgressMonitor);
            if (bl) {
                display = Display.getDefault();
                if (display == null || display.getThread() == Thread.currentThread()) {
                    this.verify();
                } else {
                    display.syncExec(new Runnable(){

                        public void run() {
                            Migrator102.this.verify();
                        }
                    });
                }
                this.removeUnresolvedReferences(iProgressMonitor);
            }
            if (this instanceof Migrator102_103) {
                LinkInfo.setLibrary((MethodLibrary)this.lib);
            }
            Migrator102.updateStatus(iProgressMonitor, PersistenceResources.loadResourcesTask_name);
            display = this.lib.eAllContents();
            while (display.hasNext()) {
                block17: {
                    object = (EObject)display.next();
                    if (!(object instanceof MethodElement)) continue;
                    try {
                        Iterator iterator = object.eCrossReferences().iterator();
                        while (iterator.hasNext()) {
                            iterator.next();
                        }
                    }
                    catch (Exception exception) {
                        CommonPlugin.INSTANCE.log((Object)exception);
                        if (!DEBUG) break block17;
                        System.err.println("Error iterate thru cross references of element: " + object);
                    }
                }
                this.update((MethodElement)object, iProgressMonitor);
            }
            this.removeOldDefaultValues();
            display = Display.getDefault();
            if (display == null || display.getThread() == Thread.currentThread()) {
                this.checkModifiedResources();
            } else {
                display.syncExec(new Runnable(){

                    public void run() {
                        Migrator102.this.checkModifiedResources();
                    }
                });
            }
            Migrator102.updateStatus(iProgressMonitor, PersistenceResources.saveLibraryTask_name);
            object = multiFileResourceSetImpl.getDefaultSaveOptions();
            if (bl) {
                object.put("DISCARD_UNRESOLVED_REFERENCES", Boolean.TRUE);
            }
            multiFileResourceSetImpl.save((Map)object, true);
            Migrator102.updateStatus(iProgressMonitor, PersistenceResources.refreshLibraryFilesTask_name);
            ResourceUtil.refreshResources((MethodLibrary)this.lib, (IProgressMonitor)iProgressMonitor);
            this.migrateDiagram(iProgressMonitor);
        }
        finally {
            if (this instanceof Migrator102_103) {
                LinkInfo.setLibrary(null);
            }
            if (multiFileResourceSetImpl != null) {
                multiFileResourceSetImpl.reset();
                multiFileResourceSetImpl = null;
            }
        }
    }

    protected static MultiFileResourceSetImpl getImportPluginResourceSet() {
        MultiFileResourceSetImpl multiFileResourceSetImpl = new MultiFileResourceSetImpl(false){

            protected void demandLoad(Resource resource) throws IOException {
                if (!this.skipDemandLoad(resource)) {
                    super.demandLoad(resource);
                }
            }

            private boolean skipDemandLoad(Resource resource) {
                File file = new File(resource.getURI().toFileString());
                return !file.exists() && file.getName().equals("plugin.xmi");
            }
        };
        return multiFileResourceSetImpl;
    }

    private void removeProcessContributions(IProgressMonitor iProgressMonitor) {
        for (MethodPlugin methodPlugin : this.lib.getMethodPlugins()) {
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.processContributionPath);
            if (methodPackage == null) continue;
            for (MethodPackage methodPackage2 : new ArrayList(methodPackage.getChildPackages())) {
                ResourceSet resourceSet;
                Resource.Internal internal;
                block4: {
                    internal = ((InternalEObject)methodPackage2).eDirectResource();
                    if (internal == null) continue;
                    resourceSet = internal.getResourceSet();
                    try {
                        MethodLibraryPersister.INSTANCE.delete((MethodElement)methodPackage);
                    }
                    catch (Exception exception) {
                        if (!DEBUG) break block4;
                        exception.printStackTrace();
                    }
                }
                if (resourceSet == null) continue;
                resourceSet.getResources().remove((Object)internal);
            }
            methodPackage.getChildPackages().clear();
        }
    }

    private void checkModifiedResources() {
        block2: {
            MultiStatus multiStatus;
            Object object3;
            String string;
            Object object2;
            do {
                ResourceSet resourceSet = this.lib.eResource().getResourceSet();
                ArrayList<Resource> arrayList = new ArrayList<Resource>();
                String string2 = XMILibraryPlugin.getDefault().getId();
                multiStatus = new MultiStatus(string2, 0, XMILibraryResources.cannotWriteToFiles, null);
                for (Object object3 : resourceSet.getResources()) {
                    object2 = new File(object3.getURI().toFileString());
                    if (!((File)object2).exists() || ((File)object2).canWrite()) continue;
                    arrayList.add((Resource)object3);
                    multiStatus.add((IStatus)new Status(4, string2, 0, ((File)object2).toString(), null));
                }
                if (multiStatus.isOK()) break block2;
                string = XMILibraryResources.readOnlyFiles_title;
                object3 = XMILibraryResources.readOnlyFiles_msg;
            } while ((object2 = new ErrorDialog(MsgBox.getDefaultShell(), string, (String)object3, (IStatus)multiStatus, 7){

                protected void createButtonsForButtonBar(Composite composite) {
                    this.createButton(composite, 0, IDialogConstants.RETRY_LABEL, true);
                    this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
                    this.createDetailsButton(composite);
                }

                public int open() {
                    this.showDetailsArea();
                    return super.open();
                }
            }).open() != 1);
            throw new OperationCanceledException();
        }
    }

    private void removeUnresolvedReferences(IProgressMonitor iProgressMonitor) {
        if (this.proxiesToRemove.isEmpty()) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (InternalEObject internalEObject : this.proxiesToRemove) {
            hashSet.add(internalEObject.eProxyURI().fragment());
            EcoreUtil.remove((EObject)internalEObject);
        }
        TreeIterator treeIterator = this.lib.eAllContents();
        while (treeIterator.hasNext()) {
            InternalEObject internalEObject;
            internalEObject = (EObject)treeIterator.next();
            EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)internalEObject.eCrossReferences().iterator();
            while (featureIterator.hasNext()) {
                EStructuralFeature eStructuralFeature;
                InternalEObject internalEObject2 = (InternalEObject)featureIterator.next();
                if (!internalEObject2.eIsProxy() || !hashSet.contains(internalEObject2.eProxyURI().fragment()) || !(eStructuralFeature = featureIterator.feature()).isChangeable() || eStructuralFeature.isDerived()) continue;
                if (eStructuralFeature.isMany()) {
                    ((List)internalEObject.eGet(eStructuralFeature)).remove(internalEObject2);
                    continue;
                }
                internalEObject.eSet(eStructuralFeature, null);
            }
        }
    }

    private void verify() {
        Iterator iterator;
        Object object;
        Object[] objectArray;
        Object object2;
        Object object32;
        Object object4;
        Object object5;
        this.notFoundProxies.clear();
        this.proxiesToRemove.clear();
        this.proxyToFileMap.clear();
        this.proxyToFileWithLoadErrorMap.clear();
        this.proxiesWithUnnormalizedURI.clear();
        Collection collection = PersistenceUtil.getProxies((EObject)this.lib);
        if (!collection.isEmpty()) {
            object5 = this.lib.eResource().getResourceSet();
            object4 = object5.getURIConverter();
            for (Object object32 : collection) {
                object2 = object32.eProxyURI();
                objectArray = object4.normalize((URI)object2);
                if (objectArray == null) {
                    this.proxiesWithUnnormalizedURI.add(object32);
                    continue;
                }
                object = new File(objectArray.toFileString());
                if (!((File)object).exists()) {
                    this.proxyToFileMap.put(object32, object);
                    continue;
                }
                try {
                    Resource resource = object5.getResource(objectArray.trimFragment(), true);
                    if (resource.getEObject(objectArray.fragment()) != null) continue;
                    this.notFoundProxies.add(object32);
                }
                catch (Exception exception) {
                    String string = exception.getMessage() != null ? exception.getMessage() : exception.toString();
                    this.proxyToFileWithLoadErrorMap.put(object32, new Object[]{object, string});
                }
            }
        }
        if (!this.proxyToFileMap.isEmpty()) {
            object5 = new ArrayList(this.proxyToFileMap.keySet());
            object4 = XMILibraryResources.elementPath;
            iterator = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

                public String getText(Object object) {
                    File file = (File)Migrator102.this.proxyToFileMap.get(object);
                    return String.valueOf(file.getAbsolutePath()) + " (" + TngUtil.getLabelWithPath((Object)object) + ')';
                }

                public String getColumnText(Object object, int n) {
                    switch (n) {
                        case 0: {
                            return Migrator102.this.proxyToFileMap.get(object).toString();
                        }
                        case 1: {
                            return TngUtil.getLabelWithPath((Object)object);
                        }
                    }
                    return null;
                }
            };
            try {
                object32 = XMILibraryResources.promptRemoveReferencesToMissingFiles_msg;
                object2 = new SelectionDialog(MsgBox.getDefaultShell(), (List)object5, (ILabelProvider)iterator, (String)object32);
                object2.setTitle(XMILibraryResources.missingFiles_title);
                object2.setBlockOnOpen(true);
                object2.setInitialElementSelections((List)object5);
                ((SelectionDialog)((Object)object2)).setColumnProperties(new String[]{FILE_PATH, object4});
                if (object2.open() == 1) {
                    throw new OperationCanceledException();
                }
                objectArray = object2.getResult();
                if (objectArray == null) {
                    throw new OperationCanceledException();
                }
                object = object5.iterator();
                while (object.hasNext()) {
                    this.proxiesToRemove.add(object.next());
                }
            }
            finally {
                iterator.dispose();
            }
        }
        if (!this.proxyToFileWithLoadErrorMap.isEmpty()) {
            object5 = new ArrayList(this.proxyToFileWithLoadErrorMap.keySet());
            object4 = XMILibraryResources.loadError;
            iterator = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

                public String getColumnText(Object object, int n) {
                    Object[] objectArray = (Object[])Migrator102.this.proxyToFileMap.get(object);
                    if (n < 2) {
                        return objectArray[n].toString();
                    }
                    return null;
                }
            };
            try {
                object32 = XMILibraryResources.promptRemoveReferencesToFilesWithLoadErrors_msg;
                object2 = new SelectionDialog(MsgBox.getDefaultShell(), (List)object5, (ILabelProvider)iterator, (String)object32);
                object2.setTitle(XMILibraryResources.filesWithLoadErrors_title);
                object2.setBlockOnOpen(true);
                object2.setInitialElementSelections((List)object5);
                ((SelectionDialog)((Object)object2)).setColumnProperties(new String[]{FILE_PATH, object4});
                if (object2.open() == 1) {
                    throw new OperationCanceledException();
                }
                objectArray = object2.getResult();
                if (objectArray == null) {
                    throw new OperationCanceledException();
                }
                object = object5.iterator();
                while (object.hasNext()) {
                    this.proxiesToRemove.add(object.next());
                }
            }
            finally {
                iterator.dispose();
            }
        }
        object5 = new ArrayList();
        collection.addAll(this.proxyToFileMap.keySet());
        collection.addAll(this.proxyToFileWithLoadErrorMap.keySet());
        collection.removeAll(this.proxiesToRemove);
        if (((ArrayList)object5).isEmpty()) {
            this.proxiesToRemove.addAll(this.notFoundProxies);
            this.proxiesToRemove.addAll(this.proxiesWithUnnormalizedURI);
        }
        object4 = "Summary of unresolved proxies:";
        object4 = String.valueOf(object4) + "\n  Not found proxies: " + this.notFoundProxies;
        object4 = String.valueOf(object4) + "\n  Proxies with unnormalized URI: " + this.proxiesWithUnnormalizedURI;
        XMILibraryPlugin.getDefault().getLogger().logInfo((String)object4);
    }

    private void removeOldDefaultValues() {
        MultiResourceEObject.removeDefaultValue((EStructuralFeature)UmaPackage.eINSTANCE.getMethodPlugin_UserChangeable());
    }

    private void adjustToNewDefaultValues(MethodElement methodElement) {
        if (methodElement instanceof MethodPlugin) {
            ((MultiResourceEObject)methodElement).removeFeatureWithOverridenDefaultValue((EStructuralFeature)UmaPackage.eINSTANCE.getMethodPlugin_UserChangeable());
        }
    }

    private void setOldDefaultValues() {
        MultiResourceEObject.setDefaultValue((EStructuralFeature)UmaPackage.eINSTANCE.getMethodPlugin_UserChangeable(), (Object)Boolean.FALSE);
    }

    protected void update(MethodElement methodElement, IProgressMonitor iProgressMonitor) throws Exception {
        this.adjustToNewDefaultValues(methodElement);
        if (methodElement instanceof Activity) {
            Activity activity = (Activity)methodElement;
            VariabilityType variabilityType = activity.getVariabilityType();
            if (variabilityType == VariabilityType.CONTRIBUTES_LITERAL) {
                activity.setVariabilityType(VariabilityType.LOCAL_CONTRIBUTION_LITERAL);
            } else if (variabilityType == VariabilityType.REPLACES_LITERAL) {
                activity.setVariabilityType(VariabilityType.LOCAL_REPLACEMENT_LITERAL);
            }
        }
        if (!(this instanceof Migrator102_103)) {
            MigrationUtil.formatValue(methodElement);
        }
    }

    protected void initMigrate() {
    }

    protected void migrateDiagram(IProgressMonitor iProgressMonitor) throws Exception {
    }
}

