/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import com.ibm.icu.util.Calendar;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.common.utils.Timer;
import org.eclipse.epf.library.layout.DefaultContentValidator;
import org.eclipse.epf.library.layout.LinkInfo;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.services.PublishHTMLOptions;
import org.eclipse.epf.publishing.util.http.HttpUtil;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.osgi.util.NLS;

public class PublishingContentValidator
extends DefaultContentValidator {
    private boolean debug = PublishingPlugin.getDefault().isDebugging();
    protected PublishHTMLOptions options = null;
    static final String LOGS_FOLDER = "logs";
    static final String ERROR_LOG_FILENAME = "error.log";
    static final String WARNING_LOG_FILENAME = "warning.log";
    static final String INFO_LOG_FILENAME = "info.log";
    protected File logPath;
    protected boolean validateExternalLinks = false;
    protected List invalidExternalLinks = new ArrayList();
    protected List validatedExternalLinks = new ArrayList();
    protected List missingReferences = new ArrayList();
    protected List missingResources = new ArrayList();
    protected List discardedElements = new ArrayList();
    protected List validCategories = new ArrayList();
    protected long publishing_start = 0L;
    protected long time_for_external_link_checking = 0L;
    protected List referencedElements = new ArrayList();
    protected List publishedElements = new ArrayList();
    protected MethodElement defaultTarget = null;

    public PublishingContentValidator(String string, PublishHTMLOptions publishHTMLOptions) {
        super(string);
        this.options = publishHTMLOptions;
        this.validateExternalLinks = publishHTMLOptions.isCheckExternalLinks();
        this.logPath = new File(string, LOGS_FOLDER);
        this.info = this.getStream(INFO_LOG_FILENAME);
        this.warning = this.getStream(WARNING_LOG_FILENAME);
        this.error = this.getStream(ERROR_LOG_FILENAME);
        this.publishing_start = Calendar.getInstance().getTimeInMillis();
    }

    public void dispose() {
        this.invalidExternalLinks.clear();
        this.validatedExternalLinks.clear();
        this.missingReferences.clear();
        this.missingResources.clear();
        this.discardedElements.clear();
        this.validCategories.clear();
        this.referencedElements.clear();
        this.publishedElements.clear();
        this.info.close();
        this.warning.close();
        this.error.close();
    }

    protected PrintStream getStream(String string) {
        try {
            File file = new File(this.logPath, string);
            File file2 = file.getParentFile();
            file2.mkdirs();
            if (!file.exists()) {
                file.createNewFile();
            }
            return new PrintStream(new FileOutputStream(file), true);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public LinkInfo validateLink(MethodElement methodElement, String string, String string2, MethodConfiguration methodConfiguration, String string3) {
        String string4;
        LinkInfo linkInfo = super.validateLink(methodElement, string, string2, methodConfiguration, string3);
        if (this.validateExternalLinks && (string4 = linkInfo.getUrl()) != null && ResourceHelper.isExternalLink((String)string4) && !string4.startsWith("ftp://") && !this.validatedExternalLinks.contains(string4)) {
            Timer timer = new Timer();
            try {
                HttpUtil.doGet(string4, null, 6000);
            }
            catch (UnknownHostException unknownHostException) {
                this.logInvalidExternalLink(methodElement, string4, null);
            }
            catch (Exception exception) {
                this.logInvalidExternalLink(methodElement, string4, exception.getMessage());
            }
            timer.stop();
            this.time_for_external_link_checking += (long)timer.getTime();
            this.validatedExternalLinks.add(string4);
            this.logInfo(methodElement, NLS.bind((String)PublishingResources.externalUrl_msg, (Object[])new Object[]{new Integer(timer.getTime()), string4}));
        }
        return linkInfo;
    }

    public void logMissingReference(MethodElement methodElement, MethodElement methodElement2) {
        super.logMissingReference(methodElement, methodElement2);
        this.missingReferences.add(new MissingReference(methodElement, methodElement2));
    }

    public void logMissingReference(MethodElement methodElement, String string, String string2) {
        super.logMissingReference(methodElement, string, string2);
        this.missingReferences.add(new MissingReference(methodElement, string, string2));
    }

    public void logMissingResource(MethodElement methodElement, File file, String string) {
        super.logMissingResource(methodElement, file, string);
        this.missingResources.add(new MissingResource(methodElement, file, string));
    }

    public void logInvalidExternalLink(MethodElement methodElement, String string, String string2) {
        super.logInvalidExternalLink(methodElement, string, string2);
        this.invalidExternalLinks.add(new InvalidExternalLinkInfo(methodElement, string, string2));
    }

    public XmlElement getReport() {
        Object object;
        Object object2;
        XmlElement xmlElement = new XmlElement("validatorInfo");
        if (this.invalidExternalLinks.size() > 0) {
            object2 = String.valueOf(this.time_for_external_link_checking / 1000L) + " seconds validating external links";
            System.out.println((String)object2);
            this.logInfo((String)object2);
            object = xmlElement.newChild("invalidExternalLinks");
            for (Object object3 : this.invalidExternalLinks) {
                object.newChild("entry").setAttribute("url", ((InvalidExternalLinkInfo)object3).url).setAttribute("owner", ((InvalidExternalLinkInfo)object3).owner == null ? "" : LibraryUtil.getLocalizeTypeName((MethodElement)((InvalidExternalLinkInfo)object3).owner)).setAttribute("message", ((InvalidExternalLinkInfo)object3).message);
            }
        }
        if (this.missingReferences.size() > 0) {
            object2 = xmlElement.newChild("invalidReferences");
            object = xmlElement.newChild("missingReferences");
            for (Object object3 : this.missingReferences) {
                if (((MissingReference)object3).refElement == null) {
                    object2.newChild("entry").setAttribute("element", ((MissingReference)object3).linkedText).setAttribute("guid", ((MissingReference)object3).guid).setAttribute("owner", ((MissingReference)object3).owner == null ? "" : LibraryUtil.getLocalizeTypeName((MethodElement)((MissingReference)object3).owner));
                    continue;
                }
                object.newChild("entry").setAttribute("element", ((MissingReference)object3).refElement == null ? "" : LibraryUtil.getLocalizeTypeName((MethodElement)((MissingReference)object3).refElement)).setAttribute("guid", ((MissingReference)object3).refElement.getGuid()).setAttribute("owner", ((MissingReference)object3).owner == null ? "" : LibraryUtil.getLocalizeTypeName((MethodElement)((MissingReference)object3).owner));
            }
        }
        if (this.missingResources.size() > 0) {
            object2 = xmlElement.newChild("missingResources");
            for (Iterator iterator : this.missingResources) {
                object2.newChild("entry").setAttribute("url", ((MissingResource)((Object)iterator)).url).setAttribute("resource", ((MissingResource)((Object)iterator)).resourceFile == null ? "" : ((MissingResource)((Object)iterator)).resourceFile.getPath()).setAttribute("owner", ((MissingResource)((Object)iterator)).owner == null ? "" : LibraryUtil.getLocalizeTypeName((MethodElement)((MissingResource)((Object)iterator)).owner));
            }
        }
        long l = (Calendar.getInstance().getTimeInMillis() - this.publishing_start) / 1000L;
        int n = (int)l / 60;
        int n2 = (int)l - n * 60;
        this.logInfo("Publishing time: " + n + " minutes " + n2 + " seconds");
        return xmlElement;
    }

    public void addValidCategory(ContentCategory contentCategory) {
        if (!this.validCategories.contains(contentCategory)) {
            this.validCategories.add(contentCategory);
        }
    }

    public boolean isDiscarded(MethodElement methodElement, Object object, MethodElement methodElement2) {
        if (this.discardedElements.contains(methodElement2)) {
            return true;
        }
        if (methodElement2 instanceof ContentCategory) {
            if (this.validCategories.contains(methodElement2)) {
                return false;
            }
            return false;
        }
        return false;
    }

    public void addReferencedElement(MethodElement methodElement, MethodElement methodElement2) {
        if (methodElement2 == null) {
            return;
        }
        if (this.isDiscarded(methodElement, null, methodElement2)) {
            if (this.debug) {
                System.out.println("Element is discarded: " + LibraryUtil.getLocalizeTypeName((MethodElement)methodElement2));
            }
            return;
        }
        if (methodElement2 != null && !this.referencedElements.contains(methodElement2) && !this.publishedElements.contains(methodElement2)) {
            this.referencedElements.add(methodElement2);
            this.logReference(methodElement, methodElement2);
        }
    }

    public void logReference(MethodElement methodElement, MethodElement methodElement2) {
        if (this.debug) {
            System.out.println("--- Referenece Element Added: " + LibraryUtil.getLocalizeTypeName((MethodElement)methodElement2));
        }
    }

    public void removeReferencedElement(MethodElement methodElement) {
        if (this.referencedElements.contains(methodElement)) {
            this.referencedElements.remove(methodElement);
            if (this.debug) {
                System.out.println("--- Reference Element Removed: " + LibraryUtil.getLocalizeTypeName((MethodElement)methodElement));
            }
        }
    }

    public List getReferencedElements() {
        return this.referencedElements;
    }

    public void setDiscardedElement(MethodElement methodElement) {
        if (methodElement == null) {
            return;
        }
        if (!this.discardedElements.contains(methodElement)) {
            this.discardedElements.add(methodElement);
        }
        this.removeReferencedElement(methodElement);
    }

    public boolean isReferencedElement(MethodElement methodElement) {
        return methodElement != null && this.referencedElements.contains(methodElement);
    }

    public List getPublishedElements() {
        return this.publishedElements;
    }

    public void setTargetElement(MethodElement methodElement) {
        this.defaultTarget = methodElement;
    }

    public boolean hasClosure() {
        return false;
    }

    public boolean inClosure(MethodElement methodElement) {
        return true;
    }

    public void addClosureElements(List list) {
    }

    public void makeElementClosure() {
    }

    public boolean showBrokenLinks() {
        return !this.options.isConvertBrokenLinks();
    }

    public boolean showExtraInfoForDescriptors() {
        return this.options.isShowMethodContentInDescriptors();
    }

    public boolean showRelatedDescriptors() {
        return this.options.showRelatedDescriptors;
    }

    public String getDefaultActivityTab() {
        return this.options.getDefaultActivityTab();
    }

    class InvalidExternalLinkInfo {
        public MethodElement owner;
        public String url;
        public String message;

        public InvalidExternalLinkInfo(MethodElement methodElement, String string, String string2) {
            this.owner = methodElement;
            this.url = string;
            this.message = string2;
        }
    }

    class MissingReference {
        public MethodElement owner;
        public MethodElement refElement;
        public String guid;
        public String linkedText;

        public MissingReference(MethodElement methodElement, MethodElement methodElement2) {
            this.owner = methodElement;
            this.refElement = methodElement2;
        }

        public MissingReference(MethodElement methodElement, String string, String string2) {
            this.owner = methodElement;
            this.guid = string;
            this.linkedText = string2;
        }
    }

    class MissingResource {
        public MethodElement owner;
        public File resourceFile;
        public String url;

        public MissingResource(MethodElement methodElement, File file, String string) {
            this.owner = methodElement;
            this.resourceFile = file;
            this.url = string;
        }
    }
}

