/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services.index;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.epf.publishing.services.index.Def;
import org.eclipse.epf.publishing.services.index.Document;
import org.eclipse.epf.publishing.services.index.FontObject;
import org.eclipse.epf.publishing.services.index.HelpMessages;
import org.eclipse.epf.publishing.services.index.IO;
import org.eclipse.epf.publishing.services.index.KeyWord;
import org.eclipse.epf.publishing.services.index.KeyWordDef;
import org.eclipse.epf.publishing.services.index.KeyWordFile;
import org.eclipse.epf.publishing.services.index.KeyWordIndexHelper;
import org.eclipse.epf.publishing.services.index.MiscStatic;

class KeyWordHolder {
    private static final String lang = Locale.getDefault().getLanguage();
    private Vector keyWordFiles = new Vector();
    private Vector keyWords = null;

    KeyWordHolder() {
    }

    void add(KeyWordFile keyWordFile) {
        this.keyWordFiles.addElement(keyWordFile);
    }

    void divide() {
        if (this.keyWordFiles != null) {
            int n = 0;
            while (n < this.keyWordFiles.size()) {
                String string = "";
                KeyWordFile keyWordFile = (KeyWordFile)this.keyWordFiles.elementAt(n);
                while (string != null) {
                    string = null;
                    KeyWordDef keyWordDef = keyWordFile.getNextKeyWord();
                    if (keyWordDef != null) {
                        string = keyWordDef.toString();
                    }
                    if (string == null) continue;
                    int n2 = 1;
                    Document document = keyWordFile.getDocument(string, n2);
                    while (document != null) {
                        KeyWord keyWord;
                        int n3 = MiscStatic.getIndex(string, KeyWordIndexHelper.defObj.levelSeparatorReplace, 0);
                        if (n3 == -1) {
                            n3 = string.length();
                        }
                        if ((keyWord = this.createKeyWord(keyWordDef)) != null && document != null) {
                            keyWord.addKeyWord(keyWordDef, string, document);
                        }
                        document = keyWordFile.getDocument(string, ++n2);
                    }
                }
                ++n;
            }
        }
    }

    private KeyWord createKeyWord(KeyWordDef keyWordDef) {
        if (this.keyWords == null) {
            this.keyWords = new Vector();
            KeyWord keyWord = new KeyWord(keyWordDef);
            this.keyWords.addElement(keyWord);
            return keyWord;
        }
        int n = -1;
        int n2 = 0;
        KeyWord keyWord = new KeyWord(keyWordDef);
        String string = keyWord.getKeyWord();
        while (n == -1 && n2 < this.keyWords.size()) {
            KeyWord keyWord2 = (KeyWord)this.keyWords.elementAt(n2);
            String string2 = keyWord2.getKeyWord();
            int n3 = string.toUpperCase().compareTo(string2.toUpperCase());
            if (n3 < 0) {
                n = n2;
            } else if (n3 == 0) {
                int n4 = string.compareTo(string2);
                if (n4 != 0) {
                    if (n4 < 0) {
                        n = n2;
                    }
                } else {
                    return keyWord2;
                }
            }
            ++n2;
        }
        if (n == -1) {
            n = this.keyWords.size();
        }
        this.keyWords.insertElementAt(keyWord, n);
        return keyWord;
    }

    void readSpecKeyWords(StringTokenizer stringTokenizer) {
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            String string2 = stringTokenizer.nextToken().trim();
            KeyWordDef keyWordDef = new KeyWordDef(string);
            new KeyWordDef(string2);
            string = keyWordDef.toString();
            string2 = string2.toString();
            if (string == null || string2 == null || !this.relatedKeyWordExists(string, string2)) continue;
            boolean bl = false;
            int n = 0;
            String string3 = string;
            int n2 = string.indexOf(KeyWordIndexHelper.defObj.levelSeparatorReplace, 0);
            if (n2 != -1) {
                string3 = string.substring(0, n2);
            }
            IO.printDebug("firstKeyWord " + string3);
            while (!bl && n < this.keyWords.size()) {
                IO.printDebug("holder in first while " + n);
                KeyWord keyWord = (KeyWord)this.keyWords.elementAt(n);
                if (string3.equals(keyWord.getKeyWord())) {
                    bl = true;
                    if (n2 != -1) {
                        keyWord.insertSpecKeyWord(string.substring(n2 + 1), string2);
                    } else {
                        keyWord.setSpecKeyWord(string2, false);
                    }
                }
                ++n;
            }
            if (bl) continue;
            IO.printDebug("!found");
            int n3 = -1;
            n = 0;
            KeyWord keyWord = new KeyWord(keyWordDef);
            if (n2 == -1) {
                keyWord.setSpecKeyWord(string2, true);
            } else {
                keyWord.insertSpecKeyWord(string.substring(n2 + 1), string2);
            }
            while (n3 == -1 && n < this.keyWords.size()) {
                IO.printDebug("holder in second while " + n);
                KeyWord keyWord2 = (KeyWord)this.keyWords.elementAt(n);
                if (keyWord.getKeyWord().toUpperCase().compareTo(keyWord2.getKeyWord().toUpperCase()) < 0) {
                    n3 = n;
                } else if (keyWord.getKeyWord().toUpperCase().compareTo(keyWord2.getKeyWord().toUpperCase()) == 0 && keyWord.getKeyWord().compareTo(keyWord2.getKeyWord()) != 0) {
                    n3 = keyWord.getKeyWord().compareTo(keyWord2.getKeyWord()) > 0 ? n : n - 1;
                }
                ++n;
            }
            if (n3 != -1) {
                this.keyWords.insertElementAt(keyWord, n3);
                continue;
            }
            this.keyWords.insertElementAt(keyWord, this.keyWords.size());
        }
    }

    private boolean relatedKeyWordExists(String string, String string2) {
        if (this.keyWords != null) {
            int n = 0;
            while (n < this.keyWords.size()) {
                KeyWord keyWord = (KeyWord)this.keyWords.elementAt(n);
                if (keyWord.getKeyWord().equals(string2)) {
                    return true;
                }
                ++n;
            }
        }
        System.err.println(String.valueOf(string2) + HelpMessages.RELATED_KEYWORD_NOT_FOUND + string);
        return false;
    }

    void print() {
        if (KeyWordIndexHelper.defObj.getIndexResultFile() != null) {
            this.printFrameset();
            this.printIndex();
        }
        this.printKeyWords();
    }

    private void printFrameset() {
        try {
            File file = new File(String.valueOf(KeyWordIndexHelper.defObj.getWwwRoot()) + KeyWordIndexHelper.defObj.getMainResultFile());
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            OutputStreamWriter outputStreamWriter = KeyWordIndexHelper.defObj.getCharacterSet() != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), KeyWordIndexHelper.defObj.getCharacterSet()) : new OutputStreamWriter(new FileOutputStream(file));
            System.out.println(String.valueOf(HelpMessages.WRITE_FILE) + KeyWordIndexHelper.defObj.getWwwRoot() + KeyWordIndexHelper.defObj.getMainResultFile());
            MiscStatic.print(outputStreamWriter, "<html lang=\"" + lang + "\" xml:lang=\"" + lang + "\">\n");
            MiscStatic.print(outputStreamWriter, "<head>\n");
            MiscStatic.print(outputStreamWriter, "<META http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
            MiscStatic.print(outputStreamWriter, "<title>" + KeyWordIndexHelper.defObj.getIndexTitle() + "</title>\n");
            MiscStatic.print(outputStreamWriter, "</head>\n");
            new File(String.valueOf(KeyWordIndexHelper.defObj.getWwwRoot()) + KeyWordIndexHelper.defObj.getKeywordResultFile());
            String string = String.valueOf(KeyWordIndexHelper.defObj.getRelativePath()) + KeyWordIndexHelper.defObj.getKeywordResultFile();
            new File(String.valueOf(KeyWordIndexHelper.defObj.getWwwRoot()) + KeyWordIndexHelper.defObj.getIndexResultFile());
            String string2 = String.valueOf(KeyWordIndexHelper.defObj.getRelativePath()) + KeyWordIndexHelper.defObj.getIndexResultFile();
            MiscStatic.print(outputStreamWriter, "<frameset rows=\"" + KeyWordIndexHelper.defObj.getIndexHeight() + ",*\">\n");
            MiscStatic.print(outputStreamWriter, "<frame name=\"" + KeyWordIndexHelper.defObj.getIndexTarget() + "\" title=\"Navigation bar\" src=\"" + string2 + "\" marginheight=\"2\" marginwidth=\"2\" scrolling=\"auto\">\n");
            MiscStatic.print(outputStreamWriter, "<frame name=\"" + KeyWordIndexHelper.defObj.getKeyWordTarget() + "\" title=\"Contents\" src=\"" + string + "\" marginheight=\"0\" marginwidth=\"2\" scrolling=\"auto\">\n");
            MiscStatic.print(outputStreamWriter, "</frameset>\n");
            MiscStatic.print(outputStreamWriter, "</html>");
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            System.err.println("KeyWordHolder:printFrameset\n" + HelpMessages.EXCEPTION + exception.toString());
        }
    }

    private void printIndex() {
        try {
            File file = new File(String.valueOf(KeyWordIndexHelper.defObj.getWwwRoot()) + KeyWordIndexHelper.defObj.getIndexResultFile());
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            OutputStreamWriter outputStreamWriter = KeyWordIndexHelper.defObj.getCharacterSet() != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), KeyWordIndexHelper.defObj.getCharacterSet()) : new OutputStreamWriter(new FileOutputStream(file));
            System.out.println(String.valueOf(HelpMessages.WRITE_FILE) + KeyWordIndexHelper.defObj.getWwwRoot() + KeyWordIndexHelper.defObj.getIndexResultFile());
            MiscStatic.print(outputStreamWriter, "<html lang=\"" + lang + "\" xml:lang=\"" + lang + "\">\n");
            MiscStatic.print(outputStreamWriter, "<head>\n");
            MiscStatic.print(outputStreamWriter, "<META http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
            MiscStatic.print(outputStreamWriter, "</head><BODY>\n");
            String string = "";
            if (this.keyWords != null) {
                new File(String.valueOf(KeyWordIndexHelper.defObj.getWwwRoot()) + KeyWordIndexHelper.defObj.getKeywordResultFile());
                String string2 = String.valueOf(KeyWordIndexHelper.defObj.getRelativePath()) + KeyWordIndexHelper.defObj.getKeywordResultFile();
                int n = 0;
                while (n < this.keyWords.size()) {
                    KeyWord keyWord = (KeyWord)this.keyWords.elementAt(n);
                    String string3 = keyWord.getKeyWord().substring(0, 1).toUpperCase();
                    if (string3.compareTo(string) != 0) {
                        string = string3;
                        MiscStatic.print(outputStreamWriter, "<A HREF=\"" + string2 + "#");
                        MiscStatic.print(outputStreamWriter, string);
                        MiscStatic.print(outputStreamWriter, "\" TARGET=\"" + KeyWordIndexHelper.defObj.getKeyWordTarget() + "\">");
                        MiscStatic.print(outputStreamWriter, string);
                        MiscStatic.print(outputStreamWriter, "</A>\n");
                    }
                    ++n;
                }
            }
            MiscStatic.print(outputStreamWriter, "</BODY></html>");
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            System.err.println("KeyWordHolder:printIndex\n" + HelpMessages.EXCEPTION + exception.toString());
        }
    }

    private void printKeyWords() {
        try {
            String string;
            File file = new File(String.valueOf(KeyWordIndexHelper.defObj.getWwwRoot()) + KeyWordIndexHelper.defObj.getKeywordResultFile());
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            OutputStreamWriter outputStreamWriter = KeyWordIndexHelper.defObj.getCharacterSet() != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), KeyWordIndexHelper.defObj.getCharacterSet()) : new OutputStreamWriter(new FileOutputStream(file));
            System.out.println(String.valueOf(HelpMessages.WRITE_FILE) + KeyWordIndexHelper.defObj.getWwwRoot() + KeyWordIndexHelper.defObj.getKeywordResultFile());
            String string2 = MiscStatic.loadFile(KeyWordIndexHelper.defObj.getHeaderFile(), KeyWordIndexHelper.defObj.getCharacterSet());
            if (string2.equalsIgnoreCase(Def.None)) {
                System.err.println(String.valueOf(HelpMessages.INCORRECT_HEADERFILE) + KeyWordIndexHelper.defObj.getHeaderFile());
            }
            MiscStatic.print(outputStreamWriter, string2);
            String string3 = "";
            if (this.keyWords != null) {
                int n = 0;
                while (n < this.keyWords.size()) {
                    KeyWord keyWord = (KeyWord)this.keyWords.elementAt(n);
                    String string4 = keyWord.getKeyWord().substring(0, 1).toUpperCase();
                    if (string4.compareTo(string3) != 0) {
                        string3 = string4;
                        FontObject fontObject = KeyWordIndexHelper.defObj.getStyleSheet(Def.HeadLineStyle);
                        if (fontObject == null) {
                            fontObject = KeyWordIndexHelper.defObj.getStyleSheet(Def.DefaultStyle);
                        }
                        FontObject fontObject2 = null;
                        FontObject fontObject3 = fontObject;
                        if (fontObject == null) {
                            fontObject2 = KeyWordIndexHelper.defObj.getFont(Def.HeadLineFont);
                            if (fontObject2 == null) {
                                fontObject2 = KeyWordIndexHelper.defObj.getFont(Def.DefaultFont);
                            }
                            fontObject3 = fontObject2;
                        }
                        KeyWordIndexHelper.defObj.printStart(outputStreamWriter, fontObject3);
                        if (fontObject == null) {
                            MiscStatic.print(outputStreamWriter, "<BR>");
                        }
                        MiscStatic.print(outputStreamWriter, "<A NAME=\"" + string3 + "\">" + string3 + "</A>");
                        if (fontObject == null) {
                            MiscStatic.print(outputStreamWriter, "<BR>");
                        }
                        KeyWordIndexHelper.defObj.printEnd(outputStreamWriter, fontObject3);
                    }
                    keyWord.print(outputStreamWriter, 0);
                    ++n;
                }
            }
            if ((string = MiscStatic.loadFile(KeyWordIndexHelper.defObj.getFooterFile(), KeyWordIndexHelper.defObj.getCharacterSet())).equalsIgnoreCase(Def.None)) {
                System.err.println(String.valueOf(HelpMessages.INCORRECT_FOOTERFILE) + KeyWordIndexHelper.defObj.getFooterFile());
            }
            MiscStatic.print(outputStreamWriter, string);
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            System.err.println("KeyWordHolder:printKeyWords\n" + HelpMessages.EXCEPTION + exception.toString());
            exception.printStackTrace();
        }
    }
}

