/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.layout.util.XmlHelper;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishingUtil {
    public static void jarFiles(File file, File file2) throws IOException {
        File[] fileArray = file.listFiles();
        if (file2.exists()) {
            file2.delete();
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedOutputStream);
        byte[] byArray = new byte[4096];
        int n = 0;
        while (n < fileArray.length) {
            File file3 = fileArray[n];
            if (!file3.isDirectory()) {
                ZipEntry zipEntry = new ZipEntry(file3.getName());
                zipOutputStream.putNextEntry(zipEntry);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file3));
                while (bufferedInputStream.available() > 0) {
                    int n2 = bufferedInputStream.read(byArray);
                    zipOutputStream.write(byArray, 0, n2);
                }
                bufferedInputStream.close();
                zipOutputStream.closeEntry();
            }
            ++n;
        }
        zipOutputStream.close();
        bufferedOutputStream.close();
    }

    public static String getHtml(XmlElement xmlElement, String string) {
        URL uRL;
        block3: {
            try {
                Locale locale = Locale.getDefault();
                String string2 = locale.getLanguage();
                xmlElement.setAttribute("lang", string2);
                uRL = new URL(PublishingPlugin.getDefault().getInstallURL(), string);
                if (uRL != null) break block3;
                PublishingPlugin.getDefault().getLogger().logError("Unable to access XSL template " + string);
                return null;
            }
            catch (Exception exception) {
                PublishingPlugin.getDefault().getLogger().logError("Unable to generate HTML", (Throwable)exception);
                return null;
            }
        }
        String string3 = FileLocator.resolve((URL)uRL).getPath();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XmlHelper.XML_HEADER).append(xmlElement.toXml());
        Properties properties = PublishingPlugin.getDefault().getProperties("/xsl/resources.properties");
        StringWriter stringWriter = new StringWriter();
        XSLTProcessor.transform((String)string3, (String)stringBuffer.toString(), (Properties)properties, (Writer)stringWriter);
        stringWriter.flush();
        return ResourceHelper.decodeUrlsInContent((String)stringWriter.getBuffer().toString());
    }

    public static boolean hasValidProcessView(MethodConfiguration methodConfiguration, Process process) {
        for (ContentCategory contentCategory : methodConfiguration.getProcessViews()) {
            if (!(contentCategory instanceof CustomCategory)) continue;
            CustomCategory customCategory = (CustomCategory)contentCategory;
            for (DescribableElement describableElement : customCategory.getCategorizedElements()) {
                if (!(describableElement instanceof Process) || ((Process)describableElement).getGuid() != process.getGuid()) continue;
                return true;
            }
        }
        return false;
    }

    public static void unloadResources(Collection<Resource> collection) {
        PersistenceUtil.unload(collection);
    }

    public static void disposeDiagramManagers(Collection<DiagramManager> collection, Collection<DiagramManager> collection2) {
        for (DiagramManager diagramManager : collection) {
            if (collection2 != null && collection2.contains(diagramManager)) continue;
            diagramManager.dispose();
        }
    }
}

