/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Point;

public class Layer
extends Figure {
    public boolean containsPoint(int x, int y) {
        if (this.isOpaque()) {
            return super.containsPoint(x, y);
        }
        Point pt = new Point(x, y);
        this.translateFromParent(pt);
        int i = 0;
        while (i < this.getChildren().size()) {
            IFigure child = (IFigure)this.getChildren().get(i);
            if (child.containsPoint(pt.x, pt.y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        if (!this.isEnabled()) {
            return null;
        }
        if (this.isOpaque()) {
            return super.findFigureAt(x, y, search);
        }
        IFigure f = super.findFigureAt(x, y, search);
        if (f == this) {
            return null;
        }
        return f;
    }
}

